/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandler;
import org.apache.felix.ipojo.util.Property;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ProvidedService
implements ServiceFactory {
    public static final int REGISTERED = 1;
    public static final int UNREGISTERED = 0;
    public static final int SINGLETON_FACTORY = 0;
    public static final int SERVICE_FACTORY = 1;
    public static final int STATIC_FACTORY = 2;
    private String[] m_serviceSpecification = new String[0];
    private int m_factoryPolicy = 0;
    private ServiceRegistration m_serviceRegistration;
    private ProvidedServiceHandler m_handler;
    private Property[] m_properties;
    static /* synthetic */ Class class$java$lang$String;

    public ProvidedService(ProvidedServiceHandler handler, String[] specification, int factoryPolicy) {
        this.m_handler = handler;
        this.m_serviceSpecification = specification;
        this.m_factoryPolicy = factoryPolicy;
        try {
            this.addProperty(new Property("instance.name", null, null, handler.getInstanceManager().getInstanceName(), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
            this.addProperty(new Property("factory.name", null, null, handler.getInstanceManager().getFactory().getFactoryName(), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
        }
        catch (ConfigurationException e) {
            this.m_handler.error("An exception occurs when adding instance.name and factory.name property : " + e.getMessage());
        }
    }

    protected void setProperties(Property[] props) {
        for (int i = 0; i < props.length; ++i) {
            this.addProperty(props[i]);
        }
    }

    private synchronized void addProperty(Property prop) {
        for (int i = 0; this.m_properties != null && i < this.m_properties.length; ++i) {
            if (this.m_properties[i] != prop) continue;
            return;
        }
        if (this.m_properties == null) {
            this.m_properties = new Property[]{prop};
        } else {
            Property[] newProp = new Property[this.m_properties.length + 1];
            System.arraycopy(this.m_properties, 0, newProp, 0, this.m_properties.length);
            newProp[this.m_properties.length] = prop;
            this.m_properties = newProp;
        }
    }

    private synchronized void removeProperty(String name) {
        int idx = -1;
        for (int i = 0; i < this.m_properties.length; ++i) {
            if (!this.m_properties[i].getName().equals(name)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            if (this.m_properties.length - 1 == 0) {
                this.m_properties = null;
            } else {
                Property[] newPropertiesList = new Property[this.m_properties.length - 1];
                System.arraycopy(this.m_properties, 0, newPropertiesList, 0, idx);
                if (idx < newPropertiesList.length) {
                    System.arraycopy(this.m_properties, idx + 1, newPropertiesList, idx, newPropertiesList.length - idx);
                }
                this.m_properties = newPropertiesList;
            }
        }
    }

    public ServiceReference getServiceReference() {
        if (this.m_serviceRegistration == null) {
            return null;
        }
        return this.m_serviceRegistration.getReference();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        Object svc = null;
        switch (this.m_factoryPolicy) {
            case 0: {
                svc = this.m_handler.getInstanceManager().getPojoObject();
                break;
            }
            case 1: {
                svc = this.m_handler.getInstanceManager().createPojoObject();
                break;
            }
            case 2: {
                svc = this.m_handler.getInstanceManager().createPojoObject();
                break;
            }
            default: {
                this.m_handler.error("[" + this.m_handler.getInstanceManager().getClassName() + "] Unknown factory policy for " + this.m_serviceSpecification + " : " + this.m_factoryPolicy);
                this.getInstanceManager().stop();
            }
        }
        return svc;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    protected synchronized void registerService() {
        if (this.m_serviceRegistration == null) {
            Properties serviceProperties = this.getServiceProperties();
            this.m_serviceRegistration = this.m_handler.getInstanceManager().getContext().registerService(this.m_serviceSpecification, (Object)this, (Dictionary)serviceProperties);
        }
    }

    protected synchronized void unregisterService() {
        if (this.m_serviceRegistration != null) {
            this.m_serviceRegistration.unregister();
            this.m_serviceRegistration = null;
        }
    }

    public int getState() {
        if (this.m_serviceRegistration == null) {
            return 0;
        }
        return 1;
    }

    protected InstanceManager getInstanceManager() {
        return this.m_handler.getInstanceManager();
    }

    private Properties getServiceProperties() {
        Properties serviceProperties = new Properties();
        for (int i = 0; i < this.m_properties.length; ++i) {
            if (this.m_properties[i].getValue() == null) continue;
            serviceProperties.put(this.m_properties[i].getName(), this.m_properties[i].getValue());
        }
        return serviceProperties;
    }

    public Property[] getProperties() {
        return this.m_properties;
    }

    public synchronized void update() {
        if (this.m_serviceRegistration != null) {
            this.m_serviceRegistration.setProperties((Dictionary)this.getServiceProperties());
        }
    }

    protected void addProperties(Dictionary props) {
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = props.get(key);
            try {
                Property prop = new Property(key, null, null, value.toString(), value.getClass().getName(), this.getInstanceManager(), this.m_handler);
                this.addProperty(prop);
            }
            catch (ConfigurationException e) {
                this.m_handler.error("The propagated property " + key + " cannot be pcreated correctly : " + e.getMessage());
            }
        }
    }

    protected void deleteProperties(Dictionary props) {
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeProperty(key);
        }
    }

    public String[] getServiceSpecification() {
        return this.m_serviceSpecification;
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_serviceRegistration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

