/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.architecture;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class ComponentTypeDescription {
    private String[] m_providedServiceSpecification = new String[0];
    private PropertyDescription[] m_properties = new PropertyDescription[0];
    private final Factory m_factory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    public ComponentTypeDescription(Factory factory) {
        this.m_factory = factory;
    }

    public String toString() {
        return this.getDescription().toString();
    }

    public String getClassName() {
        return this.m_factory.getClassName();
    }

    public PropertyDescription[] getProperties() {
        return this.m_properties;
    }

    public void addProperty(String name, String value) {
        this.addProperty(name, value, false);
    }

    public void addProperty(String name, String value, boolean immutable) {
        PropertyDescription prop = new PropertyDescription(name, (class$java$lang$String == null ? (class$java$lang$String = ComponentTypeDescription.class$("java.lang.String")) : class$java$lang$String).getName(), value);
        this.addProperty(prop);
    }

    public void addProperty(PropertyDescription pd) {
        String name = pd.getName();
        if ("name".equals(name)) {
            pd = new PropertyDescription(name, pd.getType(), null);
        }
        for (int i = 0; i < this.m_properties.length; ++i) {
            PropertyDescription desc = this.m_properties[i];
            if (!desc.getName().equals(name)) continue;
            return;
        }
        PropertyDescription[] newProps = new PropertyDescription[this.m_properties.length + 1];
        System.arraycopy(this.m_properties, 0, newProps, 0, this.m_properties.length);
        newProps[this.m_properties.length] = pd;
        this.m_properties = newProps;
    }

    public String[] getprovidedServiceSpecification() {
        return this.m_providedServiceSpecification;
    }

    public void addProvidedServiceSpecification(String serviceSpecification) {
        String[] newSs = new String[this.m_providedServiceSpecification.length + 1];
        System.arraycopy(this.m_providedServiceSpecification, 0, newSs, 0, this.m_providedServiceSpecification.length);
        newSs[this.m_providedServiceSpecification.length] = serviceSpecification;
        this.m_providedServiceSpecification = newSs;
    }

    public String getName() {
        return this.m_factory.getName();
    }

    public Dictionary getPropertiesToPublish() {
        Properties props = new Properties();
        props.put("factory.name", this.m_factory.getName());
        props.put("service.pid", this.m_factory.getName());
        props.put("component.providedServiceSpecifications", this.m_providedServiceSpecification);
        props.put("component.properties", this.m_properties);
        props.put("component.description", this);
        for (int i = 0; i < this.m_properties.length; ++i) {
            if (!this.m_properties[i].isImmutable() || this.m_properties[i].getValue() == null) continue;
            props.put(this.m_properties[i].getName(), this.m_properties[i].getObjectValue(this.m_factory.getBundleContext()));
        }
        props.put("factory.state", new Integer(this.m_factory.getState()));
        return props;
    }

    public String[] getFactoryInterfacesToPublish() {
        return new String[]{(class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = ComponentTypeDescription.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName(), (class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ComponentTypeDescription.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName()};
    }

    public Element getDescription() {
        int i;
        Element desc = new Element("Factory", "");
        desc.addAttribute(new Attribute("name", this.m_factory.getName()));
        desc.addAttribute(new Attribute("bundle", Long.toString(((ComponentFactory)this.m_factory).getBundleContext().getBundle().getBundleId())));
        String state = "valid";
        if (this.m_factory.getState() == 0) {
            state = "invalid";
        }
        desc.addAttribute(new Attribute("state", state));
        Element req = new Element("RequiredHandlers", "");
        req.addAttribute(new Attribute("list", this.m_factory.getRequiredHandlers().toString()));
        Element missing = new Element("MissingHandlers", "");
        missing.addAttribute(new Attribute("list", this.m_factory.getMissingHandlers().toString()));
        desc.addElement(req);
        desc.addElement(missing);
        for (i = 0; i < this.m_providedServiceSpecification.length; ++i) {
            Element prov = new Element("provides", "");
            prov.addAttribute(new Attribute("specification", this.m_providedServiceSpecification[i]));
            desc.addElement(prov);
        }
        for (i = 0; i < this.m_properties.length; ++i) {
            Element prop = new Element("property", "");
            prop.addAttribute(new Attribute("name", this.m_properties[i].getName()));
            prop.addAttribute(new Attribute("type", this.m_properties[i].getType()));
            if (this.m_properties[i].getValue() == null) {
                prop.addAttribute(new Attribute("value", "REQUIRED"));
            } else {
                prop.addAttribute(new Attribute("value", this.m_properties[i].getValue()));
            }
            desc.addElement(prop);
        }
        return desc;
    }

    public BundleContext getBundleContext() {
        return this.m_factory.getBundleContext();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

