/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.InstanceCreator;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Extender
implements SynchronousBundleListener,
BundleActivator {
    private static final String IPOJO_HEADER = "iPOJO-Components";
    private static final String IPOJO_EXTENSION = "IPOJO-Extension";
    private Logger m_logger;
    private BundleContext m_context;
    private InstanceCreator m_creator;
    private Bundle m_bundle;
    private List m_factoryTypes = new ArrayList();
    private final List m_unboundTypes = new ArrayList();
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;
    static /* synthetic */ Class class$org$apache$felix$ipojo$metadata$Element;

    public synchronized void bundleChanged(BundleEvent event) {
        if (event.getBundle() == this.m_bundle) {
            return;
        }
        switch (event.getType()) {
            case 2: {
                this.startManagementFor(event.getBundle());
                break;
            }
            case 256: {
                this.closeManagementFor(event.getBundle());
                break;
            }
        }
    }

    private void closeManagementFor(Bundle bundle) {
        ManagedAbstractFactoryType mft;
        ArrayList<ManagedAbstractFactoryType> toRemove = new ArrayList<ManagedAbstractFactoryType>();
        for (int k = 0; k < this.m_factoryTypes.size(); ++k) {
            mft = (ManagedAbstractFactoryType)this.m_factoryTypes.get(k);
            this.m_creator.removeInstancesFromBundle(bundle.getBundleId());
            if (mft.m_created != null) {
                List cfs = (List)mft.m_created.remove(bundle);
                for (int i = 0; cfs != null && i < cfs.size(); ++i) {
                    IPojoFactory factory = (IPojoFactory)cfs.get(i);
                    this.m_creator.removeFactory(factory);
                    factory.stop();
                }
            }
            if (mft.m_bundle != bundle) continue;
            if (mft.m_created != null) {
                Iterator iterator = mft.m_created.keySet().iterator();
                while (iterator.hasNext()) {
                    Bundle key = (Bundle)iterator.next();
                    List list = (List)mft.m_created.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        IPojoFactory factory = (IPojoFactory)list.get(i);
                        factory.stop();
                        this.m_unboundTypes.add(new UnboundComponentType(mft.m_type, factory.m_componentMetadata, factory.getBundleContext().getBundle()));
                    }
                }
            }
            toRemove.add(mft);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            mft = (ManagedAbstractFactoryType)toRemove.get(i);
            this.m_logger.log(3, "The factory type: " + mft.m_type + " is no more available");
            mft.m_bundle = null;
            mft.m_clazz = null;
            mft.m_created = null;
            mft.m_type = null;
            this.m_factoryTypes.remove(mft);
        }
    }

    private void startManagementFor(Bundle bundle) {
        String header;
        Dictionary dict = bundle.getHeaders();
        String typeHeader = (String)dict.get(IPOJO_EXTENSION);
        if (typeHeader != null) {
            this.parseAbstractFactoryType(bundle, typeHeader);
        }
        if ((header = (String)dict.get(IPOJO_HEADER)) != null) {
            try {
                this.parse(bundle, header);
            }
            catch (IOException e) {
                this.m_logger.log(1, "An exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
            }
            catch (ParseException e) {
                this.m_logger.log(1, "A parse exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
            }
        }
    }

    private void parseAbstractFactoryType(Bundle bundle, String header) {
        String[] arr = ParseUtils.split(header, ",");
        for (int i = 0; arr != null && i < arr.length; ++i) {
            Class clazz;
            String[] arr2 = ParseUtils.split(arr[i], ":");
            String type = arr2[0];
            try {
                clazz = bundle.loadClass(arr2[1]);
            }
            catch (ClassNotFoundException e) {
                this.m_logger.log(1, "Cannot load the extension " + type, e);
                return;
            }
            ManagedAbstractFactoryType mft = new ManagedAbstractFactoryType(clazz, type, bundle);
            this.m_factoryTypes.add(mft);
            this.m_logger.log(3, "New factory type available: " + type);
            for (int j = this.m_unboundTypes.size() - 1; j >= 0; --j) {
                UnboundComponentType unbound = (UnboundComponentType)this.m_unboundTypes.get(j);
                if (!unbound.m_type.equals(type)) continue;
                this.createAbstractFactory(unbound.m_bundle, unbound.m_description);
                this.m_unboundTypes.remove(unbound);
            }
        }
    }

    private void parse(Bundle bundle, String components) throws IOException, ParseException {
        ManifestMetadataParser parser = new ManifestMetadataParser();
        parser.parseHeader(components);
        Element[] metadata = parser.getComponentsMetadata();
        for (int i = 0; i < metadata.length; ++i) {
            this.createAbstractFactory(bundle, metadata[i]);
        }
        Dictionary[] instances = parser.getInstances();
        for (int i = 0; instances != null && i < instances.length; ++i) {
            this.m_creator.addInstance(instances[i], bundle.getBundleId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) {
        this.m_context = context;
        this.m_bundle = context.getBundle();
        this.m_creator = new InstanceCreator(context);
        this.m_logger = new Logger(this.m_context, "IPOJO Extender");
        this.startManagementFor(this.m_bundle);
        Extender extender = this;
        synchronized (extender) {
            this.m_context.addBundleListener((BundleListener)this);
            for (int i = 0; i < context.getBundles().length; ++i) {
                if (context.getBundles()[i].getState() != 32) continue;
                this.startManagementFor(context.getBundles()[i]);
            }
        }
    }

    public void stop(BundleContext context) {
        this.m_context.removeBundleListener((BundleListener)this);
        for (int k = 0; k < this.m_factoryTypes.size(); ++k) {
            ManagedAbstractFactoryType mft = (ManagedAbstractFactoryType)this.m_factoryTypes.get(k);
            if (mft.m_created == null) continue;
            Iterator iterator = mft.m_created.keySet().iterator();
            while (iterator.hasNext()) {
                Bundle key = (Bundle)iterator.next();
                List list = (List)mft.m_created.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    IPojoFactory factory = (IPojoFactory)list.get(i);
                    this.m_creator.removeFactory(factory);
                    factory.dispose();
                }
            }
        }
        this.m_factoryTypes = null;
        this.m_creator = null;
    }

    private void createAbstractFactory(Bundle bundle, Element metadata) {
        ManagedAbstractFactoryType factoryType = null;
        for (int i = 0; i < this.m_factoryTypes.size(); ++i) {
            ManagedAbstractFactoryType type = (ManagedAbstractFactoryType)this.m_factoryTypes.get(i);
            if (!type.m_type.equals(metadata.getName())) continue;
            factoryType = type;
            break;
        }
        if (factoryType == null) {
            this.m_logger.log(2, "Type of component not yet recognized : " + metadata.getName());
            this.m_unboundTypes.add(new UnboundComponentType(metadata.getName(), metadata, bundle));
            return;
        }
        Class clazz = factoryType.m_clazz;
        try {
            Constructor cst = clazz.getConstructor(class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = Extender.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext, class$org$apache$felix$ipojo$metadata$Element == null ? (class$org$apache$felix$ipojo$metadata$Element = Extender.class$("org.apache.felix.ipojo.metadata.Element")) : class$org$apache$felix$ipojo$metadata$Element);
            IPojoFactory factory = (IPojoFactory)cst.newInstance(this.getBundleContext(bundle), metadata);
            if (factoryType.m_created == null) {
                factoryType.m_created = new HashMap();
                ArrayList<IPojoFactory> list = new ArrayList<IPojoFactory>();
                list.add(factory);
                factoryType.m_created.put(bundle, list);
            } else {
                ArrayList<IPojoFactory> list = (ArrayList<IPojoFactory>)factoryType.m_created.get(bundle);
                if (list == null) {
                    list = new ArrayList<IPojoFactory>();
                    list.add(factory);
                    factoryType.m_created.put(bundle, list);
                } else {
                    list.add(factory);
                }
            }
            factory.start();
            this.m_creator.addFactory(factory);
        }
        catch (SecurityException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName() + ": the given class constructor cannot be found");
        }
        catch (IllegalArgumentException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (InstantiationException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e.getTargetException());
        }
    }

    public BundleContext getBundleContext(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Method meth = null;
        try {
            meth = bundle.getClass().getMethod("getBundleContext", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (meth == null) {
            try {
                meth = bundle.getClass().getMethod("getContext", new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (meth != null) {
            if (!meth.isAccessible()) {
                meth.setAccessible(true);
            }
            try {
                return (BundleContext)meth.invoke((Object)bundle, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), e);
                return null;
            }
            catch (InvocationTargetException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), e.getTargetException());
                return null;
            }
        }
        Field[] fields = bundle.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!(class$org$osgi$framework$BundleContext == null ? Extender.class$("org.osgi.framework.BundleContext") : class$org$osgi$framework$BundleContext).isAssignableFrom(fields[i].getType())) continue;
            if (!fields[i].isAccessible()) {
                fields[i].setAccessible(true);
            }
            try {
                return (BundleContext)fields[i].get(bundle);
            }
            catch (IllegalArgumentException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + fields[i].getName(), e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + fields[i].getName(), e);
                return null;
            }
        }
        this.m_logger.log(1, "Cannot find the BundleContext for " + bundle.getSymbolicName(), null);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class UnboundComponentType {
        private final Element m_description;
        private final Bundle m_bundle;
        private final String m_type;

        protected UnboundComponentType(String type, Element description, Bundle bundle) {
            this.m_type = type;
            this.m_description = description;
            this.m_bundle = bundle;
        }
    }

    private final class ManagedAbstractFactoryType {
        String m_type;
        Class m_clazz;
        Bundle m_bundle;
        private Map m_created;

        protected ManagedAbstractFactoryType(Class factory, String type, Bundle bundle) {
            this.m_bundle = bundle;
            this.m_clazz = factory;
            this.m_type = type;
        }
    }
}

