/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handler.extender;

import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public abstract class BundleTracker {
    final Set m_bundleSet = new HashSet();
    final BundleContext m_context;
    final SynchronousBundleListener m_listener;
    boolean m_open;

    public BundleTracker(BundleContext context) {
        this.m_context = context;
        this.m_listener = new SynchronousBundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent evt) {
                BundleTracker bundleTracker = BundleTracker.this;
                synchronized (bundleTracker) {
                    if (!BundleTracker.this.m_open) {
                        return;
                    }
                    if (evt.getType() == 2) {
                        if (!BundleTracker.this.m_bundleSet.contains(evt.getBundle())) {
                            BundleTracker.this.m_bundleSet.add(evt.getBundle());
                            BundleTracker.this.addedBundle(evt.getBundle());
                        }
                    } else if (evt.getType() == 4 && BundleTracker.this.m_bundleSet.contains(evt.getBundle())) {
                        BundleTracker.this.m_bundleSet.remove(evt.getBundle());
                        BundleTracker.this.removedBundle(evt.getBundle());
                    }
                }
            }
        };
    }

    public synchronized Bundle[] getBundles() {
        return this.m_bundleSet.toArray(new Bundle[this.m_bundleSet.size()]);
    }

    public synchronized void open() {
        if (!this.m_open) {
            this.m_open = true;
            this.m_context.addBundleListener((BundleListener)this.m_listener);
            Bundle[] bundles = this.m_context.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                if (bundles[i].getState() != 32) continue;
                this.m_bundleSet.add(bundles[i]);
                this.addedBundle(bundles[i]);
            }
        }
    }

    public synchronized void close() {
        if (this.m_open) {
            this.m_open = false;
            this.m_context.removeBundleListener((BundleListener)this.m_listener);
            Bundle[] bundles = this.m_bundleSet.toArray(new Bundle[this.m_bundleSet.size()]);
            for (int i = 0; i < bundles.length; ++i) {
                if (!this.m_bundleSet.remove(bundles[i])) continue;
                this.removedBundle(bundles[i]);
            }
        }
    }

    protected abstract void addedBundle(Bundle var1);

    protected abstract void removedBundle(Bundle var1);
}

