/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.manipulation.ConstructorCodeAdapter;
import org.apache.felix.ipojo.manipulation.ManipulationProperty;
import org.apache.felix.ipojo.manipulation.MethodCodeAdapter;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class MethodCreator
extends ClassAdapter
implements Opcodes {
    public static final String IM_FIELD = "__IM";
    private static final String PREFIX = "__";
    private static final String POJO = "org/apache/felix/ipojo/Pojo";
    private static final String FIELD_FLAG_PREFIX = "__F";
    private static final String METHOD_FLAG_PREFIX = "__M";
    private static final String ENTRY = "onEntry";
    private static final String EXIT = "onExit";
    private static final String ERROR = "onError";
    private static final String GET = "onGet";
    private static final String SET = "onSet";
    private String m_owner;
    private Set m_fields;
    private List m_methods = new ArrayList();
    private List m_methodFlags = new ArrayList();
    private List m_visitedMethods = new ArrayList();
    static /* synthetic */ Class class$java$lang$Throwable;

    public MethodCreator(ClassVisitor arg0, Map fields, List methods) {
        super(arg0);
        this.m_fields = fields.keySet();
        this.m_visitedMethods = methods;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.m_owner = name;
        this.addPOJOInterface(version, access, name, signature, superName, interfaces);
        this.addIMField();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>") || name.equals("class$")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (name.equals("<init>")) {
            MethodDescriptor md = this.getMethodDescriptor("$init", desc);
            String newDesc = desc.substring(1);
            newDesc = "(Lorg/apache/felix/ipojo/InstanceManager;" + newDesc;
            Type[] args = Type.getArgumentTypes(desc);
            if (args.length == 0) {
                this.generateEmptyConstructor(access, signature, exceptions, md.getAnnotations());
            } else if (args.length == 1 && args[0].getClassName().equals("org.osgi.framework.BundleContext")) {
                this.generateBCConstructor(access, signature, exceptions, md.getAnnotations());
            } else {
                return this.cv.visitMethod(access, name, desc, signature, exceptions);
            }
            MethodVisitor mv = super.visitMethod(2, "<init>", newDesc, signature, exceptions);
            return new ConstructorCodeAdapter(mv, this.m_owner, this.m_fields, 2, name, newDesc);
        }
        if ((access & 0x1000) == 4096 && name.startsWith("access$")) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new MethodCodeAdapter(mv, this.m_owner, access, name, desc, this.m_fields);
        }
        if ((access & 8) == 8) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodDescriptor md = this.getMethodDescriptor(name, desc);
        this.generateMethodHeader(access, name, desc, signature, exceptions, md.getAnnotations());
        String id = this.generateMethodFlag(name, desc);
        if (!this.m_methodFlags.contains(id)) {
            FieldVisitor flagField = this.cv.visitField(2, id, "Z", null, null);
            flagField.visitEnd();
            this.m_methodFlags.add(id);
        }
        MethodVisitor mv = super.visitMethod(2, PREFIX + name, desc, signature, exceptions);
        return new MethodCodeAdapter(mv, this.m_owner, 2, PREFIX + name, desc, this.m_fields);
    }

    private MethodDescriptor getMethodDescriptor(String name, String desc) {
        for (int i = 0; i < this.m_visitedMethods.size(); ++i) {
            MethodDescriptor md = (MethodDescriptor)this.m_visitedMethods.get(i);
            if (!md.getName().equals(name) || !md.getDescriptor().equals(desc)) continue;
            return md;
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 8) == 0) {
            FieldVisitor flag = this.cv.visitField(2, FIELD_FLAG_PREFIX + name, "Z", null, null);
            flag.visitEnd();
            Type type = Type.getType(desc);
            if (type.getSort() == 9) {
                String gDesc = "()" + desc;
                this.createArrayGetter(name, gDesc, type);
                String sDesc = "(" + desc + ")V";
                this.createArraySetter(name, sDesc, type);
            } else {
                String gDesc = "()" + desc;
                this.createSimpleGetter(name, gDesc, type);
                String sDesc = "(" + desc + ")V";
                this.createSimpleSetter(name, sDesc, type);
            }
        }
        return this.cv.visitField(access, name, desc, signature, value);
    }

    private void generateEmptyConstructor(int access, String signature, String[] exceptions, List annotations) {
        MethodVisitor mv = this.cv.visitMethod(access, "<init>", "()V", signature, exceptions);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitMethodInsn(183, this.m_owner, "<init>", "(Lorg/apache/felix/ipojo/InstanceManager;)V");
        mv.visitInsn(177);
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                ClassChecker.AnnotationDescriptor ad = (ClassChecker.AnnotationDescriptor)annotations.get(i);
                ad.visit(mv);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateBCConstructor(int access, String signature, String[] exceptions, List annotations) {
        MethodVisitor mv = this.cv.visitMethod(access, "<init>", "(Lorg/osgi/framework/BundleContext;)V", signature, exceptions);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.m_owner, "<init>", "(Lorg/apache/felix/ipojo/InstanceManager;Lorg/osgi/framework/BundleContext;)V");
        mv.visitInsn(177);
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                ClassChecker.AnnotationDescriptor ad = (ClassChecker.AnnotationDescriptor)annotations.get(i);
                ad.visit(mv);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateMethodHeader(int access, String name, String desc, String signature, String[] exceptions, List annotations) {
        GeneratorAdapter mv = new GeneratorAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
        mv.visitCode();
        Type returnType = Type.getReturnType(desc);
        int result = -1;
        int exception = -1;
        if (returnType.getSort() != 0) {
            result = mv.newLocal(returnType);
            exception = mv.newLocal(Type.getType(class$java$lang$Throwable == null ? (class$java$lang$Throwable = MethodCreator.class$("java.lang.Throwable")) : class$java$lang$Throwable));
        } else {
            exception = mv.newLocal(Type.getType(class$java$lang$Throwable == null ? (class$java$lang$Throwable = MethodCreator.class$("java.lang.Throwable")) : class$java$lang$Throwable));
        }
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Throwable");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, this.generateMethodFlag(name, desc), "Z");
        mv.visitJumpInsn(154, l0);
        mv.visitVarInsn(25, 0);
        mv.loadArgs();
        mv.visitMethodInsn(183, this.m_owner, PREFIX + name, desc);
        mv.visitInsn(returnType.getOpcode(172));
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(this.generateMethodId(name, desc));
        mv.loadArgArray();
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", ENTRY, "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.loadArgs();
        mv.visitMethodInsn(183, this.m_owner, PREFIX + name, desc);
        if (returnType.getSort() != 0) {
            mv.visitVarInsn(returnType.getOpcode(54), result);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(this.generateMethodId(name, desc));
        if (returnType.getSort() != 0) {
            mv.visitVarInsn(returnType.getOpcode(21), result);
            mv.box(returnType);
        } else {
            mv.visitInsn(1);
        }
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", EXIT, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
        mv.visitLabel(l1);
        Label l7 = new Label();
        mv.visitJumpInsn(167, l7);
        mv.visitLabel(l2);
        mv.visitVarInsn(58, exception);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(this.generateMethodId(name, desc));
        mv.visitVarInsn(25, exception);
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", ERROR, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Throwable;)V");
        mv.visitVarInsn(25, exception);
        mv.visitInsn(191);
        mv.visitLabel(l7);
        if (returnType.getSort() != 0) {
            mv.visitVarInsn(returnType.getOpcode(21), result);
        }
        mv.visitInsn(returnType.getOpcode(172));
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                ClassChecker.AnnotationDescriptor ad = (ClassChecker.AnnotationDescriptor)annotations.get(i);
                ad.visit(mv);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String generateMethodFlag(String name, String desc) {
        return METHOD_FLAG_PREFIX + this.generateMethodId(name, desc);
    }

    private String generateMethodId(String name, String desc) {
        StringBuffer id = new StringBuffer(name);
        Type[] args = Type.getArgumentTypes(desc);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].getClassName();
            if (arg.endsWith("[]")) {
                arg = arg.substring(0, arg.length() - 2);
                id.append("$" + arg.replace('.', '_') + PREFIX);
                continue;
            }
            id.append("$" + arg.replace('.', '_'));
        }
        if (!this.m_methods.contains(id.toString())) {
            this.m_methods.add(id.toString());
        }
        return id.toString();
    }

    private void addIMField() {
        FieldVisitor fv = super.visitField(2, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;", null, null);
        fv.visitEnd();
    }

    private void addPOJOInterface(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String[] itfs;
        boolean found = false;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(POJO)) continue;
            found = true;
        }
        if (!found) {
            itfs = new String[interfaces.length + 1];
            for (int i = 0; i < interfaces.length; ++i) {
                itfs[i] = interfaces[i];
            }
            itfs[interfaces.length] = POJO;
        } else {
            itfs = interfaces;
        }
        this.cv.visit(version, access, name, signature, superName, itfs);
    }

    public void visitEnd() {
        this.createSetInstanceManagerMethod();
        this.createGetComponentInstanceMethod();
        this.m_methods.clear();
        this.m_methodFlags.clear();
        this.cv.visitEnd();
    }

    private void createSetInstanceManagerMethod() {
        MethodVisitor mv = this.cv.visitMethod(2, "_setInstanceManager", "(Lorg/apache/felix/ipojo/InstanceManager;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        mv.visitInsn(177);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "getRegistredFields", "()Ljava/util/Set;");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        Label endif = new Label();
        mv.visitJumpInsn(198, endif);
        Iterator it = this.m_fields.iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(field);
            mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z");
            Label l3 = new Label();
            mv.visitJumpInsn(153, l3);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(4);
            mv.visitFieldInsn(181, this.m_owner, FIELD_FLAG_PREFIX + field, "Z");
            mv.visitLabel(l3);
        }
        mv.visitLabel(endif);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "getRegistredMethods", "()Ljava/util/Set;");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        Label endif2 = new Label();
        mv.visitJumpInsn(198, endif2);
        for (int i = 0; i < this.m_methods.size(); ++i) {
            String methodId = (String)this.m_methods.get(i);
            if (methodId.equals("<init>")) continue;
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(methodId);
            mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z");
            Label l3 = new Label();
            mv.visitJumpInsn(153, l3);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(4);
            mv.visitFieldInsn(181, this.m_owner, METHOD_FLAG_PREFIX + methodId, "Z");
            mv.visitLabel(l3);
        }
        mv.visitLabel(endif2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createGetComponentInstanceMethod() {
        MethodVisitor mv = this.cv.visitMethod(1, "getComponentInstance", "()Lorg/apache/felix/ipojo/ComponentInstance;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createArraySetter(String name, String desc, Type type) {
        MethodVisitor mv = this.cv.visitMethod(0, "__set" + name, desc, null, null);
        mv.visitCode();
        String internalType = desc.substring(1);
        internalType = internalType.substring(0, internalType.length() - 2);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
        Label l2 = new Label();
        mv.visitJumpInsn(154, l2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.m_owner, name, internalType);
        mv.visitInsn(177);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(name);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", SET, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createArrayGetter(String name, String desc, Type type) {
        String methodName = "__get" + name;
        MethodVisitor mv = this.cv.visitMethod(0, methodName, desc, null, null);
        mv.visitCode();
        String internalType = desc.substring(2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
        Label l1 = new Label();
        mv.visitJumpInsn(154, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, name, internalType);
        mv.visitInsn(176);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(name);
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", GET, "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, internalType);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createSimpleGetter(String name, String desc, Type type) {
        String methodName = "__get" + name;
        MethodVisitor mv = this.cv.visitMethod(0, methodName, desc, null, null);
        mv.visitCode();
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                String internalName = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][0];
                String boxingType = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][1];
                String unboxingMethod = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][2];
                Label l0 = new Label();
                mv.visitLabel(l0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l1 = new Label();
                mv.visitJumpInsn(154, l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, name, internalName);
                mv.visitInsn(172);
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", GET, "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                mv.visitVarInsn(58, 1);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, boxingType);
                mv.visitVarInsn(58, 2);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, boxingType, unboxingMethod, "()" + internalName);
                mv.visitInsn(type.getOpcode(172));
                break;
            }
            case 7: {
                String internalName = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][0];
                String boxingType = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][1];
                String unboxingMethod = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][2];
                Label l0 = new Label();
                mv.visitLabel(l0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l1 = new Label();
                mv.visitJumpInsn(154, l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, name, internalName);
                mv.visitInsn(173);
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", GET, "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                mv.visitVarInsn(58, 1);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, boxingType);
                mv.visitVarInsn(58, 2);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, boxingType, unboxingMethod, "()" + internalName);
                mv.visitInsn(173);
                break;
            }
            case 8: {
                String internalName = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][0];
                String boxingType = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][1];
                String unboxingMethod = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][2];
                Label l0 = new Label();
                mv.visitLabel(l0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l1 = new Label();
                mv.visitJumpInsn(154, l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, name, internalName);
                mv.visitInsn(175);
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", GET, "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                mv.visitVarInsn(58, 1);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, boxingType);
                mv.visitVarInsn(58, 2);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, boxingType, unboxingMethod, "()" + internalName);
                mv.visitInsn(175);
                break;
            }
            case 6: {
                String internalName = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][0];
                String boxingType = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][1];
                String unboxingMethod = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][2];
                Label l0 = new Label();
                mv.visitLabel(l0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l1 = new Label();
                mv.visitJumpInsn(154, l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, name, internalName);
                mv.visitInsn(174);
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", GET, "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                mv.visitVarInsn(58, 1);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, boxingType);
                mv.visitVarInsn(58, 2);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, boxingType, unboxingMethod, "()" + internalName);
                mv.visitInsn(174);
                break;
            }
            case 10: {
                Label l0 = new Label();
                mv.visitLabel(l0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l1 = new Label();
                mv.visitJumpInsn(154, l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, name, "L" + type.getInternalName() + ";");
                mv.visitInsn(176);
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", GET, "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                mv.visitTypeInsn(192, type.getInternalName());
                mv.visitInsn(176);
                break;
            }
            default: {
                ManipulationProperty.getLogger().log(2, "Manipulation problem in " + this.m_owner + " : a type is not implemented : " + type);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createSimpleSetter(String name, String desc, Type type) {
        MethodVisitor mv = this.cv.visitMethod(0, "__set" + name, desc, null, null);
        mv.visitCode();
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                String internalName = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][0];
                String boxingType = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][1];
                Label l1 = new Label();
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l22 = new Label();
                mv.visitJumpInsn(154, l22);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(type.getOpcode(21), 1);
                mv.visitFieldInsn(181, this.m_owner, name, internalName);
                mv.visitInsn(177);
                mv.visitLabel(l22);
                mv.visitTypeInsn(187, boxingType);
                mv.visitInsn(89);
                mv.visitVarInsn(type.getOpcode(21), 1);
                mv.visitMethodInsn(183, boxingType, "<init>", "(" + internalName + ")V");
                mv.visitVarInsn(58, 2);
                Label l2 = new Label();
                mv.visitLabel(l2);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", SET, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
                Label l3 = new Label();
                mv.visitLabel(l3);
                mv.visitInsn(177);
                break;
            }
            case 7: 
            case 8: {
                String internalName = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][0];
                String boxingType = ManipulationProperty.PRIMITIVE_BOXING_INFORMATION[type.getSort()][1];
                Label l1 = new Label();
                mv.visitLabel(l1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l23 = new Label();
                mv.visitJumpInsn(154, l23);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(type.getOpcode(21), 1);
                mv.visitFieldInsn(181, this.m_owner, name, internalName);
                mv.visitInsn(177);
                mv.visitLabel(l23);
                mv.visitTypeInsn(187, boxingType);
                mv.visitInsn(89);
                mv.visitVarInsn(type.getOpcode(21), 1);
                mv.visitMethodInsn(183, boxingType, "<init>", "(" + internalName + ")V");
                mv.visitVarInsn(58, 3);
                Label l2 = new Label();
                mv.visitLabel(l2);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", SET, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
                Label l3 = new Label();
                mv.visitLabel(l3);
                mv.visitInsn(177);
                break;
            }
            case 10: {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, FIELD_FLAG_PREFIX + name, "Z");
                Label l24 = new Label();
                mv.visitJumpInsn(154, l24);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitFieldInsn(181, this.m_owner, name, "L" + type.getInternalName() + ";");
                mv.visitInsn(177);
                mv.visitLabel(l24);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_owner, IM_FIELD, "Lorg/apache/felix/ipojo/InstanceManager;");
                mv.visitVarInsn(25, 0);
                mv.visitLdcInsn(name);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", SET, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
                mv.visitInsn(177);
                break;
            }
            default: {
                ManipulationProperty.getLogger().log(2, "Manipulation Error : Cannot create the setter method for the field : " + name + " (" + type + ")");
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

