/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.composite.CompositeManager;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceExporter
extends DependencyModel {
    private BundleContext m_destination;
    private CompositeManager m_manager;
    private Map m_registrations = new HashMap();

    public ServiceExporter(Class specification, Filter filter, boolean multiple, boolean optional, Comparator cmp, int policy, ServiceContext from, BundleContext dest, DependencyStateListener listener, CompositeManager manager) {
        super(specification, multiple, optional, filter, cmp, policy, (BundleContext)from, listener, (ComponentInstance)manager);
        this.m_destination = dest;
        this.m_manager = manager;
    }

    private Dictionary getProps(ServiceReference ref) {
        Properties prop = new Properties();
        String[] keys = ref.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            prop.put(keys[i], ref.getProperty(keys[i]));
        }
        prop.put("instance.name", this.m_manager.getInstanceName());
        prop.put("factory.name", this.m_manager.getFactory().getName());
        return prop;
    }

    public void stop() {
        super.stop();
        Set refs = this.m_registrations.keySet();
        for (ServiceReference ref : refs) {
            ServiceRegistration reg = (ServiceRegistration)this.m_registrations.get(ref);
            try {
                reg.unregister();
            }
            catch (IllegalStateException e) {}
        }
        this.m_registrations.clear();
    }

    public void onServiceArrival(ServiceReference reference) {
        Object svc = this.getService(reference);
        if (!SecurityHelper.hasPermissionToRegisterService((String)this.getSpecification().getName(), (BundleContext)this.m_destination)) {
            throw new SecurityException("The bundle " + this.m_destination.getBundle().getBundleId() + " does not have the " + "permission to register the service " + this.getSpecification().getName());
        }
        ServiceRegistration reg = this.m_destination.registerService(this.getSpecification().getName(), svc, this.getProps(reference));
        this.m_registrations.put(reference, reg);
    }

    public void onServiceModification(ServiceReference reference) {
        ServiceRegistration reg = (ServiceRegistration)this.m_registrations.get(reference);
        if (reg != null) {
            reg.setProperties(this.getProps(reference));
        }
    }

    public void onServiceDeparture(ServiceReference reference) {
        ServiceRegistration reg = (ServiceRegistration)this.m_registrations.get(reference);
        if (reg != null) {
            reg.unregister();
        }
        this.m_registrations.remove(reference);
    }

    public void onDependencyReconfiguration(ServiceReference[] departs, ServiceReference[] arrivals) {
        throw new UnsupportedOperationException("Dynamic dependency reconfiguration is not supported by service exporter");
    }
}

