/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassChecker
extends EmptyVisitor
implements ClassVisitor,
Opcodes {
    private boolean m_isAlreadyManipulated = false;
    private List<String> m_itfs = new ArrayList<String>();
    private Map<String, String> m_fields = new TreeMap<String, String>();
    private List<MethodDescriptor> m_methods = new ArrayList<MethodDescriptor>();
    private String m_superClass;
    private String m_className;
    private Map<String, List<MethodDescriptor>> m_inners = new LinkedHashMap<String, List<MethodDescriptor>>();
    private boolean m_supportAnnotation = false;
    private int m_classVersion;

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("__IM") && desc.equals("Lorg/apache/felix/ipojo/InstanceManager;")) {
            this.m_isAlreadyManipulated = true;
        } else {
            if (name.startsWith("class$")) {
                return null;
            }
            if ((access & 8) == 8) {
                return null;
            }
        }
        if (this.isManipulatedField(name)) {
            return null;
        }
        Type type = Type.getType(desc);
        if (type.getSort() == 9) {
            if (type.getInternalName().startsWith("L")) {
                String internalType = type.getInternalName().substring(1);
                String nameType = internalType.replace('/', '.');
                this.m_fields.put(name, nameType + "[]");
            } else {
                String nameType = type.getClassName().substring(0, type.getClassName().length() - 2);
                this.m_fields.put(name, nameType + "[]");
            }
        } else {
            this.m_fields.put(name, type.getClassName());
        }
        return null;
    }

    private boolean isManipulatedField(String name) {
        return "__IM".equals(name) || name.startsWith("__F") || name.startsWith("__M");
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((this.m_className.equals(outerName) || outerName == null) && (access & 8) != 8) {
            this.m_inners.put(name, new ArrayList());
        }
    }

    public boolean isAlreadyManipulated() {
        return this.m_isAlreadyManipulated;
    }

    public int getClassVersion() {
        return this.m_classVersion;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.m_classVersion = version;
        boolean bl = this.m_supportAnnotation = version > 48 && version < 196653;
        if (!superName.equals("java/lang/Object")) {
            this.m_superClass = superName.replace('/', '.');
        }
        for (String anInterface : interfaces) {
            if (anInterface.equals("org/apache/felix/ipojo/Pojo")) continue;
            this.m_itfs.add(anInterface.replace('/', '.'));
        }
        this.m_className = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!name.equals("<clinit>")) {
            if (name.equals("<init>")) {
                if (!ClassChecker.isGeneratedConstructor(name, desc)) {
                    MethodDescriptor md = new MethodDescriptor("$init", desc, (access & 8) == 8);
                    this.m_methods.add(md);
                    return new MethodInfoCollector(md);
                }
            } else if (!ClassChecker.isGeneratedMethod(name, desc)) {
                MethodDescriptor md = new MethodDescriptor(name, desc, (access & 8) == 8);
                this.m_methods.add(md);
                return new MethodInfoCollector(md);
            }
        }
        if (name.equals("<clinit>")) {
            return new InnerClassAssignedToStaticFieldDetector();
        }
        return null;
    }

    public static boolean isGeneratedConstructor(String name, String desc) {
        return "<init>".equals(name) && ClassChecker.isFirstArgumentInstanceManager(desc);
    }

    public static boolean isFirstArgumentInstanceManager(String desc) {
        Type[] types = Type.getArgumentTypes(desc);
        return types != null && types.length >= 1 && Type.getType("Lorg/apache/felix/ipojo/InstanceManager;").equals(types[0]);
    }

    public static boolean isGeneratedMethod(String name, String desc) {
        return ClassChecker.isGetterMethod(name, desc) || ClassChecker.isSetterMethod(name, desc) || ClassChecker.isSetInstanceManagerMethod(name) || ClassChecker.isGetComponentInstanceMethod(name, desc) || ClassChecker.isManipulatedMethod(name);
    }

    private static boolean isGetterMethod(String name, String desc) {
        Type[] arguments = Type.getArgumentTypes(desc);
        return name.startsWith("__get") && arguments.length == 0 && !Type.VOID_TYPE.equals(Type.getReturnType(desc));
    }

    private static boolean isSetterMethod(String name, String desc) {
        Type[] arguments = Type.getArgumentTypes(desc);
        return name.startsWith("__set") && arguments.length == 1 && Type.VOID_TYPE.equals(Type.getReturnType(desc));
    }

    private static boolean isSetInstanceManagerMethod(String name) {
        return name.startsWith("_setInstanceManager");
    }

    private static boolean isGetComponentInstanceMethod(String name, String desc) {
        return name.startsWith("getComponentInstance") && Type.getType("Lorg/apache/felix/ipojo/ComponentInstance;").equals(Type.getReturnType(desc));
    }

    private static boolean isManipulatedMethod(String name) {
        return name.startsWith("__M_");
    }

    public List<String> getInterfaces() {
        return this.m_itfs;
    }

    public Map<String, String> getFields() {
        return this.m_fields;
    }

    public List<MethodDescriptor> getMethods() {
        return this.m_methods;
    }

    public String getSuperClass() {
        return this.m_superClass;
    }

    public Collection<String> getInnerClasses() {
        return this.m_inners.keySet();
    }

    public Map<String, List<MethodDescriptor>> getInnerClassesAndMethods() {
        return this.m_inners;
    }

    public String getClassName() {
        return this.m_className;
    }

    private class InnerClassAssignedToStaticFieldDetector
    extends EmptyVisitor
    implements MethodVisitor {
        private InnerClassAssignedToStaticFieldDetector() {
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187 && ClassChecker.this.m_inners.containsKey(type)) {
                ClassChecker.this.m_inners.remove(type);
            }
        }
    }

    public static final class EnumAttribute {
        private String m_name;
        private String m_desc;
        private String m_value;

        private EnumAttribute(String name, String desc, String value) {
            this.m_name = name;
            this.m_value = value;
            this.m_desc = desc;
        }

        public void visit(AnnotationVisitor visitor) {
            visitor.visitEnum(this.m_name, this.m_desc, this.m_value);
        }
    }

    public static final class SimpleAttribute {
        private String m_name;
        private Object m_value;

        private SimpleAttribute(String name, Object object) {
            this.m_name = name;
            this.m_value = object;
        }

        public void visit(AnnotationVisitor visitor) {
            visitor.visit(this.m_name, this.m_value);
        }
    }

    public class ArrayAttribute
    implements AnnotationVisitor {
        private String m_name;
        private List<Object> m_content = new ArrayList<Object>();

        public ArrayAttribute(String name) {
            this.m_name = name;
        }

        public void visit(String arg0, Object arg1) {
            this.m_content.add(arg1);
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            AnnotationDescriptor ad = new AnnotationDescriptor(null, arg1);
            this.m_content.add(ad);
            return ad;
        }

        public AnnotationVisitor visitArray(String arg0) {
            ArrayAttribute aa = new ArrayAttribute(null);
            this.m_content.add(aa);
            return aa;
        }

        public void visitEnd() {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
            EnumAttribute ea = new EnumAttribute(null, arg1, arg2);
            this.m_content.add(ea);
        }

        public void visit(AnnotationVisitor av) {
            AnnotationVisitor content = av.visitArray(this.m_name);
            for (int i = 0; i < this.m_content.size(); ++i) {
                Object component = this.m_content.get(i);
                if (component instanceof AnnotationDescriptor) {
                    ((AnnotationDescriptor)component).visit(content);
                    continue;
                }
                if (component instanceof EnumAttribute) {
                    ((EnumAttribute)component).visit(content);
                    continue;
                }
                if (component instanceof ArrayAttribute) {
                    ((ArrayAttribute)component).visit(content);
                    continue;
                }
                content.visit(null, component);
            }
            content.visitEnd();
        }
    }

    public class AnnotationDescriptor
    implements AnnotationVisitor {
        private String m_name;
        private boolean m_visible;
        private String m_desc;
        private List<SimpleAttribute> m_simples = new ArrayList<SimpleAttribute>(0);
        private List<EnumAttribute> m_enums = new ArrayList<EnumAttribute>(0);
        private List<AnnotationDescriptor> m_nested = new ArrayList<AnnotationDescriptor>(0);
        private List<ArrayAttribute> m_arrays = new ArrayList<ArrayAttribute>(0);

        public AnnotationDescriptor(String name, boolean visible) {
            this.m_name = name;
            this.m_visible = visible;
        }

        public AnnotationDescriptor(String name, String desc) {
            this.m_name = name;
            this.m_visible = true;
            this.m_desc = desc;
        }

        public void visit(String arg0, Object arg1) {
            this.m_simples.add(new SimpleAttribute(arg0, arg1));
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            AnnotationDescriptor ad = new AnnotationDescriptor(arg0, arg1);
            this.m_nested.add(ad);
            return ad;
        }

        public AnnotationVisitor visitArray(String arg0) {
            ArrayAttribute aa = new ArrayAttribute(arg0);
            this.m_arrays.add(aa);
            return aa;
        }

        public void visitEnd() {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
            this.m_enums.add(new EnumAttribute(arg0, arg1, arg2));
        }

        public void visitAnnotation(MethodVisitor mv) {
            int i;
            AnnotationVisitor av = mv.visitAnnotation(this.m_name, this.m_visible);
            for (i = 0; i < this.m_simples.size(); ++i) {
                this.m_simples.get(i).visit(av);
            }
            for (i = 0; i < this.m_enums.size(); ++i) {
                this.m_enums.get(i).visit(av);
            }
            for (i = 0; i < this.m_nested.size(); ++i) {
                this.m_nested.get(i).visit(av);
            }
            for (i = 0; i < this.m_arrays.size(); ++i) {
                this.m_arrays.get(i).visit(av);
            }
            av.visitEnd();
        }

        public void visitParameterAnnotation(int id, MethodVisitor mv) {
            int i;
            AnnotationVisitor av = mv.visitParameterAnnotation(id, this.m_name, this.m_visible);
            for (i = 0; i < this.m_simples.size(); ++i) {
                this.m_simples.get(i).visit(av);
            }
            for (i = 0; i < this.m_enums.size(); ++i) {
                this.m_enums.get(i).visit(av);
            }
            for (i = 0; i < this.m_nested.size(); ++i) {
                this.m_nested.get(i).visit(av);
            }
            for (i = 0; i < this.m_arrays.size(); ++i) {
                this.m_arrays.get(i).visit(av);
            }
            av.visitEnd();
        }

        public void visit(AnnotationVisitor mv) {
            int i;
            AnnotationVisitor av = mv.visitAnnotation(this.m_name, this.m_desc);
            for (i = 0; i < this.m_simples.size(); ++i) {
                this.m_simples.get(i).visit(av);
            }
            for (i = 0; i < this.m_enums.size(); ++i) {
                this.m_enums.get(i).visit(av);
            }
            for (i = 0; i < this.m_nested.size(); ++i) {
                this.m_nested.get(i).visit(av);
            }
            for (i = 0; i < this.m_arrays.size(); ++i) {
                this.m_arrays.get(i).visit(av);
            }
            av.visitEnd();
        }
    }

    private final class MethodInfoCollector
    extends EmptyVisitor {
        private MethodDescriptor m_method;

        private MethodInfoCollector(MethodDescriptor md) {
            this.m_method = md;
        }

        public AnnotationVisitor visitAnnotation(String name, boolean visible) {
            if (visible) {
                AnnotationDescriptor ann = new AnnotationDescriptor(name, visible);
                this.m_method.addAnnotation(ann);
                return ann;
            }
            return null;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.m_method.addLocalVariable(name, desc, signature, index);
        }

        public void visitEnd() {
            this.m_method.end();
        }

        public AnnotationVisitor visitParameterAnnotation(int id, String name, boolean visible) {
            if (visible) {
                AnnotationDescriptor ann = new AnnotationDescriptor(name, visible);
                this.m_method.addParameterAnnotation(id, ann);
                return ann;
            }
            if (this.m_method.getName().equals("$init")) {
                AnnotationDescriptor ann = new AnnotationDescriptor(name, visible);
                this.m_method.addParameterAnnotation(id, ann);
                return ann;
            }
            return null;
        }
    }
}

