/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor;

import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class HandlerVisitor
extends EmptyVisitor
implements AnnotationVisitor {
    private Element handler = new Element("handler", "");
    private ComponentWorkbench workbench;
    private Reporter reporter;

    public HandlerVisitor(ComponentWorkbench workbench, Reporter reporter) {
        this.workbench = workbench;
        this.reporter = reporter;
    }

    public void visit(String name, Object value) {
        if (name.equals("name")) {
            this.handler.addAttribute(new Attribute("name", value.toString()));
            return;
        }
        if (name.equals("namespace")) {
            this.handler.addAttribute(new Attribute("namespace", value.toString()));
            return;
        }
        if (name.equals("level")) {
            this.handler.addAttribute(new Attribute("level", value.toString()));
            return;
        }
        if (name.equals("architecture")) {
            this.handler.addAttribute(new Attribute("architecture", value.toString()));
        }
    }

    public void visitEnd() {
        String classname = this.workbench.getType().getClassName();
        this.handler.addAttribute(new Attribute("classname", classname));
        if (this.workbench.getRoot() == null) {
            this.workbench.setRoot(this.handler);
        } else {
            this.reporter.error("Multiple 'component type' annotations on the class '{%s}'.", classname);
            this.reporter.warn("@Handler will be ignored.", new Object[0]);
        }
    }
}

