/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.felix.ipojo.manipulator.ManipulationEngine;
import org.apache.felix.ipojo.manipulator.ManipulationUnit;
import org.apache.felix.ipojo.manipulator.ManipulationVisitor;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.manifest.FileManifestProvider;
import org.apache.felix.ipojo.manipulator.metadata.AnnotationMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.CompositeMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.EmptyMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.FileMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.StreamMetadataProvider;
import org.apache.felix.ipojo.manipulator.render.MetadataRenderer;
import org.apache.felix.ipojo.manipulator.reporter.SystemReporter;
import org.apache.felix.ipojo.manipulator.store.DirectoryResourceStore;
import org.apache.felix.ipojo.manipulator.store.JarFileResourceStore;
import org.apache.felix.ipojo.manipulator.store.builder.DefaultManifestBuilder;
import org.apache.felix.ipojo.manipulator.store.mapper.WABResourceMapper;
import org.apache.felix.ipojo.manipulator.util.Constants;
import org.apache.felix.ipojo.manipulator.util.Metadatas;
import org.apache.felix.ipojo.manipulator.util.Strings;
import org.apache.felix.ipojo.manipulator.visitor.check.CheckFieldConsistencyVisitor;
import org.apache.felix.ipojo.manipulator.visitor.writer.ManipulatedResourcesWriter;
import org.apache.felix.ipojo.metadata.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pojoization {
    private boolean m_ignoreAnnotations;
    private boolean m_useLocalXSD = false;
    private Reporter m_reporter;

    public Pojoization() {
        this(new SystemReporter());
    }

    public Pojoization(Reporter reporter) {
        this.m_reporter = reporter;
        this.m_reporter.info("Apache Felix iPOJO Manipulator - " + Constants.getVersion(), new Object[0]);
    }

    public void disableAnnotationProcessing() {
        this.m_ignoreAnnotations = true;
    }

    public void setUseLocalXSD() {
        this.m_useLocalXSD = true;
    }

    public List<String> getErrors() {
        return this.m_reporter.getErrors();
    }

    public List<String> getWarnings() {
        return this.m_reporter.getWarnings();
    }

    public void pojoization(File in, File out, InputStream metadata) {
        JarFileResourceStore store;
        StreamMetadataProvider provider = new StreamMetadataProvider(metadata, this.m_reporter);
        provider.setValidateUsingLocalSchemas(this.m_useLocalXSD);
        try {
            JarFile origin = new JarFile(in);
            JarFileResourceStore jfrs = new JarFileResourceStore(origin, out);
            if (in.getName().endsWith(".war")) {
                jfrs.setResourceMapper(new WABResourceMapper());
            }
            jfrs.setManifest(origin.getManifest());
            DefaultManifestBuilder dmb = new DefaultManifestBuilder();
            dmb.setMetadataRenderer(new MetadataRenderer());
            jfrs.setManifestBuilder(dmb);
            store = jfrs;
        }
        catch (IOException e) {
            this.m_reporter.error("The input file " + in.getAbsolutePath() + " is not a Jar file", new Object[0]);
            return;
        }
        ManipulationVisitor visitor = this.createDefaultVisitorChain(store);
        this.pojoization(store, provider, visitor);
    }

    private ManipulationVisitor createDefaultVisitorChain(ResourceStore store) {
        ManipulatedResourcesWriter writer = new ManipulatedResourcesWriter();
        writer.setReporter(this.m_reporter);
        writer.setResourceStore(store);
        CheckFieldConsistencyVisitor checkFieldConsistencyVisitor = new CheckFieldConsistencyVisitor(writer);
        checkFieldConsistencyVisitor.setReporter(this.m_reporter);
        return checkFieldConsistencyVisitor;
    }

    public void pojoization(File in, File out, File metadataFile) {
        JarFileResourceStore store;
        MetadataProvider provider = new EmptyMetadataProvider();
        if (metadataFile != null) {
            FileMetadataProvider fileMetadataProvider = new FileMetadataProvider(metadataFile, this.m_reporter);
            fileMetadataProvider.setValidateUsingLocalSchemas(this.m_useLocalXSD);
            provider = fileMetadataProvider;
        }
        try {
            JarFile origin = new JarFile(in);
            JarFileResourceStore jfrs = new JarFileResourceStore(origin, out);
            if (in.getName().endsWith(".war")) {
                jfrs.setResourceMapper(new WABResourceMapper());
            }
            jfrs.setManifest(origin.getManifest());
            DefaultManifestBuilder dmb = new DefaultManifestBuilder();
            dmb.setMetadataRenderer(new MetadataRenderer());
            jfrs.setManifestBuilder(dmb);
            store = jfrs;
        }
        catch (IOException e) {
            this.m_reporter.error("The input file " + in.getAbsolutePath() + " is not a Jar file", new Object[0]);
            return;
        }
        ManipulationVisitor visitor = this.createDefaultVisitorChain(store);
        this.pojoization(store, provider, visitor);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void directoryPojoization(File directory, File metadataFile, File manifestFile) {
        File selectedManifestFile;
        FileManifestProvider manifestProvider;
        EmptyMetadataProvider emptyMetadataProvider = new EmptyMetadataProvider();
        if (metadataFile != null) {
            FileMetadataProvider fileMetadataProvider = new FileMetadataProvider(metadataFile, this.m_reporter);
            fileMetadataProvider.setValidateUsingLocalSchemas(this.m_useLocalXSD);
            FileMetadataProvider fileMetadataProvider2 = fileMetadataProvider;
        }
        if (manifestFile != null) {
            if (!manifestFile.isFile()) {
                this.m_reporter.error("The manifest file " + manifestFile.getAbsolutePath() + " does not exist", new Object[0]);
                return;
            }
            try {
                manifestProvider = new FileManifestProvider(manifestFile);
                selectedManifestFile = manifestFile;
            }
            catch (IOException e) {
                this.m_reporter.error("Cannot read Manifest from '" + manifestFile.getAbsolutePath() + "'", new Object[0]);
                return;
            }
        }
        File metaInf = new File(directory, "META-INF");
        File original = new File(metaInf, "MANIFEST.MF");
        if (!original.isFile()) {
            this.m_reporter.error("The manifest file " + original.getAbsolutePath() + " does not exist", new Object[0]);
            return;
        }
        try {
            manifestProvider = new FileManifestProvider(original);
            selectedManifestFile = original;
        }
        catch (IOException e) {
            this.m_reporter.error("Cannot read Manifest from '" + original.getAbsolutePath() + "'", new Object[0]);
            return;
        }
        if (directory.exists() && directory.isDirectory()) {
            void var4_6;
            DirectoryResourceStore store = new DirectoryResourceStore(directory);
            File webinf = new File(directory, "WEB-INF");
            if (directory.getName().endsWith(".war") || webinf.isDirectory()) {
                store.setResourceMapper(new WABResourceMapper());
            }
            store.setManifest(manifestProvider.getManifest());
            store.setManifestFile(selectedManifestFile);
            DefaultManifestBuilder dmb = new DefaultManifestBuilder();
            dmb.setMetadataRenderer(new MetadataRenderer());
            store.setManifestBuilder(dmb);
            ManipulationVisitor visitor = this.createDefaultVisitorChain(store);
            this.pojoization(store, (MetadataProvider)var4_6, visitor);
            return;
        }
        this.m_reporter.error("The directory " + directory.getAbsolutePath() + " does not exist or is not a directory.", new Object[0]);
    }

    public void pojoization(ResourceStore store, MetadataProvider metadata, ManipulationVisitor visitor) {
        ManipulationEngine engine = new ManipulationEngine();
        engine.setResourceStore(store);
        engine.setReporter(this.m_reporter);
        engine.setManipulationVisitor(visitor);
        try {
            CompositeMetadataProvider composite = new CompositeMetadataProvider(this.m_reporter);
            composite.addMetadataProvider(metadata);
            if (!this.m_ignoreAnnotations) {
                composite.addMetadataProvider(new AnnotationMetadataProvider(store, this.m_reporter));
            }
            List<Element> metadatas = composite.getMetadatas();
            for (Element meta : metadatas) {
                String name = Metadatas.getComponentType(meta);
                if (name != null) {
                    String path = Strings.asResourcePath(name);
                    engine.addManipulationUnit(new ManipulationUnit(path, meta));
                    continue;
                }
                visitor.visitMetadata(meta);
            }
        }
        catch (IOException e) {
            this.m_reporter.error("Cannot load metadata " + e.getMessage(), new Object[0]);
            return;
        }
        engine.generate();
        visitor.visitEnd();
    }
}

