/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.store.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.ipojo.manipulator.QuotedTokenizer;
import org.apache.felix.ipojo.manipulator.render.MetadataRenderer;
import org.apache.felix.ipojo.manipulator.store.ManifestBuilder;
import org.apache.felix.ipojo.manipulator.util.Constants;
import org.apache.felix.ipojo.metadata.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManifestBuilder
implements ManifestBuilder {
    private List<String> m_referredPackages = new ArrayList<String>();
    private List<Element> m_metadata = new ArrayList<Element>();
    private MetadataRenderer m_renderer;

    @Override
    public void addReferredPackage(Set<String> packageNames) {
        this.m_referredPackages.addAll(packageNames);
    }

    @Override
    public void addMetada(Collection<Element> metadatas) {
        this.m_metadata.addAll(metadatas);
    }

    public void setMetadataRenderer(MetadataRenderer renderer) {
        this.m_renderer = renderer;
    }

    @Override
    public Manifest build(Manifest original) {
        Attributes att = original.getMainAttributes();
        this.setImports(att);
        this.setPOJOMetadata(att);
        this.setCreatedBy(att);
        return original;
    }

    private void setImports(Attributes att) {
        TreeMap<String, String> verCM;
        Map<String, Map<String, String>> imports = this.parseHeader(att.getValue("Import-Package"));
        TreeMap<String, String> ver = new TreeMap<String, String>();
        ver.put("version", Constants.getPackageImportClause());
        if (!imports.containsKey("org.apache.felix.ipojo")) {
            imports.put("org.apache.felix.ipojo", ver);
        }
        if (!imports.containsKey("org.apache.felix.ipojo.architecture")) {
            imports.put("org.apache.felix.ipojo.architecture", ver);
        }
        if (!imports.containsKey("org.osgi.service.cm")) {
            verCM = new TreeMap<String, String>();
            verCM.put("version", "1.2");
            imports.put("org.osgi.service.cm", verCM);
        }
        if (!imports.containsKey("org.osgi.service.log")) {
            verCM = new TreeMap();
            verCM.put("version", "1.3");
            imports.put("org.osgi.service.log", verCM);
        }
        for (int i = 0; i < this.m_referredPackages.size(); ++i) {
            String pack = this.m_referredPackages.get(i);
            imports.put(pack, new TreeMap());
        }
        att.putValue("Import-Package", this.printClauses(imports, "resolution:"));
    }

    private void setPOJOMetadata(Attributes att) {
        StringBuilder meta = new StringBuilder();
        for (Element metadata : this.m_metadata) {
            meta.append(this.m_renderer.render(metadata));
        }
        if (meta.length() != 0) {
            att.putValue("iPOJO-Components", meta.toString());
        }
    }

    private void setCreatedBy(Attributes att) {
        String prev = att.getValue("Created-By");
        if (prev == null) {
            att.putValue("Created-By", "iPOJO " + Constants.getVersion());
        } else if (prev.indexOf("iPOJO") == -1) {
            att.putValue("Created-By", prev + " & iPOJO " + Constants.getVersion());
        }
    }

    protected Map<String, Map<String, String>> parseHeader(String value) {
        char del;
        if (value == null || value.trim().length() == 0) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        do {
            boolean hadAttribute = false;
            HashMap<String, String> clause = new HashMap<String, String>();
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add(qt.nextToken());
            del = qt.getSeparator();
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute) {
                        throw new IllegalArgumentException("Header contains name field after attribute or directive: " + adname + " from " + value);
                    }
                    aliases.add(adname);
                    continue;
                }
                String advalue = qt.nextToken();
                clause.put(adname, advalue);
                del = qt.getSeparator();
                hadAttribute = true;
            }
            Iterator i = aliases.iterator();
            while (i.hasNext()) {
                result.put((String)i.next(), (Map<String, String>)clause);
            }
        } while (del == ',');
        return result;
    }

    private String printClauses(Map<String, Map<String, String>> exports, String allowedDirectives) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (Map.Entry<String, Map<String, String>> entry : exports.entrySet()) {
            String name = entry.getKey();
            Map<String, String> map = entry.getValue();
            sb.append(del);
            sb.append(name);
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                boolean dirty;
                String key = entry2.getKey();
                if (key.endsWith(":") && allowedDirectives.indexOf(key) < 0) continue;
                String value = entry2.getValue();
                sb.append(";");
                sb.append(key);
                sb.append("=");
                boolean bl = dirty = value.indexOf(44) >= 0 || value.indexOf(59) >= 0;
                if (dirty) {
                    sb.append("\"");
                }
                sb.append(value);
                if (!dirty) continue;
                sb.append("\"");
            }
            del = ", ";
        }
        return sb.toString();
    }
}

