/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentWorkbench {
    private Element root;
    private Element instance;
    private Map<String, Element> m_ids = new TreeMap<String, Element>();
    private Map<Element, String> m_elements = new LinkedHashMap<Element, String>();
    private Type type;
    private BindingRegistry bindingRegistry;
    private ClassNode classNode;

    public ComponentWorkbench(BindingRegistry bindingRegistry, ClassNode node) {
        this.bindingRegistry = bindingRegistry;
        this.classNode = node;
        this.type = Type.getObjectType(node.name);
    }

    public Type getType() {
        return this.type;
    }

    public BindingRegistry getBindingRegistry() {
        return this.bindingRegistry;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public Element getRoot() {
        return this.root;
    }

    public void setRoot(Element root) {
        this.root = root;
    }

    public Element getInstance() {
        return this.instance;
    }

    public void setInstance(Element instance) {
        this.instance = instance;
    }

    public Map<String, Element> getIds() {
        return this.m_ids;
    }

    public Map<Element, String> getElements() {
        return this.m_elements;
    }

    public Element build() {
        if (this.root == null) {
            return null;
        }
        for (Element current : this.m_elements.keySet()) {
            String refId = this.m_elements.get(current);
            if (refId == null) {
                this.root.addElement(current);
                continue;
            }
            Element ref = this.m_ids.get(refId);
            if (ref == null) {
                this.root.addElement(current);
                continue;
            }
            ref.addElement(current);
        }
        this.m_ids.clear();
        this.m_elements.clear();
        return this.root;
    }
}

