/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind;

import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.AbstractBindVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.Action;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Names;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class MethodBindVisitor
extends AbstractBindVisitor {
    private String m_name;

    public MethodBindVisitor(ComponentWorkbench workbench, Action action, String method) {
        super(workbench, action);
        this.m_name = method;
    }

    public void visitEnd() {
        if (this.m_id == null) {
            String identifier = Names.getMethodIdentifier(this.m_name);
            if (identifier != null) {
                this.m_id = identifier;
            } else {
                System.err.println("Cannot determine the id of the " + this.action.name() + " method : " + Names.computeEffectiveMethodName(this.m_name));
                return;
            }
        }
        Element requires = this.getRequiresElement();
        Element callback = new Element("callback", "");
        callback.addAttribute(new Attribute("method", Names.computeEffectiveMethodName(this.m_name)));
        callback.addAttribute(new Attribute("type", this.action.name().toLowerCase()));
        requires.addElement(callback);
        this.workbench.getIds().put(this.m_id, requires);
        this.workbench.getElements().put(requires, null);
    }
}

