/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MemberNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selection
implements Iterable<AnnotationVisitor> {
    private BindingRegistry registry;
    private ComponentWorkbench workbench;
    private Reporter reporter;
    private MemberNode node;
    private int index = -1;
    private String annotation;
    private ElementType elementType = null;

    public Selection(BindingRegistry registry, ComponentWorkbench workbench, Reporter reporter) {
        this.registry = registry;
        this.workbench = workbench;
        this.reporter = reporter;
    }

    public Selection field(FieldNode node) {
        this.node = node;
        this.elementType = ElementType.FIELD;
        return this;
    }

    public Selection method(MethodNode node) {
        this.node = node;
        this.elementType = ElementType.METHOD;
        return this;
    }

    public Selection type(ClassNode node) {
        this.node = node;
        this.elementType = ElementType.TYPE;
        return this;
    }

    public Selection parameter(MethodNode node, int index) {
        this.index = index;
        this.node = node;
        this.elementType = ElementType.PARAMETER;
        return this;
    }

    public Selection annotatedWith(String desc) {
        this.annotation = desc;
        return this;
    }

    public AnnotationVisitor get() {
        Iterator<AnnotationVisitor> i = this.iterator();
        if (this.iterator().hasNext()) {
            return i.next();
        }
        return null;
    }

    @Override
    public Iterator<AnnotationVisitor> iterator() {
        ArrayList<AnnotationVisitor> visitors = new ArrayList<AnnotationVisitor>();
        BindingContext context = new BindingContext(this.workbench, this.reporter, Type.getType(this.annotation), this.node, this.elementType, this.index);
        List<Binding> predicates = this.registry.getBindings(this.annotation);
        if (predicates != null && !predicates.isEmpty()) {
            this.collectMatchingVisitors(predicates, context, visitors);
        }
        if (visitors.isEmpty() && !this.registry.getDefaultBindings().isEmpty()) {
            this.collectMatchingVisitors(this.registry.getDefaultBindings(), context, visitors);
        }
        return visitors.iterator();
    }

    private void collectMatchingVisitors(List<Binding> bindings, BindingContext context, List<AnnotationVisitor> visitors) {
        for (Binding binding : bindings) {
            if (!binding.getPredicate().matches(context)) continue;
            AnnotationVisitor visitor = binding.getFactory().newAnnotationVisitor(context);
            visitors.add(visitor);
        }
    }
}

