/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.composite.FactoryProxy;
import org.apache.felix.ipojo.context.ServiceReferenceImpl;
import org.apache.felix.ipojo.context.ServiceRegistry;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class CompositeServiceContext
implements ServiceContext,
TrackerCustomizer {
    private List m_factories = new ArrayList();
    private ServiceRegistry m_registry;
    private ComponentInstance m_instance;
    private BundleContext m_global;
    private Tracker m_tracker;

    public CompositeServiceContext(BundleContext context) {
        this.m_registry = new ServiceRegistry(context);
        this.m_global = context instanceof IPojoContext ? ((IPojoContext)context).getGlobalContext() : context;
    }

    public CompositeServiceContext(BundleContext context, ComponentInstance instance) {
        this(context);
        this.m_instance = instance;
    }

    public void addServiceListener(ServiceListener arg0) {
        this.m_registry.addServiceListener(arg0);
    }

    public void addServiceListener(ServiceListener arg0, String arg1) throws InvalidSyntaxException {
        this.m_registry.addServiceListener(arg0, arg1);
    }

    public ServiceReference[] getAllServiceReferences(String arg0, String arg1) throws InvalidSyntaxException {
        return this.m_registry.getAllServiceReferences(arg0, arg1);
    }

    public Object getService(ServiceReference arg0) {
        if (arg0 instanceof ServiceReferenceImpl) {
            return this.m_registry.getService(this.m_instance, arg0);
        }
        throw new RuntimeException("Cannot get a global service from the local registry");
    }

    public ServiceReference getServiceReference(String arg0) {
        return this.m_registry.getServiceReference(arg0);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.m_registry.getServiceReferences(clazz, filter);
    }

    public ServiceRegistration registerService(String[] arg0, Object arg1, Dictionary arg2) {
        return this.m_registry.registerService(this.m_instance, arg0, arg1, arg2);
    }

    public ServiceRegistration registerService(String arg0, Object arg1, Dictionary arg2) {
        return this.m_registry.registerService(this.m_instance, arg0, arg1, arg2);
    }

    public void removeServiceListener(ServiceListener arg0) {
        this.m_registry.removeServiceListener(arg0);
    }

    public boolean ungetService(ServiceReference arg0) {
        return this.m_registry.ungetService(this.m_instance, arg0);
    }

    private void importFactory(ServiceReference ref) {
        Record rec = new Record();
        this.m_factories.add(rec);
        Properties dict = new Properties();
        for (int j = 0; j < ref.getPropertyKeys().length; ++j) {
            ((Dictionary)dict).put(ref.getPropertyKeys()[j], ref.getProperty(ref.getPropertyKeys()[j]));
        }
        rec.m_fact = new FactoryProxy((Factory)this.m_tracker.getService(ref), this);
        rec.m_reg = this.registerService(Factory.class.getName(), (Object)rec.m_fact, (Dictionary)dict);
        rec.m_ref = ref;
    }

    private void removeFactory(ServiceReference ref) {
        for (int i = 0; i < this.m_factories.size(); ++i) {
            Record rec = (Record)this.m_factories.get(i);
            if (rec.m_ref != ref) continue;
            if (rec.m_reg != null) {
                rec.m_reg.unregister();
                rec.m_fact = null;
            }
            this.m_tracker.ungetService(rec.m_ref);
            this.m_factories.remove(rec);
            return;
        }
    }

    public void start() {
        this.m_tracker = new Tracker(this.m_global, Factory.class.getName(), (TrackerCustomizer)this);
        this.m_tracker.open();
    }

    public synchronized void stop() {
        this.m_tracker.close();
        this.m_registry.reset();
        for (int i = 0; i < this.m_factories.size(); ++i) {
            Record rec = (Record)this.m_factories.get(i);
            this.removeFactory(rec.m_ref);
        }
        this.m_tracker = null;
    }

    private boolean containsRef(ServiceReference ref) {
        for (int i = 0; i < this.m_factories.size(); ++i) {
            Record rec = (Record)this.m_factories.get(i);
            if (rec.m_ref != ref) continue;
            return true;
        }
        return false;
    }

    public void addBundleListener(BundleListener arg0) {
        this.m_global.addBundleListener(arg0);
    }

    public void addFrameworkListener(FrameworkListener arg0) {
        this.m_global.addFrameworkListener(arg0);
    }

    public Filter createFilter(String arg0) throws InvalidSyntaxException {
        return this.m_global.createFilter(arg0);
    }

    public Bundle getBundle() {
        return this.m_global.getBundle();
    }

    public Bundle getBundle(long bundleId) {
        return this.m_global.getBundle(bundleId);
    }

    public Bundle[] getBundles() {
        return this.m_global.getBundles();
    }

    public File getDataFile(String filename) {
        return this.m_global.getDataFile(filename);
    }

    public String getProperty(String key) {
        return this.m_global.getProperty(key);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.m_global.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.m_global.installBundle(location, input);
    }

    public void removeBundleListener(BundleListener listener) {
        this.m_global.removeBundleListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.m_global.removeFrameworkListener(listener);
    }

    public boolean addingService(ServiceReference reference) {
        return !this.containsRef(reference);
    }

    public void addedService(ServiceReference reference) {
        this.importFactory(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        for (int i = 0; i < this.m_factories.size(); ++i) {
            Record rec = (Record)this.m_factories.get(i);
            if (rec.m_ref != reference) continue;
            Properties dict = new Properties();
            for (int j = 0; j < reference.getPropertyKeys().length; ++j) {
                ((Dictionary)dict).put(reference.getPropertyKeys()[j], reference.getProperty(reference.getPropertyKeys()[j]));
            }
            rec.m_reg.setProperties((Dictionary)dict);
            return;
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        if (this.containsRef(reference)) {
            this.removeFactory(reference);
        }
    }

    private class Record {
        private ServiceReference m_ref;
        private ServiceRegistration m_reg;
        private FactoryProxy m_fact;

        private Record() {
        }
    }
}

