/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.AbstractMapping;
import org.apache.felix.http.whiteboard.internal.manager.DefaultHttpContext;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public final class HttpContextManager {
    private final HashMap<String, HttpContextHolder> idMap = new HashMap();
    private final HashMap<HttpContext, String> contextMap = new HashMap();
    private final HashMap<String, Set<AbstractMapping>> orphanMappings = new HashMap();

    private static String createId(Bundle bundle, String contextId) {
        if (bundle != null) {
            return bundle.getBundleId() + "-" + (contextId == null ? "" : contextId);
        }
        return HttpContextManager.createId(contextId);
    }

    private static String createId(String contextId) {
        return "shared-" + (contextId == null ? "" : contextId);
    }

    private static String getContextId(String id) {
        int dash = id.indexOf(45);
        return dash < 0 ? id : id.substring(dash + 1);
    }

    public synchronized HttpContext getHttpContext(Bundle bundle, String contextId, AbstractMapping mapping) {
        String id = HttpContextManager.createId(bundle, contextId);
        HttpContextHolder holder = this.idMap.get(id);
        if (holder == null) {
            id = HttpContextManager.createId(contextId);
            holder = this.idMap.get(id);
        }
        if (holder == null) {
            if (ExtenderManager.isEmpty(contextId)) {
                this.addHttpContext(bundle, "", new DefaultHttpContext(bundle));
                return this.getHttpContext(bundle, "", mapping);
            }
            Set<AbstractMapping> orphaned = this.orphanMappings.get(contextId);
            if (orphaned == null) {
                orphaned = new HashSet<AbstractMapping>();
                this.orphanMappings.put(contextId, orphaned);
            }
            if (contextId != null) {
                SystemLogger.debug("Holding off mapping with unregistered context with id [" + contextId + "]");
            }
            orphaned.add(mapping);
            return null;
        }
        if (contextId != null) {
            SystemLogger.debug("Reusing context with id [" + contextId + "]");
        }
        holder.addMapping(mapping);
        return holder.getContext();
    }

    public synchronized void ungetHttpContext(Bundle bundle, String contextId, AbstractMapping mapping) {
        String id = HttpContextManager.createId(bundle, contextId);
        HttpContextHolder context = this.idMap.get(id);
        if (context == null) {
            id = HttpContextManager.createId(contextId);
            context = this.idMap.get(id);
        }
        if (context != null) {
            context.removeMapping(mapping);
        } else {
            Set<AbstractMapping> orphans = this.orphanMappings.get(contextId);
            if (orphans != null) {
                orphans.remove(mapping);
                if (orphans.isEmpty()) {
                    this.orphanMappings.remove(contextId);
                }
            }
            mapping.setContext(null);
        }
    }

    public synchronized Collection<AbstractMapping> addHttpContext(Bundle bundle, String contextId, HttpContext context) {
        String id = HttpContextManager.createId(bundle, contextId);
        HttpContextHolder holder = new HttpContextHolder(context);
        Set<AbstractMapping> orphans = this.orphanMappings.remove(contextId);
        if (orphans != null) {
            Iterator<AbstractMapping> mi = orphans.iterator();
            while (mi.hasNext()) {
                AbstractMapping mapping = mi.next();
                if (bundle != null && !bundle.equals(mapping.getBundle())) continue;
                holder.addMapping(mapping);
                mi.remove();
            }
            if (!orphans.isEmpty()) {
                this.orphanMappings.put(contextId, orphans);
            }
        }
        this.idMap.put(id, holder);
        this.contextMap.put(context, id);
        return new HashSet<AbstractMapping>(holder.getMappings());
    }

    public synchronized Collection<AbstractMapping> removeHttpContext(HttpContext context) {
        HttpContextHolder holder;
        String id = this.contextMap.remove(context);
        if (id != null && (holder = this.idMap.remove(id)) != null) {
            Set<AbstractMapping> mappings = holder.getMappings();
            if (mappings != null && !mappings.isEmpty()) {
                String contextId = HttpContextManager.getContextId(id);
                Set<AbstractMapping> orphans = this.orphanMappings.get(contextId);
                if (orphans == null) {
                    orphans = new HashSet<AbstractMapping>();
                    this.orphanMappings.put(HttpContextManager.getContextId(id), orphans);
                }
                for (AbstractMapping mapping : mappings) {
                    mapping.setContext(null);
                    orphans.add(mapping);
                }
            }
            return mappings;
        }
        return null;
    }

    synchronized Map<String, HttpContextHolder> getHttpContexts() {
        return new HashMap<String, HttpContextHolder>(this.idMap);
    }

    synchronized Map<String, Set<AbstractMapping>> getOrphanMappings() {
        return new HashMap<String, Set<AbstractMapping>>(this.orphanMappings);
    }

    static class HttpContextHolder {
        private final HttpContext context;
        private final Set<AbstractMapping> mappings;

        HttpContextHolder(HttpContext context) {
            this.context = context;
            this.mappings = new HashSet<AbstractMapping>();
        }

        public HttpContext getContext() {
            return this.context;
        }

        void addMapping(AbstractMapping mapping) {
            this.mappings.add(mapping);
            mapping.setContext(this.getContext());
        }

        void removeMapping(AbstractMapping mapping) {
            mapping.setContext(null);
            this.mappings.remove(mapping);
        }

        public Set<AbstractMapping> getMappings() {
            return this.mappings;
        }
    }
}

