/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.AbstractActivator;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.apache.felix.http.whiteboard.internal.manager.HttpWhiteboardWebConsolePlugin;
import org.apache.felix.http.whiteboard.internal.tracker.FilterTracker;
import org.apache.felix.http.whiteboard.internal.tracker.HttpContextTracker;
import org.apache.felix.http.whiteboard.internal.tracker.HttpServiceTracker;
import org.apache.felix.http.whiteboard.internal.tracker.ServletTracker;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public final class WhiteboardActivator
extends AbstractActivator {
    private final ArrayList<ServiceTracker> trackers = new ArrayList();
    private ExtenderManager manager;
    private ServiceRegistration httpPlugin;

    @Override
    protected void doStart() throws Exception {
        this.manager = new ExtenderManager();
        this.addTracker(new HttpContextTracker(this.getBundleContext(), this.manager));
        this.addTracker(new FilterTracker(this.getBundleContext(), this.manager));
        this.addTracker(new ServletTracker(this.getBundleContext(), this.manager));
        this.addTracker(new HttpServiceTracker(this.getBundleContext(), this.manager));
        HttpWhiteboardWebConsolePlugin plugin = new HttpWhiteboardWebConsolePlugin(this.manager);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("felix.webconsole.label", plugin.getLabel());
        props.put("felix.webconsole.title", plugin.getTitle());
        props.put("felix.webconsole.configprinter.modes", new String[]{"txt", "zip"});
        props.put("service.description", "Felix Http Whiteboard WebConsole Plugin and Configuration Printer");
        this.httpPlugin = this.getBundleContext().registerService("javax.servlet.Servlet", (Object)plugin, props);
        SystemLogger.info("Http service whiteboard started");
    }

    private void addTracker(ServiceTracker tracker) {
        this.trackers.add(tracker);
        tracker.open();
    }

    @Override
    protected void doStop() throws Exception {
        this.httpPlugin.unregister();
        for (ServiceTracker tracker : this.trackers) {
            tracker.close();
        }
        this.trackers.clear();
        this.manager.unregisterAll();
    }
}

