/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import javax.servlet.Filter;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.AbstractMapping;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpService;

public final class FilterMapping
extends AbstractMapping {
    private final Filter filter;
    private final int ranking;
    private final String pattern;

    public FilterMapping(Bundle bundle, Filter filter, String pattern, int ranking) {
        super(bundle);
        this.filter = filter;
        this.pattern = pattern;
        this.ranking = ranking;
    }

    Filter getFilter() {
        return this.filter;
    }

    int getRanking() {
        return this.ranking;
    }

    String getPattern() {
        return this.pattern;
    }

    public void register(HttpService httpService) {
        if (httpService instanceof ExtHttpService) {
            this.register((ExtHttpService)httpService);
        }
    }

    private void register(ExtHttpService httpService) {
        if (!this.isRegistered() && this.getContext() != null) {
            try {
                httpService.registerFilter(this.filter, this.pattern, this.getInitParams(), this.ranking, this.getContext());
                this.setRegistered(true);
            }
            catch (Exception e) {
                SystemLogger.error("Failed to register filter", e);
            }
        }
    }

    public void unregister(HttpService httpService) {
        if (httpService instanceof ExtHttpService && this.isRegistered()) {
            this.unregister((ExtHttpService)httpService);
            this.setRegistered(false);
        }
    }

    private void unregister(ExtHttpService httpService) {
        httpService.unregisterFilter(this.filter);
    }
}

