/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.AbstractMapping;
import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.apache.felix.http.whiteboard.internal.manager.FilterMapping;
import org.apache.felix.http.whiteboard.internal.manager.HttpContextManager;
import org.apache.felix.http.whiteboard.internal.manager.ServletMapping;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public final class ExtenderManagerImpl
implements ExtenderManager {
    private static final String CONTEXT_ID_KEY = "contextId";
    private static final String PATTERN_KEY = "pattern";
    private static final String ALIAS_KEY = "alias";
    private static final String INIT_KEY_PREFIX = "init.";
    private HttpService httpService;
    private final HashMap<Object, AbstractMapping> mapping = new HashMap();
    private final HttpContextManager contextManager = new HttpContextManager();

    private String getStringProperty(ServiceReference ref, String key) {
        Object value = ref.getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    private int getIntProperty(ServiceReference ref, String key, int defValue) {
        Object value = ref.getProperty(key);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    private void addInitParams(ServiceReference ref, AbstractMapping mapping) {
        for (String key : ref.getPropertyKeys()) {
            if (!key.startsWith(INIT_KEY_PREFIX)) continue;
            String paramKey = key.substring(INIT_KEY_PREFIX.length());
            String paramValue = this.getStringProperty(ref, key);
            if (paramValue == null) continue;
            mapping.getInitParams().put(paramKey, paramValue);
        }
    }

    public void add(HttpContext service, ServiceReference ref) {
        Bundle bundle = ref.getBundle();
        String contextId = this.getStringProperty(ref, CONTEXT_ID_KEY);
        if (contextId != null) {
            this.contextManager.addHttpContext(bundle, contextId, service);
        }
    }

    public void remove(HttpContext service) {
        this.contextManager.removeHttpContext(service);
    }

    private HttpContext getHttpContext(ServiceReference ref) {
        Bundle bundle = ref.getBundle();
        String contextId = this.getStringProperty(ref, CONTEXT_ID_KEY);
        return contextId != null ? this.contextManager.getHttpContext(bundle, contextId) : null;
    }

    public void add(Filter service, ServiceReference ref) {
        int ranking = this.getIntProperty(ref, "service.ranking", 0);
        String pattern = this.getStringProperty(ref, PATTERN_KEY);
        if (pattern == null) {
            return;
        }
        FilterMapping mapping = new FilterMapping(this.getHttpContext(ref), service, pattern, ranking);
        this.addInitParams(ref, mapping);
        this.addMapping(service, mapping);
    }

    public void remove(Filter service) {
        this.removeMapping(service);
    }

    public void add(Servlet service, ServiceReference ref) {
        String alias = this.getStringProperty(ref, ALIAS_KEY);
        if (alias == null) {
            return;
        }
        ServletMapping mapping = new ServletMapping(this.getHttpContext(ref), service, alias);
        this.addInitParams(ref, mapping);
        this.addMapping(service, mapping);
    }

    public void remove(Servlet service) {
        this.removeMapping(service);
    }

    public synchronized void setHttpService(HttpService service) {
        this.httpService = service;
        if (this.httpService instanceof ExtHttpService) {
            SystemLogger.info("Detected extended HttpService. Filters enabled.");
        } else {
            SystemLogger.info("Detected standard HttpService. Filters disabled.");
        }
        this.registerAll();
    }

    public synchronized void unsetHttpService() {
        this.unregisterAll();
        this.httpService = null;
    }

    public synchronized void unregisterAll() {
        if (this.httpService != null) {
            for (AbstractMapping mapping : this.mapping.values()) {
                mapping.unregister(this.httpService);
            }
        }
    }

    private synchronized void registerAll() {
        if (this.httpService != null) {
            for (AbstractMapping mapping : this.mapping.values()) {
                mapping.register(this.httpService);
            }
        }
    }

    private synchronized void addMapping(Object key, AbstractMapping mapping) {
        this.mapping.put(key, mapping);
        if (this.httpService != null) {
            mapping.register(this.httpService);
        }
    }

    private synchronized void removeMapping(Object key) {
        AbstractMapping mapping = this.mapping.remove(key);
        if (mapping != null && this.httpService != null) {
            mapping.unregister(this.httpService);
        }
    }
}

