/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.dispatch.Dispatcher;
import org.apache.felix.http.base.internal.handler.HandlerRegistry;
import org.apache.felix.http.base.internal.service.HttpServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpServiceController {
    private final BundleContext bundleContext;
    private final HandlerRegistry registry;
    private final Dispatcher dispatcher;
    private final Hashtable<String, Object> serviceProps;
    private ServiceRegistration serviceReg;

    public HttpServiceController(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.registry = new HandlerRegistry();
        this.dispatcher = new Dispatcher(this.registry);
        this.serviceProps = new Hashtable();
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setProperties(Hashtable<String, Object> props) {
        this.serviceProps.clear();
        this.serviceProps.putAll(props);
        if (this.serviceReg != null) {
            this.serviceReg.setProperties(this.serviceProps);
        }
    }

    public void register(ServletContext servletContext) {
        HttpServiceFactory factory = new HttpServiceFactory(servletContext, this.registry);
        String[] ifaces = new String[]{HttpService.class.getName(), ExtHttpService.class.getName()};
        this.serviceReg = this.bundleContext.registerService(ifaces, (Object)factory, this.serviceProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        if (this.serviceReg == null) {
            return;
        }
        try {
            this.serviceReg.unregister();
            this.registry.removeAll();
        }
        finally {
            this.serviceReg = null;
        }
    }
}

