/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.AbstractHttpActivator;
import org.apache.felix.http.jetty.internal.ConfigMetaTypeProvider;
import org.apache.felix.http.jetty.internal.JettyService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public final class JettyActivator
extends AbstractHttpActivator {
    private JettyService jetty;
    private ServiceRegistration<?> metatypeReg;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Metatype provider for Jetty Http Service");
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)properties).put("metatype.pid", "org.apache.felix.http");
        this.metatypeReg = this.getBundleContext().registerService("org.osgi.service.metatype.MetaTypeProvider", (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return new ConfigMetaTypeProvider(JettyActivator.this.getBundleContext().getBundle());
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, properties);
        this.jetty = new JettyService(this.getBundleContext(), this.getDispatcherServlet(), this.getEventDispatcher(), this.getHttpServiceController());
        this.jetty.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.jetty.stop();
        if (this.metatypeReg != null) {
            this.metatypeReg.unregister();
            this.metatypeReg = null;
        }
        super.doStop();
    }
}

