/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.dispatch.RequestDispatcherProvider;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.util.UriUtils;

public final class ServletPipeline
implements RequestDispatcherProvider {
    private final ServletHandler[] handlers;

    public ServletPipeline(ServletHandler[] handlers) {
        this.handlers = handlers;
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        for (ServletHandler handler : this.handlers) {
            if (!name.equals(handler.getName())) continue;
            return handler.createNamedRequestDispatcher();
        }
        return null;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || !path.startsWith("/") && !"".equals(path)) {
            return null;
        }
        String query = null;
        int q = 0;
        q = path.indexOf(63);
        if (q > 0) {
            query = path.substring(q + 1);
            path = path.substring(0, q);
        }
        String pathInContext = UriUtils.decodePath(UriUtils.removeDotSegments(path));
        for (ServletHandler handler : this.handlers) {
            if (!handler.matches(pathInContext)) continue;
            return handler.createRequestDispatcher(path, pathInContext, query);
        }
        return null;
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        for (ServletHandler handler : this.handlers) {
            if (!handler.handle(req, res)) continue;
            return true;
        }
        return false;
    }

    public boolean hasServletsMapped() {
        return this.handlers.length > 0;
    }
}

