/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;

public final class JettyLogger
implements Logger {
    private final String name;
    private boolean debugEnabled;

    public JettyLogger() {
        this("org.mortbay.log");
    }

    public JettyLogger(String name) {
        this.name = name;
    }

    public Logger getLogger(String name) {
        JettyLogger logger = new JettyLogger(name);
        logger.setDebugEnabled(this.debugEnabled);
        return logger;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    public void debug(String msg, Throwable cause) {
        if (this.debugEnabled) {
            SystemLogger.debug(msg);
        }
    }

    public void debug(String msg, Object arg0, Object arg1) {
        if (this.debugEnabled) {
            SystemLogger.debug(this.format(msg, arg0, arg1));
        }
    }

    public void info(String msg, Object arg0, Object arg1) {
        if (this.debugEnabled) {
            SystemLogger.info(this.format(msg, arg0, arg1));
        }
    }

    public void warn(String msg, Throwable cause) {
        SystemLogger.warning(msg, cause);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        SystemLogger.warning(this.format(msg, arg0, arg1), null);
    }

    public String toString() {
        return this.name;
    }

    private String format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
        }
        if (arg0 != null && i0 >= 0) {
            msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        PrintStream out = System.err;
        try {
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
            Log.setLog(new JettyLogger());
        }
        finally {
            System.setErr(out);
        }
    }
}

