/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.jetty.ServletContextGroup;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;

public class OsgiServletHolder
extends ServletHolder {
    private Servlet m_servlet;
    private ServletContextGroup m_servletContextGroup;
    private ServletConfig m_config;

    public OsgiServletHolder(ServletHandler handler, Servlet servlet, String name, ServletContextGroup servletContextGroup, Dictionary params) {
        super(servlet);
        this.setServletHandler(handler);
        this.setName(name);
        this.m_servlet = servlet;
        this.m_servletContextGroup = servletContextGroup;
        if (params != null) {
            Enumeration e = params.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.setInitParameter(String.valueOf(key), String.valueOf(params.get(key)));
            }
        }
    }

    public synchronized Servlet getServlet() {
        return this.m_servlet;
    }

    public Servlet getOsgiServlet() {
        return this.m_servlet;
    }

    public synchronized Object newInstance() {
        return this.getOsgiServlet();
    }

    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        if (this.m_servletContextGroup.getOsgiHttpContext().handleSecurity((HttpServletRequest)request, (HttpServletResponse)response)) {
            request = new HttpServiceHttpServletRequest((HttpServletRequest)request);
            super.handle(request, response);
        } else {
            try {
                response.getClass().getDeclaredMethod("flushBuffer", null).invoke((Object)response, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void doStart() throws Exception {
        this._class = this.m_servlet.getClass();
        this.m_config = new ServletHolder.Config(){

            public ServletContext getServletContext() {
                return OsgiServletHolder.this.m_servletContextGroup;
            }
        };
        this.m_servlet.init(this.m_config);
    }

    public void doStop() {
    }

    private static class HttpServiceHttpServletRequest
    extends HttpServletRequestWrapper {
        HttpServiceHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public String getAuthType() {
            Object name = this.getAttribute("org.osgi.service.http.authentication.type");
            if (name != null) {
                return name.toString();
            }
            return super.getAuthType();
        }

        public String getRemoteUser() {
            Object name = this.getAttribute("org.osgi.service.http.authentication.remote.user");
            if (name != null) {
                return name.toString();
            }
            return super.getRemoteUser();
        }
    }
}

