/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.jetty.Activator;
import org.apache.felix.http.jetty.ServletContextGroup;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.service.http.HttpContext;

public class OsgiResourceHolder
extends ServletHolder {
    private ServletContextGroup m_servletContextGroup;
    private HttpContext m_osgiHttpContext;
    private AccessControlContext m_acc;
    private String m_path;

    public OsgiResourceHolder(ServletHandler handler, String name, String path, ServletContextGroup servletContextGroup) {
        this.setServletHandler(handler);
        this.setName(name);
        this.m_servletContextGroup = servletContextGroup;
        this.m_osgiHttpContext = servletContextGroup.getOsgiHttpContext();
        this.m_path = path;
        if (this.m_path == null) {
            this.m_path = "";
        }
        if (System.getSecurityManager() != null) {
            this.m_acc = AccessController.getContext();
        }
    }

    public synchronized Servlet getServlet() {
        return null;
    }

    public synchronized Object newInstance() {
        return null;
    }

    public void handle(ServletRequest sRequest, ServletResponse sResponse) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)sRequest;
        HttpServletResponse response = (HttpServletResponse)sResponse;
        String target = request.getPathInfo();
        if (target == null) {
            target = "";
        }
        if (!target.startsWith("/")) {
            target = target + "/" + target;
        }
        Activator.debug("handle for name:" + this.m_path + " (path=" + target + ")");
        if (!this.m_osgiHttpContext.handleSecurity(request, response)) {
            return;
        }
        String resName = this.m_path + target;
        Activator.debug("** looking for: " + resName);
        URL url = this.m_osgiHttpContext.getResource(resName);
        if (url == null) {
            Request base_request = sRequest instanceof Request ? (Request)sRequest : HttpConnection.getCurrentConnection().getRequest();
            base_request.setHandled(false);
            return;
        }
        Activator.debug("serving up:" + resName);
        String method = request.getMethod();
        if (method.equals("GET") || method.equals("POST") || method.equals("HEAD")) {
            this.handleGet(request, response, url, resName);
        } else {
            try {
                response.sendError(501);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void handleGet(HttpServletRequest request, final HttpServletResponse response, final URL url, String resName) throws IOException {
        String encoding = this.m_osgiHttpContext.getMimeType(resName);
        if (encoding == null) {
            encoding = this.m_servletContextGroup.getMimeType(resName);
        }
        if (encoding == null) {
            encoding = this.m_servletContextGroup.getMimeType(".default");
        }
        response.setContentType(encoding);
        long lastModified = this.getLastModified(url);
        if (lastModified != 0L) {
            response.setDateHeader("Last-Modified", lastModified);
        }
        if (!this.resourceModified(lastModified, request.getDateHeader("If-Modified-Since"))) {
            response.setStatus(304);
        } else if (this.m_acc != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        OsgiResourceHolder.this.copyResourceBytes(url, response);
                        return null;
                    }
                }, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                IOException ioe = (IOException)ex.getException();
                throw ioe;
            }
        } else {
            this.copyResourceBytes(url, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceBytes(URL url, HttpServletResponse response) throws IOException {
        ServletOutputStream os = null;
        InputStream is = null;
        try {
            os = response.getOutputStream();
            is = url.openStream();
            int len = 0;
            byte[] buf = new byte[1024];
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                os.write(buf, 0, n);
                len += n;
            }
            try {
                response.setContentLength(len);
            }
            catch (IllegalStateException ex) {
                Activator.log(1, "OsgiResourceHandler", ex);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public void doStart() throws Exception {
    }

    public void doStop() {
    }

    protected long getLastModified(URL resUrl) {
        File f;
        String filepath;
        long lastModified = 0L;
        try {
            URLConnection conn = resUrl.openConnection();
            lastModified = conn.getLastModified();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (lastModified == 0L && (filepath = resUrl.getPath()) != null && (f = new File(filepath)).exists()) {
            lastModified = f.lastModified();
        }
        Activator.debug("url: " + resUrl + ", lastModified:" + lastModified);
        return lastModified;
    }

    protected boolean resourceModified(long resTimestamp, long modSince) {
        boolean retval = false;
        if ((resTimestamp /= 1000L) == 0L || (modSince /= 1000L) == -1L || resTimestamp > modSince) {
            retval = true;
        }
        return retval;
    }
}

