/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.http.jetty.Activator;
import org.apache.felix.http.jetty.DefaultContextImpl;
import org.apache.felix.http.jetty.ServletContextGroup;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.OsgiServletHandler;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService {
    private static Map m_aliasNamespace = null;
    private Set m_localAliasSet = null;
    private Bundle m_bundle = null;
    private Server m_server = null;
    private OsgiServletHandler m_serverServletHandler = null;

    public HttpServiceImpl(Bundle bundle, Server server, OsgiServletHandler serverServletHandler) {
        this.m_bundle = bundle;
        this.m_server = server;
        this.m_serverServletHandler = serverServletHandler;
        this.m_localAliasSet = new HashSet();
        if (m_aliasNamespace == null) {
            m_aliasNamespace = new HashMap();
        }
    }

    public static void initializeStatics() {
        if (m_aliasNamespace != null) {
            m_aliasNamespace.clear();
        }
        ServletContextGroup.initializeStatics();
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultContextImpl(this.m_bundle);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary params, HttpContext osgiHttpContext) throws ServletException, NamespaceException {
        Activator.debug("http register servlet :" + this.m_bundle + ", alias: " + alias);
        if (!this.aliasValid(alias)) {
            throw new IllegalArgumentException("malformed alias");
        }
        if (ServletContextGroup.isServletRegistered(servlet)) {
            throw new ServletException("servlet already registered");
        }
        this.addAlias(alias, null);
        ServletContextGroup grp = null;
        if (osgiHttpContext == null) {
            osgiHttpContext = this.createDefaultHttpContext();
        }
        Activator.debug("looking for context: " + osgiHttpContext);
        grp = ServletContextGroup.getServletContextGroup(this.m_serverServletHandler, osgiHttpContext);
        grp.addServlet(servlet, alias, params);
        this.updateAlias(alias, grp);
    }

    public void registerResources(String alias, String name, HttpContext osgiHttpContext) throws NamespaceException {
        Activator.debug("** http register resource :" + this.m_bundle + ", alias: " + alias);
        if (!this.aliasValid(alias)) {
            throw new IllegalArgumentException("malformed alias: " + alias);
        }
        if (!this.nameValid(name)) {
            throw new IllegalArgumentException("malformed name: " + name);
        }
        this.addAlias(alias, null);
        Object hdlrContext = null;
        if (osgiHttpContext == null) {
            osgiHttpContext = this.createDefaultHttpContext();
        }
        Activator.debug("looking for context: " + osgiHttpContext);
        ServletContextGroup grp = ServletContextGroup.getServletContextGroup(this.m_serverServletHandler, osgiHttpContext);
        grp.addResource(alias, name);
        this.updateAlias(alias, grp);
    }

    public void unregister(String alias) {
        this.doUnregister(alias, true);
    }

    protected void unregisterAll() {
        String[] all = this.m_localAliasSet.toArray(new String[0]);
        for (int ix = 0; ix < all.length; ++ix) {
            this.doUnregister(all[ix], false);
        }
    }

    protected void doUnregister(String alias, boolean forced) {
        Activator.debug("** http unregister servlet :" + this.m_bundle + ", alias: " + alias + ",forced:" + forced);
        ServletContextGroup grp = this.removeAlias(alias);
        if (grp != null) {
            grp.remove(alias, forced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAlias(String alias, Object obj) throws NamespaceException {
        Map map = m_aliasNamespace;
        synchronized (map) {
            if (m_aliasNamespace.containsKey(alias)) {
                throw new NamespaceException("alias already registered");
            }
            m_aliasNamespace.put(alias, obj);
            this.m_localAliasSet.add(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServletContextGroup removeAlias(String alias) {
        Map map = m_aliasNamespace;
        synchronized (map) {
            Object obj = m_aliasNamespace.remove(alias);
            this.m_localAliasSet.remove(alias);
            return (ServletContextGroup)obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAlias(String alias, Object obj) {
        Map map = m_aliasNamespace;
        synchronized (map) {
            if (m_aliasNamespace.containsKey(alias)) {
                m_aliasNamespace.put(alias, obj);
            }
        }
    }

    protected boolean aliasValid(String alias) {
        if (alias == null) {
            return false;
        }
        return alias.equals("/") || alias.startsWith("/") && !alias.endsWith("/");
    }

    protected boolean nameValid(String name) {
        if (name == null) {
            return false;
        }
        return !name.endsWith("/");
    }
}

