/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.dto.DTO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;

public class HttpServicePlugin
extends HttpServlet {
    private static final String ATTR_TEST = "test";
    private static final String ATTR_MSG = "msg";
    private static final String ATTR_SUBMIT = "resolve";
    private final HttpServiceRuntime runtime;
    private final BundleContext context;
    private volatile ServiceRegistration<Servlet> serviceReg;

    public HttpServicePlugin(BundleContext context, HttpServiceRuntime runtime) {
        this.runtime = runtime;
        this.context = context;
    }

    public void register() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)props).put("service.description", "HTTP Service Web Console Plugin");
        ((Dictionary)props).put("felix.webconsole.label", "httpservice");
        ((Dictionary)props).put("felix.webconsole.title", "HTTP Service");
        ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
        this.serviceReg = this.context.registerService(Servlet.class, (Object)this, props);
    }

    private static String escapeXml(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            if (c == '\'') {
                b.append("&apos;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String test = request.getParameter(ATTR_TEST);
        String msg = null;
        if (test != null && test.length() > 0) {
            RequestInfoDTO dto = this.runtime.calculateRequestInfoDTO(test);
            StringBuilder sb = new StringBuilder();
            if (dto.servletDTO != null) {
                sb.append("Servlet: ");
                sb.append(this.getValueAsString(dto.servletDTO.patterns));
                sb.append(" (");
                sb.append("service.id=");
                sb.append(String.valueOf(dto.servletDTO.serviceId));
                sb.append("), Filters: [");
                boolean first = true;
                for (FilterDTO f : dto.filterDTOs) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(f.serviceId);
                }
                sb.append("]");
            } else if (dto.resourceDTO != null) {
                sb.append("Resource: ");
                sb.append(this.getValueAsString(dto.resourceDTO.patterns));
                sb.append(" (");
                sb.append("service.id=");
                sb.append(String.valueOf(dto.resourceDTO.serviceId));
                sb.append("), Filters: [");
                boolean first = true;
                for (FilterDTO f : dto.filterDTOs) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(f.serviceId);
                }
                sb.append("]");
            } else {
                sb.append("<404>");
            }
            msg = sb.toString();
        }
        String path = request.getContextPath() + request.getServletPath() + request.getPathInfo();
        String redirectTo = msg == null ? path : path + '?' + ATTR_MSG + '=' + this.encodeParam(msg) + '&' + ATTR_TEST + '=' + this.encodeParam(test);
        response.sendRedirect(redirectTo);
    }

    private String encodeParam(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RuntimeDTO dto = this.runtime.getRuntimeDTO();
        PrintWriter pw = resp.getWriter();
        String path = req.getContextPath() + req.getServletPath();
        if (req.getPathInfo() != null) {
            path = path + req.getPathInfo();
        }
        this.printForm(pw, req.getParameter(ATTR_TEST), req.getParameter(ATTR_MSG), path);
        this.printRuntimeDetails(pw, dto.serviceDTO);
        for (ServletContextDTO servletContextDTO : dto.servletContextDTOs) {
            this.printContextDetails(pw, servletContextDTO);
        }
        for (ServletContextDTO servletContextDTO : dto.failedServletContextDTOs) {
            this.printFailedContextDetails(pw, (FailedServletContextDTO)servletContextDTO);
        }
        this.printFailedServletDetails(pw, dto);
        this.printFailedFilterDetails(pw, dto);
        this.printFailedResourceDetails(pw, dto);
        this.printFailedErrorPageDetails(pw, dto);
        this.printFailedListenerDetails(pw, dto);
        pw.println("<br/>");
    }

    private void printForm(PrintWriter pw, String value, String msg, String path) {
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        this.separatorHtml(pw);
        this.titleHtml(pw, "Test Servlet Resolution", "To test the servlet resolution, enter a relative URL into the field and click 'Resolve'.");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Test</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print("<form method='POST' action='");
        pw.print(path);
        pw.print("'>");
        pw.print("<input type='text' name='test' value='");
        if (value != null) {
            pw.print(HttpServicePlugin.escapeXml(value));
        }
        pw.println("' class='input' size='50'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='resolve' value='Resolve' class='submit'>");
        pw.print("</form>");
        pw.print("</td>");
        pw.println("</tr>");
        if (msg != null) {
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>&nbsp;</td>");
            pw.print("<td class='content' colspan='2'>");
            pw.print(HttpServicePlugin.escapeXml(msg));
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</table>");
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        pw.println("<tr class='content'>");
        pw.println("<th colspan='3'class='content container'>" + title + "</th>");
        pw.println("</tr>");
        if (description != null) {
            pw.println("<tr class='content'>");
            pw.println("<td colspan='3'class='content'>" + description + "</th>");
            pw.println("</tr>");
        }
    }

    private void separatorHtml(PrintWriter pw) {
        pw.println("<tr class='content'>");
        pw.println("<td class='content' colspan='3'>&nbsp;</td>");
        pw.println("</tr>");
    }

    private String getValueAsString(Object value) {
        if (value.getClass().isArray()) {
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value);
            }
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    private void printRuntimeDetails(PrintWriter pw, ServiceReferenceDTO dto) {
        pw.println("<p class=\"statline ui-state-highlight\">${Runtime Properties}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Value}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (Map.Entry prop : dto.properties.entrySet()) {
            odd = this.printRow(pw, odd, (String)prop.getKey(), this.getValueAsString(prop.getValue()));
        }
        pw.println("</table>");
        pw.println("<br/>");
    }

    private boolean printRow(PrintWriter pw, boolean odd, String ... columns) {
        pw.print("<tr class=\"");
        if (odd) {
            pw.print("odd");
        } else {
            pw.print("even");
        }
        pw.println(" ui-state-default\">");
        for (String val : columns) {
            pw.print("<td>");
            if (val != null) {
                int pos;
                String text = HttpServicePlugin.escapeXml(val).replace("\n", "<br/>");
                while ((pos = text.indexOf("${#link:")) != -1) {
                    int endPos = text.indexOf("}", pos);
                    int bundleId = Integer.valueOf(text.substring(pos + 8, endPos));
                    int tokenEndPos = text.indexOf("${link#}", pos);
                    text = text.substring(0, pos) + "<a href=\"${appRoot}/bundles/" + String.valueOf(bundleId) + "\">" + text.substring(endPos + 1, tokenEndPos) + "</a>" + text.substring(tokenEndPos + 8);
                }
                pw.print(text);
            }
            pw.println("</td>");
        }
        pw.println("</tr>");
        return !odd;
    }

    private String getContextPath(String path) {
        if (path.length() == 0) {
            return "<root>";
        }
        return path;
    }

    private boolean printServiceRankingRow(PrintWriter pw, long serviceId, boolean odd) {
        Object obj;
        int ranking = 0;
        ServiceReference<?> ref = this.getServiceReference(serviceId);
        if (ref != null && (obj = ref.getProperty("service.ranking")) instanceof Integer) {
            ranking = (Integer)obj;
        }
        return this.printRow(pw, odd, "${ranking}", String.valueOf(ranking));
    }

    private void printContextDetails(PrintWriter pw, ServletContextDTO dto) {
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(HttpServicePlugin.escapeXml(dto.name));
        pw.println("'</p>");
        pw.println("<table class=\"nicetable\">");
        boolean odd = true;
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Value)}</th>");
        pw.println("</tr></thead>");
        odd = this.printRow(pw, odd, "${Path}", this.getContextPath(dto.contextPath));
        odd = this.printRow(pw, odd, "${service.id}", String.valueOf(dto.serviceId));
        odd = this.printServiceRankingRow(pw, dto.serviceId, odd);
        pw.println("</table>");
        this.printServletDetails(pw, dto);
        this.printFilterDetails(pw, dto);
        this.printResourceDetails(pw, dto);
        this.printErrorPageDetails(pw, dto);
        this.printListenerDetails(pw, dto);
        pw.println("<br/>");
    }

    private void printFailedContextDetails(PrintWriter pw, FailedServletContextDTO dto) {
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(HttpServicePlugin.escapeXml(dto.name));
        pw.println("'</p>");
        pw.println("<table class=\"nicetable\">");
        boolean odd = true;
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Value)}</th>");
        pw.println("</tr></thead>");
        odd = this.printRow(pw, odd, "${Path}", this.getContextPath(dto.contextPath));
        odd = this.printRow(pw, odd, "${reason}", this.getErrorText(dto.failureReason));
        odd = this.printRow(pw, odd, "${service.id}", String.valueOf(dto.serviceId));
        pw.println("</table>");
    }

    private void appendServiceRanking(StringBuilder sb, ServiceReference<?> ref) {
        Object obj;
        int ranking = 0;
        if (ref != null && (obj = ref.getProperty("service.ranking")) instanceof Integer) {
            ranking = (Integer)obj;
        }
        sb.append("${ranking} : ").append(String.valueOf(ranking)).append("\n");
    }

    private void printFilterDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.filterDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(HttpServicePlugin.escapeXml(dto.name));
        pw.println("' ${Registered Filter Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Pattern}</th>");
        pw.println("<th class=\"header\">${Filter}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FilterDTO filter : dto.filterDTOs) {
            ServiceReference<?> ref = this.getServiceReference(filter.serviceId);
            StringBuilder sb = new StringBuilder();
            sb.append("${service.id} : ").append(String.valueOf(filter.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(filter.asyncSupported)).append("\n");
            sb.append("${dispatcher} : ").append(this.getValueAsString(filter.dispatcher)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.addAll(Arrays.asList(filter.patterns));
            patterns.addAll(Arrays.asList(filter.regexs));
            for (String name : filter.servletNames) {
                patterns.add("Servlet : " + name);
            }
            Collections.sort(patterns);
            StringBuilder psb = new StringBuilder();
            for (String p : patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), filter.name, sb.toString());
        }
        pw.println("</table>");
    }

    private String getErrorText(int reason) {
        switch (reason) {
            case 4: {
                return "Exception on init";
            }
            case 1: {
                return "No match";
            }
            case 7: {
                return "In use";
            }
            case 5: {
                return "Not gettable";
            }
            case 2: {
                return "Context failure";
            }
            case 3: {
                return "Shadowed";
            }
            case 6: {
                return "Invalid";
            }
        }
        return "unknown";
    }

    private void printFailedFilterDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedFilterDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Filter Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Pattern}</th>");
        pw.println("<th class=\"header\">${Filter}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedFilterDTO filter : dto.failedFilterDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(filter.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(filter.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(filter.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(filter.asyncSupported)).append("\n");
            sb.append("${dispatcher} : ").append(this.getValueAsString(filter.dispatcher)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.addAll(Arrays.asList(filter.patterns));
            patterns.addAll(Arrays.asList(filter.regexs));
            for (String name : filter.servletNames) {
                patterns.add("Servlet : " + name);
            }
            Collections.sort(patterns);
            StringBuilder psb = new StringBuilder();
            for (String p : patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), filter.name, sb.toString());
        }
        pw.println("</table>");
    }

    private ServiceReference<?> getServiceReference(long serviceId) {
        if (serviceId > 0L) {
            try {
                ServiceReference[] ref = this.context.getServiceReferences((String)null, "(service.id=" + String.valueOf(serviceId));
                if (ref != null && ref.length > 0) {
                    return ref[0];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private void printServletDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.servletDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(HttpServicePlugin.escapeXml(dto.name));
        pw.println("' ${Registered Servlet Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ServletDTO servlet : dto.servletDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(servlet.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(servlet.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(servlet.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : servlet.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), servlet.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedServletDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedServletDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Servlet Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedServletDTO servlet : dto.failedServletDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(servlet.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(servlet.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(servlet.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(servlet.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : servlet.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), servlet.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printResourceDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.resourceDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(HttpServicePlugin.escapeXml(dto.name));
        pw.println("' ${Registered Resource Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Prefix}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ResourceDTO rsrc : dto.resourceDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(rsrc.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(rsrc.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : rsrc.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), rsrc.prefix, sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedResourceDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedResourceDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Resource Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Prefix}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedResourceDTO rsrc : dto.failedResourceDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(rsrc.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(rsrc.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(rsrc.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder psb = new StringBuilder();
            for (String p : rsrc.patterns) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), rsrc.prefix, sb.toString());
        }
        pw.println("</table>");
    }

    private void printErrorPageDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.errorPageDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(HttpServicePlugin.escapeXml(dto.name));
        pw.println("' ${Registered Error Pages}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ErrorPageDTO ep : dto.errorPageDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(ep.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(ep.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder psb = new StringBuilder();
            for (long p : ep.errorCodes) {
                psb.append(p).append('\n');
            }
            for (String p : ep.exceptions) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), ep.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedErrorPageDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedErrorPageDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Registered Error Pages}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Path}</th>");
        pw.println("<th class=\"header\">${Name}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedErrorPageDTO ep : dto.failedErrorPageDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(ep.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(ep.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            sb.append("${async} : ").append(String.valueOf(ep.asyncSupported)).append("\n");
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder psb = new StringBuilder();
            for (long p : ep.errorCodes) {
                psb.append(p).append('\n');
            }
            for (String p : ep.exceptions) {
                psb.append(p).append('\n');
            }
            odd = this.printRow(pw, odd, psb.toString(), ep.name, sb.toString());
        }
        pw.println("</table>");
    }

    private void printListenerDetails(PrintWriter pw, ServletContextDTO dto) {
        if (dto.listenerDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Servlet Context} '");
        pw.print(HttpServicePlugin.escapeXml(dto.name));
        pw.println("' ${Registered Listeners}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Type}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (ListenerDTO ep : dto.listenerDTOs) {
            StringBuilder sb = new StringBuilder();
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(ep.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder tsb = new StringBuilder();
            for (String t : ep.types) {
                tsb.append(t).append('\n');
            }
            odd = this.printRow(pw, odd, tsb.toString(), sb.toString());
        }
        pw.println("</table>");
    }

    private void printFailedListenerDetails(PrintWriter pw, RuntimeDTO dto) {
        if (dto.failedListenerDTOs.length == 0) {
            return;
        }
        pw.print("<p class=\"statline ui-state-highlight\">${Failed Listeners}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Type}</th>");
        pw.println("<th class=\"header\">${Info}</th>");
        pw.println("</tr></thead>");
        boolean odd = true;
        for (FailedListenerDTO ep : dto.failedListenerDTOs) {
            StringBuilder sb = new StringBuilder();
            sb.append("${reason} : ").append(this.getErrorText(ep.failureReason)).append("\n");
            ServiceReference<?> ref = this.getServiceReference(ep.serviceId);
            sb.append("${service.id} : ").append(String.valueOf(ep.serviceId)).append("\n");
            this.appendServiceRanking(sb, ref);
            if (ref != null) {
                sb.append("${bundle} : ");
                sb.append("${#link:");
                sb.append(ref.getBundle().getBundleId());
                sb.append("}");
                sb.append(ref.getBundle().getSymbolicName());
                sb.append("${link#}\n");
            }
            StringBuilder tsb = new StringBuilder();
            for (String t : ep.types) {
                tsb.append(t).append('\n');
            }
            odd = this.printRow(pw, odd, tsb.toString(), sb.toString());
        }
        pw.println("</table>");
    }

    private void printServiceIdAndRanking(PrintWriter pw, ServiceReference<?> ref, long serviceId) {
        Object obj;
        pw.print("service.id : ");
        pw.println(String.valueOf(serviceId));
        int ranking = 0;
        if (ref != null && (obj = ref.getProperty("service.ranking")) instanceof Integer) {
            ranking = (Integer)obj;
        }
        pw.print("Ranking : ");
        pw.println(String.valueOf(ranking));
    }

    /*
     * WARNING - void declaration
     */
    public void printConfiguration(PrintWriter pw) {
        int len$;
        ArrayList<String> patterns;
        ServiceReference<?> ref;
        RuntimeDTO dto = this.runtime.getRuntimeDTO();
        pw.println("HTTP Service Details");
        pw.println("====================");
        pw.println();
        pw.println("Runtime Properties");
        pw.println("------------------");
        for (Map.Entry prop : dto.serviceDTO.properties.entrySet()) {
            pw.print((String)prop.getKey());
            pw.print(" : ");
            pw.println(this.getValueAsString(prop.getValue()));
        }
        pw.println();
        for (ServletContextDTO servletContextDTO : dto.servletContextDTOs) {
            ServiceReference<?> ref2;
            pw.print("Servlet Context ");
            pw.println(servletContextDTO.name);
            pw.println("-----------------------------------------------");
            pw.print("Path : ");
            pw.println(this.getContextPath(servletContextDTO.contextPath));
            this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
            pw.println();
            if (servletContextDTO.servletDTOs.length > 0) {
                pw.println("Servlets");
                for (DTO dTO : servletContextDTO.servletDTOs) {
                    pw.print("Patterns : ");
                    pw.println(this.getValueAsString(dTO.patterns));
                    pw.print("Name : ");
                    pw.println(dTO.name);
                    ServiceReference<?> ref3 = this.getServiceReference(dTO.serviceId);
                    this.printServiceIdAndRanking(pw, ref3, dTO.serviceId);
                    pw.print("async : ");
                    pw.println(String.valueOf(dTO.asyncSupported));
                    if (ref3 != null) {
                        pw.print("Bundle : ");
                        pw.print(ref3.getBundle().getSymbolicName());
                        pw.print(" <");
                        pw.print(String.valueOf(ref3.getBundle().getBundleId()));
                        pw.println(">");
                    }
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.filterDTOs.length > 0) {
                pw.println("Filters");
                for (DTO dTO : servletContextDTO.filterDTOs) {
                    ArrayList<String> patterns2 = new ArrayList<String>();
                    patterns2.addAll(Arrays.asList(dTO.patterns));
                    patterns2.addAll(Arrays.asList(dTO.regexs));
                    for (String name : dTO.servletNames) {
                        patterns2.add("Servlet : " + name);
                    }
                    Collections.sort(patterns2);
                    pw.print("Patterns : ");
                    pw.println(patterns2);
                    pw.print("Name : ");
                    pw.println(dTO.name);
                    ServiceReference<?> serviceReference = this.getServiceReference(dTO.serviceId);
                    this.printServiceIdAndRanking(pw, serviceReference, dTO.serviceId);
                    pw.print("async : ");
                    pw.println(String.valueOf(dTO.asyncSupported));
                    pw.print("dispatcher : ");
                    pw.println(this.getValueAsString(dTO.dispatcher));
                    if (serviceReference != null) {
                        pw.print("Bundle : ");
                        pw.print(serviceReference.getBundle().getSymbolicName());
                        pw.print(" <");
                        pw.print(String.valueOf(serviceReference.getBundle().getBundleId()));
                        pw.println(">");
                    }
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.resourceDTOs.length > 0) {
                pw.println("Resources");
                for (DTO dTO : servletContextDTO.resourceDTOs) {
                    pw.print("Patterns : ");
                    pw.println(this.getValueAsString(dTO.patterns));
                    pw.print("Prefix : ");
                    pw.println(dTO.prefix);
                    ref2 = this.getServiceReference(dTO.serviceId);
                    this.printServiceIdAndRanking(pw, ref2, dTO.serviceId);
                    if (ref2 != null) {
                        pw.print("Bundle : ");
                        pw.print(ref2.getBundle().getSymbolicName());
                        pw.print(" <");
                        pw.print(String.valueOf(ref2.getBundle().getBundleId()));
                        pw.println(">");
                    }
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.errorPageDTOs.length > 0) {
                pw.println("Error Pages");
                for (DTO dTO : servletContextDTO.errorPageDTOs) {
                    ArrayList<String> patterns2 = new ArrayList<String>();
                    for (long p : dTO.errorCodes) {
                        patterns2.add(String.valueOf(p));
                    }
                    for (String p : dTO.exceptions) {
                        patterns2.add(p);
                    }
                    pw.print("Patterns : ");
                    pw.println(patterns2);
                    pw.print("Name : ");
                    pw.println(dTO.name);
                    ServiceReference<?> serviceReference = this.getServiceReference(dTO.serviceId);
                    this.printServiceIdAndRanking(pw, serviceReference, dTO.serviceId);
                    pw.print("async : ");
                    pw.println(String.valueOf(dTO.asyncSupported));
                    if (serviceReference != null) {
                        pw.print("Bundle : ");
                        pw.print(serviceReference.getBundle().getSymbolicName());
                        pw.print(" <");
                        pw.print(String.valueOf(serviceReference.getBundle().getBundleId()));
                        pw.println(">");
                    }
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.listenerDTOs.length > 0) {
                pw.println("Listeners");
                for (DTO dTO : servletContextDTO.listenerDTOs) {
                    pw.print("Types : ");
                    pw.println(this.getValueAsString(dTO.types));
                    ref2 = this.getServiceReference(dTO.serviceId);
                    this.printServiceIdAndRanking(pw, ref2, dTO.serviceId);
                    if (ref2 != null) {
                        pw.print("Bundle : ");
                        pw.print(ref2.getBundle().getSymbolicName());
                        pw.print(" <");
                        pw.print(String.valueOf(ref2.getBundle().getBundleId()));
                        pw.println(">");
                    }
                    pw.println();
                }
                pw.println();
            }
            pw.println();
        }
        if (dto.failedServletContextDTOs.length > 0) {
            for (DTO dTO : dto.failedServletContextDTOs) {
                pw.print("Failed Servlet Context ");
                pw.println(dTO.name);
                pw.println("-----------------------------------------------");
                pw.print("Reason : ");
                pw.println(this.getErrorText(dTO.failureReason));
                pw.print("Path : ");
                pw.println(this.getContextPath(dTO.contextPath));
                this.printServiceIdAndRanking(pw, this.getServiceReference(dTO.serviceId), dTO.serviceId);
                pw.println();
            }
        }
        if (dto.failedServletDTOs.length > 0) {
            pw.println("Failed Servlets");
            for (DTO dTO : dto.failedServletDTOs) {
                pw.print("Patterns : ");
                pw.println(this.getValueAsString(dTO.patterns));
                pw.print("Reason : ");
                pw.println(this.getErrorText(dTO.failureReason));
                pw.print("Name : ");
                pw.println(dTO.name);
                ref = this.getServiceReference(dTO.serviceId);
                this.printServiceIdAndRanking(pw, ref, dTO.serviceId);
                pw.print("async : ");
                pw.println(String.valueOf(dTO.asyncSupported));
                if (ref != null) {
                    pw.print("Bundle : ");
                    pw.print(ref.getBundle().getSymbolicName());
                    pw.print(" <");
                    pw.print(String.valueOf(ref.getBundle().getBundleId()));
                    pw.println(">");
                }
                pw.println();
            }
            pw.println();
        }
        if (dto.failedFilterDTOs.length > 0) {
            pw.println("Failed Filters");
            for (DTO dTO : dto.failedFilterDTOs) {
                void var10_36;
                patterns = new ArrayList<String>();
                patterns.addAll(Arrays.asList(dTO.patterns));
                patterns.addAll(Arrays.asList(dTO.regexs));
                String[] stringArray = dTO.servletNames;
                len$ = stringArray.length;
                boolean bl = false;
                while (var10_36 < len$) {
                    String name = stringArray[var10_36];
                    patterns.add("Servlet : " + name);
                    ++var10_36;
                }
                Collections.sort(patterns);
                pw.print("Patterns : ");
                pw.println(patterns);
                pw.print("Reason : ");
                pw.println(this.getErrorText(dTO.failureReason));
                pw.print("Name : ");
                pw.println(dTO.name);
                ServiceReference<?> serviceReference = this.getServiceReference(dTO.serviceId);
                this.printServiceIdAndRanking(pw, serviceReference, dTO.serviceId);
                pw.print("async : ");
                pw.println(String.valueOf(dTO.asyncSupported));
                pw.print("dispatcher : ");
                pw.println(this.getValueAsString(dTO.dispatcher));
                if (serviceReference != null) {
                    pw.print("Bundle : ");
                    pw.print(serviceReference.getBundle().getSymbolicName());
                    pw.print(" <");
                    pw.print(String.valueOf(serviceReference.getBundle().getBundleId()));
                    pw.println(">");
                }
                pw.println();
            }
            pw.println();
        }
        if (dto.failedResourceDTOs.length > 0) {
            pw.println("Failed Resources");
            for (DTO dTO : dto.failedResourceDTOs) {
                pw.print("Patterns : ");
                pw.println(this.getValueAsString(dTO.patterns));
                pw.print("Reason : ");
                pw.println(this.getErrorText(dTO.failureReason));
                pw.print("Prefix : ");
                pw.println(dTO.prefix);
                ref = this.getServiceReference(dTO.serviceId);
                this.printServiceIdAndRanking(pw, ref, dTO.serviceId);
                if (ref != null) {
                    pw.print("Bundle : ");
                    pw.print(ref.getBundle().getSymbolicName());
                    pw.print(" <");
                    pw.print(String.valueOf(ref.getBundle().getBundleId()));
                    pw.println(">");
                }
                pw.println();
            }
            pw.println();
        }
        if (dto.failedErrorPageDTOs.length > 0) {
            pw.println("Failed Error Pages");
            for (DTO dTO : dto.failedErrorPageDTOs) {
                void var10_39;
                int n;
                patterns = new ArrayList();
                long[] lArray = dTO.errorCodes;
                len$ = lArray.length;
                boolean bl = false;
                while (n < len$) {
                    long p = lArray[n];
                    patterns.add(String.valueOf(p));
                    ++n;
                }
                String[] stringArray = dTO.exceptions;
                len$ = stringArray.length;
                n = 0;
                while (var10_39 < len$) {
                    String p = stringArray[var10_39];
                    patterns.add(p);
                    ++var10_39;
                }
                pw.print("Patterns : ");
                pw.println(patterns);
                pw.print("Reason : ");
                pw.println(this.getErrorText(dTO.failureReason));
                pw.print("Name : ");
                pw.println(dTO.name);
                ServiceReference<?> serviceReference = this.getServiceReference(dTO.serviceId);
                this.printServiceIdAndRanking(pw, serviceReference, dTO.serviceId);
                pw.print("async : ");
                pw.println(String.valueOf(dTO.asyncSupported));
                if (serviceReference != null) {
                    pw.print("Bundle : ");
                    pw.print(serviceReference.getBundle().getSymbolicName());
                    pw.print(" <");
                    pw.print(String.valueOf(serviceReference.getBundle().getBundleId()));
                    pw.println(">");
                }
                pw.println();
            }
            pw.println();
        }
        if (dto.failedListenerDTOs.length > 0) {
            pw.println("Listeners");
            for (DTO dTO : dto.failedListenerDTOs) {
                pw.print("Types : ");
                pw.println(this.getValueAsString(dTO.types));
                pw.print("Reason : ");
                pw.println(this.getErrorText(dTO.failureReason));
                ref = this.getServiceReference(dTO.serviceId);
                this.printServiceIdAndRanking(pw, ref, dTO.serviceId);
                if (ref != null) {
                    pw.print("Bundle : ");
                    pw.print(ref.getBundle().getSymbolicName());
                    pw.print(" <");
                    pw.print(String.valueOf(ref.getBundle().getBundleId()));
                    pw.println(">");
                }
                pw.println();
            }
            pw.println();
        }
        pw.println();
    }

    public void unregister() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
            this.serviceReg = null;
        }
    }
}

