/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal;

import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.HttpServiceController;

public class EventDispatcher
implements HttpSessionAttributeListener,
HttpSessionListener,
HttpSessionIdListener {
    private volatile boolean active = false;
    private final HttpServiceController controller;

    EventDispatcher(HttpServiceController controller) {
        this.controller = controller;
    }

    public void setActive(boolean flag) {
        this.active = flag;
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (this.active) {
            this.controller.getSessionListener().sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.active) {
            this.controller.getSessionListener().sessionDestroyed(se);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent se) {
        if (this.active) {
            this.controller.getSessionAttributeListener().attributeAdded(se);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent se) {
        if (this.active) {
            this.controller.getSessionAttributeListener().attributeRemoved(se);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent se) {
        if (this.active) {
            this.controller.getSessionAttributeListener().attributeReplaced(se);
        }
    }

    public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        if (this.active) {
            this.controller.getSessionIdListener().sessionIdChanged(event, oldSessionId);
        }
    }
}

