/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.felix.http.base.internal.console.HttpServicePlugin;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.HttpServiceServletHandler;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.handler.WhiteboardFilterHandler;
import org.apache.felix.http.base.internal.handler.WhiteboardListenerHandler;
import org.apache.felix.http.base.internal.handler.WhiteboardServletHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.EventListenerRegistry;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.apache.felix.http.base.internal.runtime.ResourceInfo;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.runtime.dto.FailedDTOHolder;
import org.apache.felix.http.base.internal.runtime.dto.RegistryRuntime;
import org.apache.felix.http.base.internal.runtime.dto.ServletContextDTOBuilder;
import org.apache.felix.http.base.internal.service.HttpServiceFactory;
import org.apache.felix.http.base.internal.service.HttpServiceRuntimeImpl;
import org.apache.felix.http.base.internal.service.ResourceServlet;
import org.apache.felix.http.base.internal.whiteboard.FailureStateHandler;
import org.apache.felix.http.base.internal.whiteboard.HttpServiceContextHandler;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardContextHandler;
import org.apache.felix.http.base.internal.whiteboard.tracker.FilterTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ListenersTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ResourceTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ServletContextHelperTracker;
import org.apache.felix.http.base.internal.whiteboard.tracker.ServletTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.util.tracker.ServiceTracker;

public final class WhiteboardManager {
    private final BundleContext httpBundleContext;
    private final HttpServiceFactory httpServiceFactory;
    private final HttpServiceRuntimeImpl serviceRuntime;
    private final List<ServiceTracker<?, ?>> trackers = new ArrayList();
    private final HttpServicePlugin plugin;
    private final Map<String, List<WhiteboardContextHandler>> contextMap = new HashMap<String, List<WhiteboardContextHandler>>();
    private final Map<WhiteboardServiceInfo<?>, List<WhiteboardContextHandler>> servicesMap = new HashMap();
    private final HandlerRegistry registry;
    private final FailureStateHandler failureStateHandler = new FailureStateHandler();
    private volatile ServletContext webContext;
    private volatile ServiceRegistration<ServletContextHelper> defaultContextRegistration;
    private volatile ServiceRegistration<HttpServiceRuntime> runtimeServiceReg;

    public WhiteboardManager(BundleContext bundleContext, HttpServiceFactory httpServiceFactory, HandlerRegistry registry) {
        this.httpBundleContext = bundleContext;
        this.httpServiceFactory = httpServiceFactory;
        this.registry = registry;
        this.serviceRuntime = new HttpServiceRuntimeImpl(registry, this);
        this.plugin = new HttpServicePlugin(bundleContext, this.serviceRuntime);
    }

    public void start(ServletContext containerContext) {
        this.serviceRuntime.setAttribute("osgi.http.service.id", Collections.singletonList(this.httpServiceFactory.getHttpServiceServiceId()));
        this.runtimeServiceReg = this.httpBundleContext.registerService(HttpServiceRuntime.class, (Object)this.serviceRuntime, this.serviceRuntime.getAttributes());
        this.serviceRuntime.setServiceReference((ServiceReference<HttpServiceRuntime>)this.runtimeServiceReg.getReference());
        this.webContext = containerContext;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "default");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/");
        ((Dictionary)props).put("service.ranking", Integer.MIN_VALUE);
        ArrayList<HttpServiceContextHandler> list = new ArrayList<HttpServiceContextHandler>();
        ServletContextHelperInfo info = new ServletContextHelperInfo(Integer.MAX_VALUE, -1L, "org.osgi.service.http", "/", null);
        list.add(new HttpServiceContextHandler(info, this.registry.getRegistry(-1L), this.httpServiceFactory, this.webContext, this.httpBundleContext.getBundle()));
        this.contextMap.put("org.osgi.service.http", list);
        this.defaultContextRegistration = this.httpBundleContext.registerService(ServletContextHelper.class, (ServiceFactory)new ServiceFactory<ServletContextHelper>(){

            public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
                return new ServletContextHelper(bundle){};
            }

            public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
            }
        }, props);
        this.addTracker(new FilterTracker(this.httpBundleContext, this));
        this.addTracker(new ListenersTracker(this.httpBundleContext, this));
        this.addTracker(new ResourceTracker(this.httpBundleContext, this));
        this.addTracker(new ServletContextHelperTracker(this.httpBundleContext, this));
        this.addTracker(new ServletTracker(this.httpBundleContext, this));
        this.plugin.register();
    }

    private void addTracker(ServiceTracker<?, ?> tracker) {
        this.trackers.add(tracker);
        tracker.open();
    }

    public void stop() {
        this.plugin.unregister();
        for (ServiceTracker<?, ?> t : this.trackers) {
            t.close();
        }
        this.trackers.clear();
        this.serviceRuntime.setServiceReference(null);
        this.contextMap.clear();
        this.servicesMap.clear();
        this.failureStateHandler.clear();
        this.registry.reset();
        if (this.defaultContextRegistration != null) {
            this.defaultContextRegistration.unregister();
            this.defaultContextRegistration = null;
        }
        if (this.runtimeServiceReg != null) {
            this.runtimeServiceReg.unregister();
            this.runtimeServiceReg = null;
        }
        this.webContext = null;
    }

    public void setProperties(Hashtable<String, Object> props) {
        this.serviceRuntime.setAllAttributes(props);
        if (this.runtimeServiceReg != null) {
            this.serviceRuntime.setAttribute("osgi.http.service.id", Collections.singletonList(this.httpServiceFactory.getHttpServiceServiceId()));
            this.runtimeServiceReg.setProperties(this.serviceRuntime.getAttributes());
        }
    }

    public void sessionDestroyed(@Nonnull HttpSession session, Set<Long> contextIds) {
        for (Long contextId : contextIds) {
            WhiteboardContextHandler handler = this.getContextHandler(contextId);
            if (handler == null) continue;
            ExtServletContext context = handler.getServletContext(this.httpBundleContext.getBundle());
            new HttpSessionWrapper(contextId, session, context, true).invalidate();
            handler.ungetServletContext(this.httpBundleContext.getBundle());
        }
    }

    public void sessionIdChanged(@Nonnull HttpSessionEvent event, String oldSessionId, Set<Long> contextIds) {
        for (Long contextId : contextIds) {
            WhiteboardContextHandler handler = this.getContextHandler(contextId);
            if (handler == null) continue;
            handler.getRegistry().getEventListenerRegistry().sessionIdChanged(event, oldSessionId);
        }
    }

    private boolean activate(WhiteboardContextHandler handler) {
        if (!handler.activate(this.registry)) {
            return false;
        }
        ArrayList services = new ArrayList();
        for (Map.Entry<WhiteboardServiceInfo<?>, List<WhiteboardContextHandler>> entry : this.servicesMap.entrySet()) {
            if (!entry.getKey().getContextSelectionFilter().match(handler.getContextInfo().getServiceReference())) continue;
            entry.getValue().add(handler);
            if (entry.getValue().size() == 1) {
                this.failureStateHandler.remove((AbstractInfo)entry.getKey());
            }
            if (entry.getKey() instanceof ListenerInfo && ((ListenerInfo)entry.getKey()).isListenerType(ServletContextListener.class.getName())) {
                this.registerWhiteboardService(handler, entry.getKey());
                continue;
            }
            services.add(entry.getKey());
        }
        handler.getRegistry().getEventListenerRegistry().contextInitialized();
        for (WhiteboardServiceInfo whiteboardServiceInfo : services) {
            this.registerWhiteboardService(handler, whiteboardServiceInfo);
        }
        return true;
    }

    private void deactivate(WhiteboardContextHandler handler) {
        ArrayList listeners = new ArrayList();
        for (Map.Entry<WhiteboardServiceInfo<?>, List<WhiteboardContextHandler>> entry : this.servicesMap.entrySet()) {
            if (!entry.getValue().remove(handler)) continue;
            if (!this.failureStateHandler.remove((AbstractInfo)entry.getKey(), handler.getContextInfo().getServiceId())) {
                if (entry.getKey() instanceof ListenerInfo && ((ListenerInfo)entry.getKey()).isListenerType(ServletContextListener.class.getName())) {
                    listeners.add(entry.getKey());
                } else {
                    this.unregisterWhiteboardService(handler, entry.getKey());
                }
            }
            if (!entry.getValue().isEmpty()) continue;
            String string = entry.getKey().getClass().getSimpleName().substring(0, entry.getKey().getClass().getSimpleName().length() - 4);
            SystemLogger.debug("Ignoring unmatching " + string + " service " + entry.getKey().getServiceReference());
            this.failureStateHandler.add((AbstractInfo)entry.getKey(), 1);
        }
        handler.getRegistry().getEventListenerRegistry().contextDestroyed();
        for (WhiteboardServiceInfo whiteboardServiceInfo : listeners) {
            this.unregisterWhiteboardService(handler, whiteboardServiceInfo);
        }
        handler.deactivate(this.registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContextHelper(ServletContextHelperInfo info) {
        if (this.isMatchingService(info)) {
            if (info.isValid()) {
                Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
                synchronized (map) {
                    boolean activate;
                    WhiteboardContextHandler handler = new WhiteboardContextHandler(info, this.webContext, this.httpBundleContext.getBundle());
                    List<WhiteboardContextHandler> handlerList = this.contextMap.get(info.getName());
                    if (handlerList == null) {
                        handlerList = new ArrayList<WhiteboardContextHandler>();
                    }
                    boolean bl = activate = handlerList.isEmpty() || handlerList.get(0).compareTo(handler) > 0;
                    if (activate) {
                        if (this.activate(handler)) {
                            handlerList.add(handler);
                            Collections.sort(handlerList);
                            this.contextMap.put(info.getName(), handlerList);
                            if (handlerList.size() > 1) {
                                WhiteboardContextHandler oldHead = handlerList.get(1);
                                this.deactivate(oldHead);
                                String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                                SystemLogger.debug("Ignoring shadowed " + type + " service " + info.getServiceReference());
                                this.failureStateHandler.add(oldHead.getContextInfo(), 3);
                            }
                        } else {
                            String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                            SystemLogger.error("Ignoring ungettable " + type + " service " + info.getServiceReference(), null);
                            this.failureStateHandler.add(handler.getContextInfo(), 5);
                        }
                    } else {
                        handlerList.add(handler);
                        Collections.sort(handlerList);
                        this.contextMap.put(info.getName(), handlerList);
                        String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                        SystemLogger.debug("Ignoring shadowed " + type + " service " + info.getServiceReference());
                        this.failureStateHandler.add(handler.getContextInfo(), 3);
                    }
                }
            } else {
                String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                SystemLogger.debug("Ignoring invalid " + type + " service " + info.getServiceReference());
                this.failureStateHandler.add(info, 6);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextHelper(ServletContextHelperInfo info) {
        if (info.isValid()) {
            Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
            synchronized (map) {
                List<WhiteboardContextHandler> handlerList = this.contextMap.get(info.getName());
                if (handlerList != null) {
                    Iterator<WhiteboardContextHandler> i = handlerList.iterator();
                    boolean first = true;
                    boolean activateNext = false;
                    while (i.hasNext()) {
                        WhiteboardContextHandler handler = i.next();
                        if (handler.getContextInfo().equals(info)) {
                            i.remove();
                            if (!first) break;
                            this.deactivate(handler);
                            activateNext = true;
                            break;
                        }
                        first = false;
                    }
                    if (handlerList.isEmpty()) {
                        this.contextMap.remove(info.getName());
                    } else if (activateNext) {
                        boolean done = false;
                        while (!handlerList.isEmpty() && !done) {
                            WhiteboardContextHandler newHead = handlerList.get(0);
                            this.failureStateHandler.removeAll(newHead.getContextInfo());
                            if (this.activate(newHead)) {
                                done = true;
                                continue;
                            }
                            handlerList.remove(0);
                            String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                            SystemLogger.error("Ignoring ungettable " + type + " service " + info.getServiceReference(), null);
                            this.failureStateHandler.add(newHead.getContextInfo(), 5);
                        }
                    }
                }
            }
        }
        this.failureStateHandler.removeAll(info);
    }

    private List<WhiteboardContextHandler> getMatchingContexts(WhiteboardServiceInfo<?> info) {
        ArrayList<WhiteboardContextHandler> result = new ArrayList<WhiteboardContextHandler>();
        for (List<WhiteboardContextHandler> handlerList : this.contextMap.values()) {
            boolean visible;
            WhiteboardContextHandler h = handlerList.get(0);
            boolean bl = visible = h.getContextInfo().getServiceId() < 0L;
            if (!visible) {
                String filterString = "(service.id=" + String.valueOf(h.getContextInfo().getServiceId()) + ")";
                try {
                    Collection col = info.getServiceReference().getBundle().getBundleContext().getServiceReferences(ServletContextHelper.class, filterString);
                    if (!col.isEmpty()) {
                        visible = true;
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            if (!visible) continue;
            if (h.getContextInfo().getServiceReference() != null) {
                if (!info.getContextSelectionFilter().match(h.getContextInfo().getServiceReference())) continue;
                result.add(h);
                continue;
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("osgi.http.whiteboard.context.name", h.getContextInfo().getName());
            props.put("osgi.http.whiteboard.context.path", h.getContextInfo().getPath());
            if (!info.getContextSelectionFilter().matches(props)) continue;
            result.add(h);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWhiteboardService(@Nonnull WhiteboardServiceInfo<?> info) {
        if (this.isMatchingService(info)) {
            if (info.isValid()) {
                Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
                synchronized (map) {
                    List<WhiteboardContextHandler> handlerList = this.getMatchingContexts(info);
                    this.servicesMap.put(info, handlerList);
                    if (handlerList.isEmpty()) {
                        String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                        SystemLogger.debug("Ignoring unmatched " + type + " service " + info.getServiceReference());
                        this.failureStateHandler.add(info, 1);
                    } else {
                        for (WhiteboardContextHandler h : handlerList) {
                            ServletContextListener listener;
                            ListenerHandler handler;
                            this.registerWhiteboardService(h, info);
                            if (!(info instanceof ListenerInfo) || !((ListenerInfo)info).isListenerType(ServletContextListener.class.getName()) || (handler = h.getRegistry().getEventListenerRegistry().getServletContextListener((ListenerInfo)info)) == null || (listener = (ServletContextListener)handler.getListener()) == null) continue;
                            EventListenerRegistry.contextInitialized(handler.getListenerInfo(), listener, new ServletContextEvent((ServletContext)handler.getContext()));
                        }
                    }
                }
            } else {
                String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                SystemLogger.debug("Ignoring invalid " + type + " service " + info.getServiceReference());
                this.failureStateHandler.add(info, 6);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWhiteboardService(WhiteboardServiceInfo<?> info) {
        Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
        synchronized (map) {
            List<WhiteboardContextHandler> handlerList;
            if (!this.failureStateHandler.remove(info) && (handlerList = this.servicesMap.remove(info)) != null) {
                for (WhiteboardContextHandler h : handlerList) {
                    ServletContextListener listener;
                    ListenerHandler handler;
                    if (this.failureStateHandler.remove(info, h.getContextInfo().getServiceId())) continue;
                    if (info instanceof ListenerInfo && ((ListenerInfo)info).isListenerType(ServletContextListener.class.getName()) && (handler = h.getRegistry().getEventListenerRegistry().getServletContextListener((ListenerInfo)info)) != null && (listener = (ServletContextListener)handler.getListener()) != null) {
                        EventListenerRegistry.contextDestroyed(handler.getListenerInfo(), listener, new ServletContextEvent((ServletContext)handler.getContext()));
                    }
                    this.unregisterWhiteboardService(h, info);
                }
            }
            this.failureStateHandler.removeAll(info);
        }
    }

    private void registerWhiteboardService(WhiteboardContextHandler handler, WhiteboardServiceInfo<?> info) {
        try {
            ExtServletContext servletContext;
            int failureCode = -1;
            if (info instanceof ServletInfo) {
                servletContext = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext == null) {
                    failureCode = 2;
                } else {
                    WhiteboardServletHandler servletHandler = new WhiteboardServletHandler(handler.getContextInfo().getServiceId(), servletContext, (ServletInfo)info, handler.getBundleContext());
                    handler.getRegistry().registerServlet(servletHandler);
                }
            } else if (info instanceof FilterInfo) {
                servletContext = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext == null) {
                    failureCode = 2;
                } else {
                    WhiteboardFilterHandler filterHandler = new WhiteboardFilterHandler(handler.getContextInfo().getServiceId(), servletContext, (FilterInfo)info, handler.getBundleContext());
                    handler.getRegistry().registerFilter(filterHandler);
                }
            } else if (info instanceof ResourceInfo) {
                ServletInfo servletInfo = ((ResourceInfo)info).getServletInfo();
                ExtServletContext servletContext2 = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext2 == null) {
                    failureCode = 2;
                } else {
                    HttpServiceServletHandler servleHandler = new HttpServiceServletHandler(handler.getContextInfo().getServiceId(), servletContext2, servletInfo, (Servlet)new ResourceServlet(servletInfo.getPrefix()));
                    handler.getRegistry().registerServlet(servleHandler);
                }
            } else if (info instanceof ListenerInfo) {
                servletContext = handler.getServletContext(info.getServiceReference().getBundle());
                if (servletContext == null) {
                    failureCode = 2;
                } else {
                    WhiteboardListenerHandler listenerHandler = new WhiteboardListenerHandler(handler.getContextInfo().getServiceId(), servletContext, (ListenerInfo)info, handler.getBundleContext());
                    handler.getRegistry().registerListeners(listenerHandler);
                }
            } else {
                SystemLogger.error("Unknown whiteboard service " + info.getServiceReference(), null);
            }
            if (failureCode != -1) {
                String type = info.getClass().getSimpleName().substring(0, info.getClass().getSimpleName().length() - 4);
                SystemLogger.debug("Ignoring " + type + " service " + info.getServiceReference());
                this.failureStateHandler.add(info, handler.getContextInfo().getServiceId(), failureCode);
            }
        }
        catch (Exception e) {
            this.failureStateHandler.add(info, handler.getContextInfo().getServiceId(), 0);
            SystemLogger.error("Exception while registering whiteboard service " + info.getServiceReference(), e);
        }
    }

    private void unregisterWhiteboardService(WhiteboardContextHandler handler, WhiteboardServiceInfo<?> info) {
        try {
            if (info instanceof ServletInfo) {
                handler.getRegistry().unregisterServlet((ServletInfo)info, true);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            } else if (info instanceof FilterInfo) {
                handler.getRegistry().unregisterFilter((FilterInfo)info, true);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            } else if (info instanceof ResourceInfo) {
                handler.getRegistry().unregisterServlet(((ResourceInfo)info).getServletInfo(), true);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            } else if (info instanceof ListenerInfo) {
                handler.getRegistry().unregisterListeners((ListenerInfo)info);
                handler.ungetServletContext(info.getServiceReference().getBundle());
            }
        }
        catch (Exception e) {
            SystemLogger.error("Exception while unregistering whiteboard service " + info.getServiceReference(), e);
        }
    }

    private boolean isMatchingService(AbstractInfo<?> info) {
        String target = info.getTarget();
        if (target != null) {
            try {
                Filter f = this.httpBundleContext.createFilter(target);
                return f.match(this.runtimeServiceReg.getReference());
            }
            catch (InvalidSyntaxException ise) {
                SystemLogger.error("Invalid target filter expression for " + info.getServiceReference() + " : " + target, ise);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhiteboardContextHandler getContextHandler(Long contextId) {
        Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
        synchronized (map) {
            for (List<WhiteboardContextHandler> handlerList : this.contextMap.values()) {
                WhiteboardContextHandler h = handlerList.get(0);
                if (h.getContextInfo().getServiceId() != contextId.longValue()) continue;
                return h;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryRuntime getRuntimeInfo() {
        FailedDTOHolder failedDTOHolder = new FailedDTOHolder();
        ArrayList<ServletContextDTO> contextDTOs = new ArrayList<ServletContextDTO>();
        ArrayList<WhiteboardContextHandler> contextHandlerList = new ArrayList<WhiteboardContextHandler>();
        Map<String, List<WhiteboardContextHandler>> map = this.contextMap;
        synchronized (map) {
            for (List<WhiteboardContextHandler> list : this.contextMap.values()) {
                if (list.isEmpty()) continue;
                contextHandlerList.add(list.get(0));
            }
            this.failureStateHandler.getRuntimeInfo(failedDTOHolder);
        }
        Collections.sort(contextHandlerList);
        for (WhiteboardContextHandler handler : contextHandlerList) {
            ServletContextDTO scDTO = ServletContextDTOBuilder.build(handler.getContextInfo(), handler.getSharedContext(), -1);
            if (!this.registry.getRuntimeInfo(scDTO, failedDTOHolder)) continue;
            contextDTOs.add(scDTO);
        }
        return new RegistryRuntime(failedDTOHolder, contextDTOs);
    }
}

