/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.runtime.dto.RequestInfoDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.RuntimeDTOBuilder;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;

public final class HttpServiceRuntimeImpl
implements HttpServiceRuntime {
    private volatile Hashtable<String, Object> attributes = new Hashtable();
    private final HandlerRegistry registry;
    private final WhiteboardManager contextManager;
    private volatile ServiceReference<HttpServiceRuntime> serviceReference;

    public HttpServiceRuntimeImpl(HandlerRegistry registry, WhiteboardManager contextManager) {
        this.registry = registry;
        this.contextManager = contextManager;
    }

    public RuntimeDTO getRuntimeDTO() {
        RuntimeDTOBuilder runtimeDTOBuilder = new RuntimeDTOBuilder(this.contextManager.getRuntimeInfo(), this.serviceReference);
        return runtimeDTOBuilder.build();
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        return new RequestInfoDTOBuilder(this.registry, path).build();
    }

    public synchronized void setAttribute(String name, Object value) {
        Hashtable<String, Object> newAttributes = new Hashtable<String, Object>(this.attributes);
        newAttributes.put(name, value);
        this.attributes = newAttributes;
    }

    public synchronized void setAllAttributes(Dictionary<String, Object> newAttributes) {
        Hashtable<String, Object> replacement = new Hashtable<String, Object>();
        for (String key : Collections.list(newAttributes.keys())) {
            replacement.put(key, newAttributes.get(key));
        }
        this.attributes = replacement;
    }

    public Dictionary<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setServiceReference(ServiceReference<HttpServiceRuntime> reference) {
        this.serviceReference = reference;
    }
}

