/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.options.Option;
import org.apache.felix.gogo.options.Options;
import org.apache.felix.gogo.shell.Console;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shell {
    static final String[] functions = new String[]{"gosh", "sh", "source"};
    private static final URI CWD = new File(".").toURI();
    private final URI baseURI;
    private final BundleContext context;
    private final CommandProcessor processor;

    public Shell(BundleContext context, CommandProcessor processor) {
        this.context = context;
        this.processor = processor;
        String baseDir = context.getProperty("gosh.home");
        baseDir = baseDir == null ? context.getProperty("user.dir") : baseDir;
        this.baseURI = new File(baseDir).toURI();
    }

    public Object gosh(CommandSession session, String[] argv) throws Exception {
        Object result;
        CommandSession newSession;
        String[] usage = new String[]{"gosh - execute script with arguments in a new session", "  args are available as session variables $1..$9 and $args.", "Usage: gosh [OPTIONS] [script-file [args..]]", "  -c --command             pass all remaining args to sub-shell", "     --login               login shell (same session, reads etc/gosh_profile)", "  -s --noshutdown          don't shutdown framework when script completes", "  -x --xtrace              echo commands before execution", "  -? --help                show help", "If no script-file, an interactive shell is started, type $D to exit."};
        Option opt = Options.compile(usage).setOptionsFirst(true).parse(argv);
        List<String> args = opt.args();
        boolean login = opt.isSet("login");
        if (opt.isSet("help")) {
            opt.usage();
            if (login && !opt.isSet("noshutdown")) {
                this.shutdown();
            }
            return null;
        }
        if (opt.isSet("command") && args.isEmpty()) {
            throw opt.usageError("option --command requires argument(s)");
        }
        CommandSession commandSession = newSession = login ? session : this.processor.createSession(session.getKeyboard(), session.getConsole(), System.err);
        if (opt.isSet("xtrace")) {
            newSession.put("echo", (Object)true);
        }
        if (login) {
            URI uri = this.baseURI.resolve("etc/gosh_profile");
            if (!new File(uri).exists()) {
                uri = this.getClass().getResource("/gosh_profile").toURI();
            }
            if (uri != null) {
                this.source(session, uri.toString());
            }
        }
        for (String key : Shell.getVariables(session)) {
            if (!key.matches("[.]?[A-Z].*")) continue;
            newSession.put(key, session.get(key));
        }
        if (args.isEmpty()) {
            result = this.console(newSession);
        } else {
            CharSequence program;
            if (opt.isSet("command")) {
                StringBuilder buf = new StringBuilder();
                for (String arg : args) {
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(arg);
                }
                program = buf;
            } else {
                URI script = Shell.cwd(session).resolve(args.remove(0));
                newSession.put("0", (Object)script);
                newSession.put("args", args);
                for (int i = 0; i < args.size(); ++i) {
                    newSession.put(String.valueOf(i + 1), (Object)args.get(i));
                }
                program = this.readScript(script);
            }
            result = newSession.execute(program);
        }
        if (login && !opt.isSet("noshutdown")) {
            System.out.println("gosh: stopping framework");
            this.shutdown();
        }
        return result;
    }

    public Object sh(CommandSession session, String[] argv) throws Exception {
        return this.gosh(session, argv);
    }

    private void shutdown() throws BundleException {
        this.context.getBundle(0L).stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object source(CommandSession session, String script) throws Exception {
        URI uri = Shell.cwd(session).resolve(script);
        session.put("0", (Object)uri);
        try {
            Object object = session.execute(this.readScript(uri));
            return object;
        }
        finally {
            session.put("0", null);
        }
    }

    private Object console(CommandSession session) {
        Console console = new Console(session);
        console.run();
        return null;
    }

    private CharSequence readScript(URI script) throws Exception {
        URLConnection conn = script.toURL().openConnection();
        int length = conn.getContentLength();
        if (length == -1) {
            System.err.println("eek! unknown Contentlength for: " + script);
            length = 10240;
        }
        InputStream in = conn.getInputStream();
        CharBuffer cbuf = CharBuffer.allocate(length);
        InputStreamReader reader = new InputStreamReader(in);
        ((Reader)reader).read(cbuf);
        in.close();
        cbuf.rewind();
        return cbuf;
    }

    static Set<String> getVariables(CommandSession session) {
        return (Set)session.get(".variables");
    }

    static URI cwd(CommandSession session) {
        Object cwd = session.get("_cwd");
        if (cwd instanceof URI) {
            return (URI)cwd;
        }
        if (cwd instanceof File) {
            return ((File)cwd).toURI();
        }
        return CWD;
    }
}

