/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.felix.service.command.CommandSession;

public class Console
implements Runnable {
    private final CommandSession session;
    private final InputStream in;
    private final PrintStream out;
    private boolean quit;

    public Console(CommandSession session) {
        this.session = session;
        this.in = session.getKeyboard();
        this.out = session.getConsole();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (!this.quit) {
                try {
                    CharSequence line;
                    Object prompt = this.session.get("prompt");
                    if (prompt == null) {
                        prompt = "g! ";
                    }
                    if ((line = this.getLine(prompt.toString())) == null) {
                        return;
                    }
                    Object result = this.session.execute(line);
                    this.session.put("_", result);
                    if (result == null || Boolean.FALSE.equals(this.session.get(".Gogo.format"))) continue;
                    this.out.println(this.session.format(result, 0));
                }
                catch (Throwable e) {
                    if (this.quit) continue;
                    this.session.put("exception", (Object)e);
                    Object loc = this.session.get(".location");
                    if (null == loc || !loc.toString().contains(":")) {
                        loc = "gogo";
                    }
                    this.out.println(loc + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
            return;
        }
        catch (Exception e) {
            if (this.quit) return;
            e.printStackTrace();
        }
    }

    private CharSequence getLine(String prompt) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.out.print(prompt);
        block6: while (!this.quit) {
            this.out.flush();
            int c = this.in.read();
            switch (c) {
                case -1: 
                case 4: {
                    this.quit = true;
                    continue block6;
                }
                case 13: {
                    continue block6;
                }
                case 10: {
                    if (sb.length() > 0) {
                        return sb;
                    }
                    this.out.print(prompt);
                    continue block6;
                }
                case 8: {
                    if (sb.length() <= 0) continue block6;
                    this.out.print("\b \b");
                    sb.deleteCharAt(sb.length() - 1);
                    continue block6;
                }
            }
            sb.append((char)c);
        }
        return null;
    }

    public void close() {
        this.quit = true;
    }
}

