/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.jline.ParsedLineImpl;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Token;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;

public class Parser
implements org.jline.reader.Parser {
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        try {
            return this.doParse(line, cursor);
        }
        catch (org.apache.felix.gogo.runtime.EOFError e) {
            throw new EOFError(e.line(), e.column(), e.getMessage(), e.missing());
        }
        catch (org.apache.felix.gogo.runtime.SyntaxError e) {
            throw new SyntaxError(e.line(), e.column(), e.getMessage());
        }
    }

    private ParsedLine doParse(CharSequence line, int cursor) throws org.apache.felix.gogo.runtime.SyntaxError {
        org.apache.felix.gogo.runtime.Parser parser = new org.apache.felix.gogo.runtime.Parser(line);
        Parser.Program program = parser.program();
        List statements = parser.statements();
        Parser.Statement statement = null;
        for (int i = statements.size() - 1; i >= 0; --i) {
            Parser.Statement s = (Parser.Statement)statements.get(i);
            if (s.start() > cursor) continue;
            boolean isOk = true;
            if (s.start() + s.length() < cursor) {
                for (int j = s.start() + s.length(); isOk && j < cursor; ++j) {
                    isOk = Character.isWhitespace(line.charAt(j));
                }
            }
            statement = s;
            break;
        }
        if (statement != null) {
            return new ParsedLineImpl(program, (Token)statement, cursor, statement.tokens());
        }
        return new ParsedLineImpl(program, (Token)program, cursor, Collections.singletonList(program));
    }
}

