/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.dm.BundleDependency;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.impl.AdapterServiceImpl;
import org.apache.felix.dm.impl.AspectServiceImpl;
import org.apache.felix.dm.impl.BundleAdapterImpl;
import org.apache.felix.dm.impl.BundleDependencyImpl;
import org.apache.felix.dm.impl.ComponentImpl;
import org.apache.felix.dm.impl.ComponentScheduler;
import org.apache.felix.dm.impl.ConfigurationDependencyImpl;
import org.apache.felix.dm.impl.FactoryConfigurationAdapterImpl;
import org.apache.felix.dm.impl.ResourceAdapterImpl;
import org.apache.felix.dm.impl.ResourceDependencyImpl;
import org.apache.felix.dm.impl.ServiceDependencyImpl;
import org.apache.felix.dm.impl.TemporalServiceDependencyImpl;
import org.apache.felix.dm.impl.index.AdapterFilterIndex;
import org.apache.felix.dm.impl.index.AspectFilterIndex;
import org.apache.felix.dm.impl.index.ServiceRegistryCache;
import org.apache.felix.dm.impl.index.multiproperty.MultiPropertyFilterIndex;
import org.apache.felix.dm.impl.metatype.PropertyMetaDataImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class DependencyManager {
    public static final String PARALLEL = "org.apache.felix.dependencymanager.parallel";
    public static final String ASPECT = "org.apache.felix.dependencymanager.aspect";
    public static final String SERVICEREGISTRY_CACHE_INDICES = "org.apache.felix.dependencymanager.filterindex";
    public static final String METHOD_CACHE_SIZE = "org.apache.felix.dependencymanager.methodcache";
    private final BundleContext m_context;
    private final Logger m_logger;
    private final ConcurrentHashMap<Component, Component> m_components = new ConcurrentHashMap();
    private static ServiceRegistryCache m_serviceRegistryCache;
    private static final Set<WeakReference<DependencyManager>> m_dependencyManagers;

    static {
        m_dependencyManagers = new HashSet<WeakReference<DependencyManager>>();
        try {
            Bundle bundle = FrameworkUtil.getBundle(DependencyManager.class);
            if (bundle != null) {
                BundleContext bundleContext;
                String index;
                if (bundle.getState() != 32) {
                    bundle.start();
                }
                if ((index = (bundleContext = bundle.getBundleContext()).getProperty(SERVICEREGISTRY_CACHE_INDICES)) != null) {
                    m_serviceRegistryCache = new ServiceRegistryCache(bundleContext);
                    m_serviceRegistryCache.open();
                    String[] props = index.split(";");
                    int i = 0;
                    while (i < props.length) {
                        if (props[i].equals("*aspect*")) {
                            m_serviceRegistryCache.addFilterIndex(new AspectFilterIndex());
                        } else if (props[i].equals("*adapter*")) {
                            m_serviceRegistryCache.addFilterIndex(new AdapterFilterIndex());
                        } else {
                            m_serviceRegistryCache.addFilterIndex(new MultiPropertyFilterIndex(props[i]));
                        }
                        ++i;
                    }
                }
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
    }

    public DependencyManager(BundleContext context) {
        this(context, new Logger(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DependencyManager(BundleContext context, Logger logger) {
        this.m_context = this.createContext(context);
        this.m_logger = logger;
        Set<WeakReference<DependencyManager>> set = m_dependencyManagers;
        synchronized (set) {
            m_dependencyManagers.add(new WeakReference<DependencyManager>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DependencyManager> getDependencyManagers() {
        ArrayList<DependencyManager> result = new ArrayList<DependencyManager>();
        Set<WeakReference<DependencyManager>> set = m_dependencyManagers;
        synchronized (set) {
            Iterator<WeakReference<DependencyManager>> iterator = m_dependencyManagers.iterator();
            while (iterator.hasNext()) {
                WeakReference<DependencyManager> reference = iterator.next();
                DependencyManager manager = (DependencyManager)reference.get();
                if (manager != null) {
                    try {
                        manager.getBundleContext().getBundle();
                        result.add(manager);
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                iterator.remove();
            }
        }
        return result;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public void add(Component c) {
        this.m_components.put(c, c);
        ComponentScheduler.instance().add(c);
    }

    public void remove(Component c) {
        ComponentScheduler.instance().remove(c);
        this.m_components.remove(c);
    }

    public Component createComponent() {
        return new ComponentImpl(this.m_context, this, this.m_logger);
    }

    public ServiceDependency createServiceDependency() {
        return new ServiceDependencyImpl();
    }

    public ConfigurationDependency createConfigurationDependency() {
        return new ConfigurationDependencyImpl(this.m_context, this.m_logger);
    }

    public BundleDependency createBundleDependency() {
        return new BundleDependencyImpl();
    }

    public ResourceDependency createResourceDependency() {
        return new ResourceDependencyImpl();
    }

    public ServiceDependency createTemporalServiceDependency(long timeout) {
        return new TemporalServiceDependencyImpl(this.m_context, timeout);
    }

    public Component createAdapterService(Class<?> serviceInterface, String serviceFilter) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, null, null, null, null, null, null, true);
    }

    public Component createAdapterService(Class<?> serviceInterface, String serviceFilter, String autoConfig) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, autoConfig, null, null, null, null, null, true);
    }

    public Component createAdapterService(Class<?> serviceInterface, String serviceFilter, String add, String change, String remove) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, null, null, add, change, remove, null, true);
    }

    public Component createAdapterService(Class<?> serviceInterface, String serviceFilter, String add, String change, String remove, String swap) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, null, null, add, change, remove, swap, true);
    }

    public Component createAdapterService(Class<?> serviceInterface, String serviceFilter, String autoConfig, Object callbackInstance, String add, String change, String remove, String swap, boolean propagate) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, autoConfig, callbackInstance, add, change, remove, swap, propagate);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate) {
        return new FactoryConfigurationAdapterImpl(this, factoryPid, update, propagate, null, null);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate, Object callbackInstance) {
        return new FactoryConfigurationAdapterImpl(this, factoryPid, update, propagate, callbackInstance, null);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate, Class<?> configType) {
        return new FactoryConfigurationAdapterImpl(this, factoryPid, update, propagate, null, configType);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate, Object callbackInstance, Class<?> configType) {
        return new FactoryConfigurationAdapterImpl(this, factoryPid, update, propagate, callbackInstance, configType);
    }

    public Component createAdapterFactoryConfigurationService(String factoryPid, String update, boolean propagate, String heading, String desc, String localization, PropertyMetaData[] propertiesMetaData) {
        return new FactoryConfigurationAdapterImpl(this, factoryPid, update, propagate, null, this.m_context, this.m_logger, heading, desc, localization, propertiesMetaData);
    }

    public Component createBundleAdapterService(int bundleStateMask, String bundleFilter, boolean propagate) {
        return new BundleAdapterImpl(this, bundleStateMask, bundleFilter, propagate);
    }

    public Component createBundleAdapterService(int bundleStateMask, String bundleFilter, boolean propagate, Object callbackInstance, String add, String change, String remove) {
        return new BundleAdapterImpl(this, bundleStateMask, bundleFilter, propagate, callbackInstance, add, change, remove);
    }

    public Component createResourceAdapterService(String resourceFilter, boolean propagate, Object callbackInstance, String callbackChanged) {
        return new ResourceAdapterImpl(this, resourceFilter, propagate, callbackInstance, null, callbackChanged);
    }

    public Component createResourceAdapterService(String resourceFilter, boolean propagate, Object callbackInstance, String callbackSet, String callbackChanged) {
        return new ResourceAdapterImpl(this, resourceFilter, propagate, callbackInstance, callbackSet, callbackChanged);
    }

    public Component createResourceAdapterService(String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackChanged) {
        return new ResourceAdapterImpl(this, resourceFilter, propagateCallbackInstance, propagateCallbackMethod, callbackInstance, null, callbackChanged);
    }

    public Component createResourceAdapterService(String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackSet, String callbackChanged) {
        return new ResourceAdapterImpl(this, resourceFilter, propagateCallbackInstance, propagateCallbackMethod, callbackInstance, callbackSet, callbackChanged);
    }

    public List<Component> getComponents() {
        return Collections.list(this.m_components.elements());
    }

    public Component createAspectService(Class<?> serviceInterface, String serviceFilter, int ranking, String autoConfig) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, autoConfig, null, null, null, null, null);
    }

    public Component createAspectService(Class<?> serviceInterface, String serviceFilter, int ranking) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, null, null, null, null, null, null);
    }

    public Component createAspectService(Class<?> serviceInterface, String serviceFilter, int ranking, String add, String change, String remove) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, null, null, add, change, remove, null);
    }

    public Component createAspectService(Class<?> serviceInterface, String serviceFilter, int ranking, String add, String change, String remove, String swap) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, null, null, add, change, remove, swap);
    }

    public Component createAspectService(Class<?> serviceInterface, String serviceFilter, int ranking, Object callbackInstance, String add, String change, String remove, String swap) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, null, callbackInstance, add, change, remove, swap);
    }

    public void clear() {
        for (Component component : this.m_components.keySet()) {
            this.remove(component);
        }
        this.m_components.clear();
    }

    public PropertyMetaData createPropertyMetaData() {
        return new PropertyMetaDataImpl();
    }

    private BundleContext createContext(BundleContext context) {
        if (m_serviceRegistryCache != null) {
            return m_serviceRegistryCache.createBundleContextInterceptor(context);
        }
        return context;
    }
}

