/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index.multiproperty;

import java.util.Set;
import java.util.TreeSet;

public class Property {
    boolean m_negate;
    boolean m_valid = true;
    String m_key;
    String m_value;
    Set<String> m_values = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    public Property() {
    }

    public Property(boolean negate, String key, String value) {
        this.m_negate = negate;
        this.m_key = key.toLowerCase();
        this.m_values.add(value);
        this.m_value = value;
    }

    public void setNegate(boolean negate) {
        this.m_negate = negate;
    }

    public void setKey(String key) {
        this.m_key = key.toLowerCase();
    }

    public void addValue(String value, boolean negate) {
        if (this.m_negate != negate) {
            this.m_valid = false;
        }
        if (this.m_value == null) {
            this.m_value = value;
        }
        if (value != null) {
            this.m_values.add(value);
        }
    }

    public boolean isNegate() {
        return this.m_negate;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getValue() {
        return this.m_value;
    }

    public Set<String> getValues() {
        return this.m_values;
    }

    public boolean isWildcard() {
        return "*".equals(this.m_value);
    }

    public boolean isMultiValue() {
        return this.m_values.size() > 1;
    }

    public String toString() {
        return "Property [negate=" + this.m_negate + ", key=" + this.m_key + ", values=" + this.m_values + "]";
    }

    public boolean isValid() {
        return this.m_valid;
    }
}

