/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.Dictionary;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.impl.ServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ServiceEventImpl
extends Event {
    private final ServiceReference m_reference;
    private final BundleContext m_bundleContext;
    private final Bundle m_bundle;

    public ServiceEventImpl(ServiceReference reference, Object service) {
        this(null, null, reference, service);
    }

    public ServiceEventImpl(Bundle bundle, BundleContext bundleContext, ServiceReference reference, Object service) {
        super(service);
        this.m_bundle = bundle;
        this.m_bundleContext = bundleContext;
        this.m_reference = reference;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public BundleContext getBundleContext() {
        return this.m_bundleContext;
    }

    public ServiceReference getReference() {
        return this.m_reference;
    }

    public Dictionary<String, Object> getProperties() {
        return ServiceUtil.propertiesToDictionary(this.m_reference);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ServiceEventImpl) {
            return this.getReference().equals(((ServiceEventImpl)obj).getReference());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getReference().hashCode();
    }

    @Override
    public int compareTo(Event b) {
        return this.getReference().compareTo((Object)((ServiceEventImpl)b).getReference());
    }

    public String toString() {
        return this.getEvent().toString();
    }

    @Override
    public void close() {
        if (this.m_bundleContext != null) {
            try {
                if (this.m_bundle == null || this.m_bundle.getState() == 32) {
                    this.m_bundleContext.ungetService(this.m_reference);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

