/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.ResourceHandler;
import org.apache.felix.dm.context.AbstractDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.impl.ResourceEventImpl;
import org.osgi.framework.ServiceRegistration;

public class ResourceDependencyImpl
extends AbstractDependency<ResourceDependency>
implements ResourceDependency,
ResourceHandler,
ComponentDependencyDeclaration {
    private volatile ServiceRegistration m_registration;
    private volatile String m_resourceFilter;
    private volatile URL m_trackedResource;

    public ResourceDependencyImpl() {
    }

    public ResourceDependencyImpl(ResourceDependencyImpl prototype) {
        super(prototype);
        this.m_resourceFilter = prototype.m_resourceFilter;
        this.m_trackedResource = prototype.m_trackedResource;
    }

    @Override
    public DependencyContext createCopy() {
        return new ResourceDependencyImpl(this);
    }

    @Override
    public void start() {
        Hashtable<String, Object> props = null;
        if (this.m_trackedResource != null) {
            props = new Hashtable<String, Object>();
            ((Dictionary)props).put("url", this.m_trackedResource);
        } else if (this.m_resourceFilter != null) {
            props = new Hashtable();
            ((Dictionary)props).put("filter", this.m_resourceFilter);
        }
        this.m_registration = this.m_component.getBundleContext().registerService(ResourceHandler.class.getName(), (Object)this, props);
        super.start();
    }

    @Override
    public void stop() {
        this.m_registration.unregister();
        this.m_registration = null;
        super.stop();
    }

    @Override
    public void added(URL resource) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            this.getComponentContext().handleEvent(this, EventType.ADDED, new ResourceEventImpl(resource, null));
        }
    }

    @Override
    public void added(URL resource, Dictionary<?, ?> resourceProperties) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            this.getComponentContext().handleEvent(this, EventType.ADDED, new ResourceEventImpl(resource, resourceProperties));
        }
    }

    @Override
    public void changed(URL resource) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            this.m_component.handleEvent(this, EventType.CHANGED, new ResourceEventImpl(resource, null));
        }
    }

    @Override
    public void changed(URL resource, Dictionary<?, ?> resourceProperties) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            this.m_component.handleEvent(this, EventType.CHANGED, new ResourceEventImpl(resource, resourceProperties));
        }
    }

    @Override
    public void removed(URL resource) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            this.m_component.handleEvent(this, EventType.REMOVED, new ResourceEventImpl(resource, null));
        }
    }

    @Override
    public void removed(URL resource, Dictionary<?, ?> resourceProperties) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            this.m_component.handleEvent(this, EventType.REMOVED, new ResourceEventImpl(resource, resourceProperties));
        }
    }

    @Override
    public void invokeCallback(EventType type, Event ... e) {
        switch (type) {
            case ADDED: {
                if (this.m_add == null) break;
                this.invoke(this.m_add, e[0]);
                break;
            }
            case CHANGED: {
                if (this.m_change == null) break;
                this.invoke(this.m_change, e[0]);
                break;
            }
            case REMOVED: {
                if (this.m_remove == null) break;
                this.invoke(this.m_remove, e[0]);
                break;
            }
        }
    }

    private void invoke(String method, Event e) {
        ResourceEventImpl re = (ResourceEventImpl)e;
        URL serviceInstance = re.getResource();
        Dictionary resourceProperties = re.getProperties();
        this.m_component.invokeCallbackMethod(this.getInstances(), method, new Class[][]{{Component.class, URL.class, Dictionary.class}, {Component.class, URL.class}, {Component.class}, {URL.class, Dictionary.class}, {URL.class}, {Object.class}, new Class[0]}, new Object[][]{{this.m_component, serviceInstance, resourceProperties}, {this.m_component, serviceInstance}, {this.m_component}, {serviceInstance, resourceProperties}, {serviceInstance}, {serviceInstance}, new Object[0]});
    }

    @Override
    public ResourceDependency setResource(URL resource) {
        this.m_trackedResource = resource;
        return this;
    }

    @Override
    public ResourceDependency setFilter(String resourceFilter) {
        this.ensureNotActive();
        this.m_resourceFilter = resourceFilter;
        return this;
    }

    public ResourceDependency setFilter(String resourceFilter, String resourcePropertiesFilter) {
        this.ensureNotActive();
        this.m_resourceFilter = resourceFilter;
        return this;
    }

    @Override
    public Class<?> getAutoConfigType() {
        return URL.class;
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        ResourceEventImpl re = (ResourceEventImpl)this.m_component.getDependencyEvent(this);
        if (re != null) {
            URL resource = re.getResource();
            Dictionary resourceProperties = re.getProperties();
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, new Class[][]{{URL.class}}, new Object[][]{{resource}});
                }
                catch (InvocationTargetException e) {
                    this.m_component.getLogger().warn("Exception while invoking callback method", e.getCause(), new Object[0]);
                }
                catch (Throwable e) {
                    this.m_component.getLogger().warn("Exception while trying to invoke callback method", e, new Object[0]);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("host", resource.getHost());
            props.put("path", resource.getPath());
            props.put("protocol", resource.getProtocol());
            props.put("port", Integer.toString(resource.getPort()));
            if (resourceProperties != null) {
                Enumeration properyKeysEnum = resourceProperties.keys();
                while (properyKeysEnum.hasMoreElements()) {
                    String key = (String)properyKeysEnum.nextElement();
                    if (!(key.equals("host") || key.equals("path") || key.equals("protocol") || key.equals("port"))) {
                        props.put(key, resourceProperties.get(key).toString());
                        continue;
                    }
                    this.m_component.getLogger().warn("Custom resource property is overlapping with the default resource property for key: %s", key);
                }
            }
            return props;
        }
        throw new IllegalStateException("cannot find resource");
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.m_trackedResource != null) {
            sb.append(this.m_trackedResource.toString());
        }
        if (this.m_resourceFilter != null) {
            sb.append(this.m_resourceFilter);
        }
        return sb.toString();
    }

    @Override
    public String getSimpleName() {
        return this.m_trackedResource != null ? this.m_trackedResource.toString() : null;
    }

    @Override
    public String getFilter() {
        return this.m_resourceFilter;
    }

    @Override
    public String getType() {
        return "resource";
    }
}

