/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index.multiproperty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.impl.index.multiproperty.Filter;
import org.apache.felix.dm.impl.index.multiproperty.Property;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MultiPropertyFilterIndex
implements FilterIndex,
ServiceTrackerCustomizer {
    private final Object m_lock = new Object();
    private ServiceTracker m_tracker;
    private BundleContext m_context;
    private Map<String, Property> m_configProperties = new LinkedHashMap<String, Property>();
    private List<String> m_negatePropertyKeys = new ArrayList<String>();
    private final Map<String, List<ServiceReference>> m_keyToServiceReferencesMap = new HashMap<String, List<ServiceReference>>();
    private final Map<String, List<ServiceListener>> m_keyToListenersMap = new HashMap<String, List<ServiceListener>>();
    private final Map<ServiceListener, String> m_listenerToFilterMap = new HashMap<ServiceListener, String>();

    public MultiPropertyFilterIndex(String configString) {
        this.parseConfig(configString);
    }

    @Override
    public boolean isApplicable(String clazz, String filterString) {
        Filter filter = this.createFilter(clazz, filterString);
        if (!filter.isValid()) {
            return false;
        }
        Set<String> filterPropertyKeys = filter.getPropertyKeys();
        if (this.m_configProperties.size() != filterPropertyKeys.size()) {
            return false;
        }
        for (String filterPropertyKey : filterPropertyKeys) {
            if (!this.m_configProperties.containsKey(filterPropertyKey)) {
                return false;
            }
            if (this.m_configProperties.get(filterPropertyKey).isNegate() != filter.getProperty(filterPropertyKey).isNegate()) {
                return false;
            }
            if (filter.getProperty(filterPropertyKey).isNegate() || !filter.getProperty(filterPropertyKey).getValue().equals("*")) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicable(ServiceReference ref) {
        String[] propertyKeys = ref.getPropertyKeys();
        TreeSet<String> referenceProperties = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < propertyKeys.length; ++i) {
            referenceProperties.add(propertyKeys[i]);
        }
        for (String item : this.m_configProperties.keySet()) {
            Property configProperty = this.m_configProperties.get(item);
            if (!configProperty.isNegate() && !referenceProperties.contains(item)) {
                return false;
            }
            if (!configProperty.isNegate() || !referenceProperties.contains(item)) continue;
            return false;
        }
        return true;
    }

    private void parseConfig(String configString) {
        String[] propertyConfigs = configString.split(",");
        for (int i = 0; i < propertyConfigs.length; ++i) {
            String key;
            String propertyConfig = propertyConfigs[i];
            Property property = new Property();
            String value = null;
            if (propertyConfig.startsWith("!")) {
                property.setNegate(true);
                key = propertyConfig.substring(1);
            } else {
                key = propertyConfig;
            }
            if (key.endsWith("*")) {
                key = key.substring(0, key.indexOf("*"));
                value = "*";
            }
            property.setKey(key.toLowerCase());
            property.addValue(value, property.isNegate());
            this.m_configProperties.put(key.toLowerCase(), property);
            if (!property.isNegate()) continue;
            this.m_negatePropertyKeys.add(key);
        }
    }

    protected Collection<Property> getProperties() {
        return this.m_configProperties.values();
    }

    protected String createKeyFromFilter(String clazz, String filterString) {
        return this.createFilter(clazz, filterString).createKey();
    }

    private Filter createFilter(String clazz, String filterString) {
        String filterStringWithObjectClass = filterString;
        if (clazz != null) {
            if (filterString != null) {
                if (!filterStringWithObjectClass.startsWith("(&(objectClass=")) {
                    filterStringWithObjectClass = "(&(objectClass=" + clazz + ")" + filterString + ")";
                }
            } else {
                filterStringWithObjectClass = "(objectClass=" + clazz + ")";
            }
        }
        Filter filter = Filter.parse(filterStringWithObjectClass);
        return filter;
    }

    protected List<String> createKeys(ServiceReference reference) {
        ArrayList<String> results = new ArrayList<String>();
        ArrayList sets = new ArrayList();
        String[] keys = reference.getPropertyKeys();
        Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < keys.length; ++i) {
            ArrayList<String> set = new ArrayList<String>();
            String key = keys[i].toLowerCase();
            if (!this.m_configProperties.containsKey(key)) continue;
            Object valueObject = reference.getProperty(key);
            if (valueObject instanceof String[]) {
                set.addAll(this.getPermutations(key, (String[])valueObject));
            } else {
                set.add(this.toKey(key, valueObject));
            }
            sets.add(set);
        }
        ArrayList<List<String>> reversedSets = new ArrayList<List<String>>();
        int size = sets.size();
        for (int i = size - 1; i > -1; --i) {
            reversedSets.add((List<String>)sets.get(i));
        }
        List<List<String>> products = this.carthesianProduct(0, reversedSets);
        for (int i = 0; i < products.size(); ++i) {
            List<String> set = products.get(i);
            StringBuilder b = new StringBuilder();
            for (int j = 0; j < set.size(); ++j) {
                String item = set.get(j);
                b.append(item);
                if (j >= set.size() - 1) continue;
                b.append(";");
            }
            results.add(b.toString());
        }
        return results;
    }

    private List<List<String>> carthesianProduct(int index, List<List<String>> sets) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (index == sets.size()) {
            result.add(new ArrayList());
        } else {
            List<String> set = sets.get(index);
            for (int i = 0; i < set.size(); ++i) {
                String object = set.get(i);
                List<List<String>> pSets = this.carthesianProduct(index + 1, sets);
                for (int j = 0; j < pSets.size(); ++j) {
                    List<String> pSet = pSets.get(j);
                    pSet.add(object);
                    result.add(pSet);
                }
            }
        }
        return result;
    }

    List<String> getPermutations(String key, String[] values) {
        ArrayList<String> results = new ArrayList<String>();
        Arrays.sort(values, String.CASE_INSENSITIVE_ORDER);
        for (int v = 0; v < values.length; ++v) {
            String processValue = values[v];
            ArrayList<String> items = new ArrayList<String>();
            items.add(processValue);
            ArrayList<String> subItems = new ArrayList<String>(items);
            for (int w = v; w < values.length; ++w) {
                subItems = new ArrayList(subItems);
                if (w != v) {
                    String value = values[w];
                    subItems.add(value);
                }
                results.add(this.toKey(key, subItems));
            }
        }
        return results;
    }

    protected String toKey(String key, List<String> values) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            builder.append(this.toKey(key, values.get(i)));
            if (i >= values.size() - 1) continue;
            builder.append(";");
        }
        return builder.toString();
    }

    protected String toKey(String key, Object value) {
        StringBuilder builder = new StringBuilder();
        builder.append(key);
        builder.append("=");
        builder.append(value.toString());
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addingService(ServiceReference reference) {
        BundleContext context;
        Object object = this.m_lock;
        synchronized (object) {
            context = this.m_context;
        }
        if (context != null) {
            return context.getService(reference);
        }
        throw new IllegalStateException("No valid bundle context.");
    }

    @Override
    public void addedService(ServiceReference reference, Object service) {
        if (this.isApplicable(reference) && this.shouldBeIndexed(reference)) {
            this.handleServiceAdd(reference);
        }
    }

    @Override
    public void modifiedService(ServiceReference reference, Object service) {
        if (this.isApplicable(reference)) {
            this.handleServicePropertiesChange(reference);
        }
    }

    @Override
    public void removedService(ServiceReference reference, Object service) {
        if (this.isApplicable(reference) && this.shouldBeIndexed(reference)) {
            this.handleServiceRemove(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServiceAdd(ServiceReference reference) {
        List<String> keys = this.createKeys(reference);
        Map<String, List<ServiceReference>> map = this.m_keyToServiceReferencesMap;
        synchronized (map) {
            for (int i = 0; i < keys.size(); ++i) {
                List<ServiceReference> references = this.m_keyToServiceReferencesMap.get(keys.get(i));
                if (references == null) {
                    references = new ArrayList<ServiceReference>();
                    this.m_keyToServiceReferencesMap.put(keys.get(i), references);
                }
                references.add(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServicePropertiesChange(ServiceReference reference) {
        Map<String, List<ServiceReference>> map = this.m_keyToServiceReferencesMap;
        synchronized (map) {
            for (List<ServiceReference> list : this.m_keyToServiceReferencesMap.values()) {
                if (list == null) continue;
                Iterator<ServiceReference> i2 = list.iterator();
                while (i2.hasNext()) {
                    ServiceReference ref = i2.next();
                    if (!ref.equals(reference)) continue;
                    i2.remove();
                }
            }
            if (this.shouldBeIndexed(reference)) {
                List<String> keys = this.createKeys(reference);
                for (int i = 0; i < keys.size(); ++i) {
                    List<ServiceReference> references = this.m_keyToServiceReferencesMap.get(keys.get(i));
                    if (references == null) {
                        references = new ArrayList<ServiceReference>();
                        this.m_keyToServiceReferencesMap.put(keys.get(i), references);
                    }
                    references.add(reference);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServiceRemove(ServiceReference reference) {
        List<String> keys = this.createKeys(reference);
        Map<String, List<ServiceReference>> map = this.m_keyToServiceReferencesMap;
        synchronized (map) {
            for (int i = 0; i < keys.size(); ++i) {
                List<ServiceReference> references = this.m_keyToServiceReferencesMap.get(keys.get(i));
                if (references == null) continue;
                references.remove(reference);
                if (!references.isEmpty()) continue;
                this.m_keyToServiceReferencesMap.remove(keys.get(i));
            }
        }
    }

    protected boolean shouldBeIndexed(ServiceReference reference) {
        for (String negatePropertyKey : this.m_negatePropertyKeys) {
            if (reference.getProperty(negatePropertyKey) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(BundleContext context) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context != null) {
                throw new IllegalStateException("Filter already open.");
            }
            try {
                this.m_tracker = new ServiceTracker(context, context.createFilter("(objectClass=*)"), (ServiceTrackerCustomizer)this);
            }
            catch (InvalidSyntaxException e) {
                throw new Error();
            }
            this.m_context = context;
        }
        this.m_tracker.open(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ServiceTracker tracker;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context == null) {
                throw new IllegalStateException("Filter already closed.");
            }
            tracker = this.m_tracker;
            this.m_tracker = null;
            this.m_context = null;
        }
        tracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceReference> getAllServiceReferences(String clazz, String filter) {
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        String key = this.createKeyFromFilter(clazz, filter);
        Map<String, List<ServiceReference>> map = this.m_keyToServiceReferencesMap;
        synchronized (map) {
            List<ServiceReference> references = this.m_keyToServiceReferencesMap.get(key);
            if (references != null) {
                result.addAll(references);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceChanged(ServiceEvent event) {
        if (this.isApplicable(event.getServiceReference())) {
            List<String> keys = this.createKeys(event.getServiceReference());
            ArrayList<ServiceListener> list = new ArrayList<ServiceListener>();
            Map<String, List<ServiceListener>> map = this.m_keyToListenersMap;
            synchronized (map) {
                for (int i = 0; i < keys.size(); ++i) {
                    String key = keys.get(i);
                    List<ServiceListener> listeners = this.m_keyToListenersMap.get(key);
                    if (listeners == null) continue;
                    list.addAll(listeners);
                }
            }
            if (list != null) {
                for (ServiceListener listener : list) {
                    listener.serviceChanged(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(ServiceListener listener, String filter) {
        String key = this.createKeyFromFilter(null, filter);
        Map<String, List<ServiceListener>> map = this.m_keyToListenersMap;
        synchronized (map) {
            List<ServiceListener> listeners = this.m_keyToListenersMap.get(key);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<ServiceListener>();
                this.m_keyToListenersMap.put(key, listeners);
            }
            listeners.add(listener);
            this.m_listenerToFilterMap.put(listener, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(ServiceListener listener) {
        Map<String, List<ServiceListener>> map = this.m_keyToListenersMap;
        synchronized (map) {
            String filter = this.m_listenerToFilterMap.remove(listener);
            if (filter != null) {
                List<ServiceListener> listeners;
                boolean result;
                String key = this.createKeyFromFilter(null, filter);
                boolean bl = result = filter != null;
                if (result && (listeners = this.m_keyToListenersMap.get(key)) != null) {
                    listeners.remove(listener);
                    if (listeners.isEmpty()) {
                        this.m_keyToListenersMap.remove(key);
                    }
                }
            }
        }
    }

    protected Collection<ServiceListener> getServiceListeners() {
        return this.m_listenerToFilterMap.keySet();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" dMultiPropertyExactFilter[");
        sb.append("K2L: " + this.m_keyToListenersMap.size());
        sb.append(", K2SR: " + this.m_keyToServiceReferencesMap.size());
        sb.append(", L2F: " + this.m_listenerToFilterMap.size());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void swappedService(ServiceReference reference, Object service, ServiceReference newReference, Object newService) {
        this.addedService(newReference, newService);
        this.removedService(reference, service);
    }
}

