/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivation;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.InvocationUtil;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.ResourceHandler;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.dependencies.DependencyBase;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ResourceDependencyImpl
extends DependencyBase
implements ResourceDependency,
ResourceHandler,
DependencyActivation,
ComponentDependencyDeclaration {
    private volatile BundleContext m_context;
    private volatile ServiceRegistration m_registration;
    private Object m_callbackInstance;
    private String m_callbackAdded;
    private String m_callbackChanged;
    private String m_callbackRemoved;
    private boolean m_autoConfig;
    private String m_autoConfigInstance;
    protected List m_services = new ArrayList();
    private String m_resourceFilter;
    private URL m_trackedResource;
    private List m_resources = new ArrayList();
    private List m_resourceProperties = new ArrayList();
    private URL m_resourceInstance;
    private Dictionary m_resourcePropertiesInstance;
    private boolean m_propagate;
    private Object m_propagateCallbackInstance;
    private String m_propagateCallbackMethod;
    static /* synthetic */ Class class$org$apache$felix$dm$ResourceHandler;
    static /* synthetic */ Class class$org$apache$felix$dm$Component;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Dictionary;
    static /* synthetic */ Class class$java$lang$Object;

    public ResourceDependencyImpl(BundleContext context, Logger logger) {
        super(logger);
        this.m_context = context;
        this.m_autoConfig = true;
    }

    public ResourceDependencyImpl(ResourceDependencyImpl prototype) {
        super(prototype);
        this.m_context = prototype.m_context;
        this.m_autoConfig = prototype.m_autoConfig;
        this.m_callbackInstance = prototype.m_callbackInstance;
        this.m_callbackAdded = prototype.m_callbackAdded;
        this.m_callbackChanged = prototype.m_callbackChanged;
        this.m_callbackRemoved = prototype.m_callbackRemoved;
        this.m_autoConfigInstance = prototype.m_autoConfigInstance;
        this.m_resourceFilter = prototype.m_resourceFilter;
        this.m_trackedResource = prototype.m_trackedResource;
        this.m_propagate = prototype.m_propagate;
    }

    public Dependency createCopy() {
        return new ResourceDependencyImpl(this);
    }

    public synchronized boolean isAvailable() {
        return this.m_resources.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DependencyService service) {
        boolean needsStarting = false;
        ResourceDependencyImpl resourceDependencyImpl = this;
        synchronized (resourceDependencyImpl) {
            this.m_services.add(service);
            if (!this.m_isStarted) {
                this.m_isStarted = true;
                needsStarting = true;
            }
        }
        if (needsStarting) {
            Properties props = null;
            if (this.m_trackedResource != null) {
                props = new Properties();
                ((Dictionary)props).put("url", this.m_trackedResource);
            } else if (this.m_resourceFilter != null) {
                props = new Properties();
                ((Dictionary)props).put("filter", this.m_resourceFilter);
            }
            this.m_registration = this.m_context.registerService((class$org$apache$felix$dm$ResourceHandler == null ? (class$org$apache$felix$dm$ResourceHandler = ResourceDependencyImpl.class$("org.apache.felix.dm.ResourceHandler")) : class$org$apache$felix$dm$ResourceHandler).getName(), (Object)this, (Dictionary)props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DependencyService service) {
        boolean needsStopping = false;
        ResourceDependencyImpl resourceDependencyImpl = this;
        synchronized (resourceDependencyImpl) {
            if (this.m_services.size() == 1 && this.m_services.contains(service)) {
                this.m_isStarted = false;
                needsStopping = true;
                this.m_services.remove(service);
            }
        }
        if (needsStopping) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    public void added(URL resource) {
        this.handleResourceAdded(resource, null);
    }

    public void added(URL resource, Dictionary resourceProperties) {
        this.handleResourceAdded(resource, resourceProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceAdded(URL resource, Dictionary resourceProperties) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            Object[] services;
            long counter;
            ResourceDependencyImpl resourceDependencyImpl = this;
            synchronized (resourceDependencyImpl) {
                this.m_resources.add(resource);
                this.m_resourceProperties.add(resourceProperties);
                counter = this.m_resources.size();
                services = this.m_services.toArray();
            }
            for (int i = 0; i < services.length; ++i) {
                DependencyService ds = (DependencyService)services[i];
                if (counter == 1L) {
                    ds.dependencyAvailable(this);
                    if (this.isRequired()) continue;
                    this.invokeAdded(ds, resource, resourceProperties);
                    continue;
                }
                ds.dependencyChanged(this);
                this.invokeAdded(ds, resource, resourceProperties);
            }
        }
    }

    public void changed(URL resource) {
        this.handleResourceChanged(resource, null);
    }

    public void changed(URL resource, Dictionary resourceProperties) {
        this.handleResourceChanged(resource, resourceProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceChanged(URL resource, Dictionary resourceProperties) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            Object[] services;
            ResourceDependencyImpl resourceDependencyImpl = this;
            synchronized (resourceDependencyImpl) {
                this.m_resourceProperties.set(this.m_resources.indexOf(resource), resourceProperties);
                services = this.m_services.toArray();
            }
            for (int i = 0; i < services.length; ++i) {
                DependencyService ds = (DependencyService)services[i];
                this.invokeChanged(ds, resource, resourceProperties);
            }
        }
    }

    public void removed(URL resource) {
        this.handleResourceRemoved(resource, null);
    }

    public void removed(URL resource, Dictionary resourceProperties) {
        this.handleResourceRemoved(resource, resourceProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRemoved(URL resource, Dictionary resourceProperties) {
        if (this.m_trackedResource == null || this.m_trackedResource.equals(resource)) {
            Object[] services;
            long counter;
            ResourceDependencyImpl resourceDependencyImpl = this;
            synchronized (resourceDependencyImpl) {
                if (this.m_resources.indexOf(resource) == -1) {
                    this.m_logger.log(2, "handleResourceRemoved called for unknown resource: " + resource);
                    return;
                }
                this.m_resourceProperties.remove(this.m_resources.indexOf(resource));
                this.m_resources.remove(resource);
                counter = this.m_resources.size();
                services = this.m_services.toArray();
            }
            for (int i = 0; i < services.length; ++i) {
                DependencyService ds = (DependencyService)services[i];
                if (counter == 0L) {
                    ds.dependencyUnavailable(this);
                    if (this.isRequired()) continue;
                    this.invokeRemoved(ds, resource, resourceProperties);
                    continue;
                }
                ds.dependencyChanged(this);
                this.invokeRemoved(ds, resource, resourceProperties);
            }
        }
    }

    public void invokeAdded(DependencyService ds, URL serviceInstance, Dictionary resourceProperties) {
        this.invoke(ds, serviceInstance, resourceProperties, this.m_callbackAdded);
    }

    public void invokeChanged(DependencyService ds, URL serviceInstance, Dictionary resourceProperties) {
        this.invoke(ds, serviceInstance, resourceProperties, this.m_callbackChanged);
    }

    public void invokeRemoved(DependencyService ds, URL serviceInstance, Dictionary resourceProperties) {
        this.invoke(ds, serviceInstance, resourceProperties, this.m_callbackRemoved);
    }

    private void invoke(DependencyService ds, URL serviceInstance, Dictionary resourceProperties, String name) {
        if (name != null) {
            ds.invokeCallbackMethod(this.getCallbackInstances(ds), name, new Class[][]{{class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ResourceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$java$net$URL == null ? (class$java$net$URL = ResourceDependencyImpl.class$("java.net.URL")) : class$java$net$URL, class$java$util$Dictionary == null ? (class$java$util$Dictionary = ResourceDependencyImpl.class$("java.util.Dictionary")) : class$java$util$Dictionary}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ResourceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$java$net$URL == null ? (class$java$net$URL = ResourceDependencyImpl.class$("java.net.URL")) : class$java$net$URL}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ResourceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component}, {class$java$net$URL == null ? (class$java$net$URL = ResourceDependencyImpl.class$("java.net.URL")) : class$java$net$URL, class$java$util$Dictionary == null ? (class$java$util$Dictionary = ResourceDependencyImpl.class$("java.util.Dictionary")) : class$java$util$Dictionary}, {class$java$net$URL == null ? (class$java$net$URL = ResourceDependencyImpl.class$("java.net.URL")) : class$java$net$URL}, {class$java$lang$Object == null ? (class$java$lang$Object = ResourceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, new Class[0]}, new Object[][]{{ds.getServiceInterface(), serviceInstance, resourceProperties}, {ds.getServiceInterface(), serviceInstance}, {ds.getServiceInterface()}, {serviceInstance, resourceProperties}, {serviceInstance}, {serviceInstance}, new Object[0]});
        }
    }

    public synchronized ResourceDependency setCallbacks(String added, String removed) {
        return this.setCallbacks(null, added, null, removed);
    }

    public synchronized ResourceDependency setCallbacks(String added, String changed, String removed) {
        return this.setCallbacks(null, added, changed, removed);
    }

    public synchronized ResourceDependency setCallbacks(Object instance, String added, String removed) {
        return this.setCallbacks(instance, added, null, removed);
    }

    public synchronized ResourceDependency setCallbacks(Object instance, String added, String changed, String removed) {
        this.ensureNotActive();
        if (added != null || removed != null || changed != null) {
            this.setAutoConfig(false);
        }
        this.m_callbackInstance = instance;
        this.m_callbackAdded = added;
        this.m_callbackChanged = changed;
        this.m_callbackRemoved = removed;
        return this;
    }

    private void ensureNotActive() {
        if (this.m_registration != null) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    public synchronized ResourceDependency setAutoConfig(boolean autoConfig) {
        this.ensureNotActive();
        this.m_autoConfig = autoConfig;
        return this;
    }

    public synchronized ResourceDependency setAutoConfig(String instanceName) {
        this.ensureNotActive();
        this.m_autoConfig = instanceName != null;
        this.m_autoConfigInstance = instanceName;
        return this;
    }

    private synchronized Object[] getCallbackInstances(DependencyService ds) {
        if (this.m_callbackInstance == null) {
            return ds.getCompositionInstances();
        }
        return new Object[]{this.m_callbackInstance};
    }

    public ResourceDependency setResource(URL resource) {
        this.m_trackedResource = resource;
        return this;
    }

    public synchronized ResourceDependency setRequired(boolean required) {
        this.ensureNotActive();
        this.setIsRequired(required);
        return this;
    }

    public ResourceDependency setFilter(String resourceFilter) {
        this.ensureNotActive();
        this.m_resourceFilter = resourceFilter;
        return this;
    }

    public ResourceDependency setFilter(String resourceFilter, String resourcePropertiesFilter) {
        this.ensureNotActive();
        this.m_resourceFilter = resourceFilter;
        return this;
    }

    public void setResourcePropertiesConfigurationMember() {
    }

    public synchronized boolean isAutoConfig() {
        return this.m_autoConfig;
    }

    public URL getResource() {
        return this.lookupResource();
    }

    private URL lookupResource() {
        try {
            return (URL)this.m_resources.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private Dictionary lookupResourceProperties() {
        try {
            return (Dictionary)this.m_resourceProperties.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Object getAutoConfigInstance() {
        return this.lookupResource();
    }

    public String getAutoConfigName() {
        return this.m_autoConfigInstance;
    }

    public Class getAutoConfigType() {
        return class$java$net$URL == null ? (class$java$net$URL = ResourceDependencyImpl.class$("java.net.URL")) : class$java$net$URL;
    }

    public void invokeAdded(DependencyService service) {
        this.m_resourceInstance = this.lookupResource();
        this.m_resourcePropertiesInstance = this.lookupResourceProperties();
        this.invokeAdded(service, this.m_resourceInstance, this.m_resourcePropertiesInstance);
    }

    public void invokeRemoved(DependencyService service) {
        this.invokeRemoved(service, this.m_resourceInstance, this.m_resourcePropertiesInstance);
        this.m_resourceInstance = null;
        this.m_resourcePropertiesInstance = null;
    }

    public ResourceDependency setPropagate(boolean propagate) {
        this.ensureNotActive();
        this.m_propagate = propagate;
        return this;
    }

    public ResourceDependency setPropagate(Object instance, String method) {
        this.setPropagate(instance != null && method != null);
        this.m_propagateCallbackInstance = instance;
        this.m_propagateCallbackMethod = method;
        return this;
    }

    public Dictionary getProperties() {
        URL resource = this.lookupResource();
        Dictionary resourceProperties = this.lookupResourceProperties();
        if (resource != null) {
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, new Class[][]{{class$java$net$URL == null ? (class$java$net$URL = ResourceDependencyImpl.class$("java.net.URL")) : class$java$net$URL}}, new Object[][]{{resource}});
                }
                catch (InvocationTargetException e) {
                    this.m_logger.log(2, "Exception while invoking callback method", e.getCause());
                }
                catch (Exception e) {
                    this.m_logger.log(2, "Exception while trying to invoke callback method", e);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            Properties props = new Properties();
            props.setProperty("host", resource.getHost());
            props.setProperty("path", resource.getPath());
            props.setProperty("protocol", resource.getProtocol());
            props.setProperty("port", Integer.toString(resource.getPort()));
            if (resourceProperties != null) {
                Enumeration properyKeysEnum = resourceProperties.keys();
                while (properyKeysEnum.hasMoreElements()) {
                    String key = (String)properyKeysEnum.nextElement();
                    if (!(key.equals("host") || key.equals("path") || key.equals("protocol") || key.equals("port"))) {
                        props.setProperty(key, resourceProperties.get(key).toString());
                        continue;
                    }
                    this.m_logger.log(2, "Custom resource property is overlapping with the default resource property for key: " + key);
                }
            }
            return props;
        }
        throw new IllegalStateException("cannot find resource");
    }

    public boolean isPropagated() {
        return this.m_propagate;
    }

    public ResourceDependency setInstanceBound(boolean isInstanceBound) {
        this.setIsInstanceBound(isInstanceBound);
        return this;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.m_resourceFilter != null) {
            sb.append(this.m_resourceFilter);
        }
        if (this.m_trackedResource != null) {
            sb.append(this.m_trackedResource.toString());
        }
        return sb.toString();
    }

    public String getType() {
        return "resource";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

