/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivation;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.InvocationUtil;
import org.apache.felix.dm.impl.DefaultNullObject;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.SerialExecutor;
import org.apache.felix.dm.impl.ServiceRegistrationImpl;
import org.apache.felix.dm.impl.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ComponentImpl
implements Component,
DependencyService,
ComponentDeclaration,
Comparable {
    private static final Class[] VOID = new Class[0];
    private static final ServiceRegistration NULL_REGISTRATION;
    private static final ComponentStateListener[] SERVICE_STATE_LISTENER_TYPE;
    private static long HIGHEST_ID;
    private final Object SYNC = new Object();
    private final BundleContext m_context;
    private final DependencyManager m_manager;
    private final long m_id;
    private String m_callbackInit;
    private String m_callbackStart;
    private String m_callbackStop;
    private String m_callbackDestroy;
    private Object m_serviceName;
    private Object m_implementation;
    private Object m_callbackInstance;
    private Dictionary m_serviceProperties;
    private ArrayList m_dependencies = new ArrayList();
    private State m_state;
    private Object m_serviceInstance;
    private volatile ServiceRegistration m_registration;
    private boolean m_isBound;
    private boolean m_isInstantiated;
    private final List m_stateListeners = new ArrayList();
    private final SerialExecutor m_executor = new SerialExecutor();
    private Object m_instanceFactory;
    private String m_instanceFactoryCreateMethod;
    private Object m_compositionManager;
    private String m_compositionManagerGetMethod;
    private Object m_compositionManagerInstance;
    private final Logger m_logger;
    private Map m_autoConfig = new HashMap();
    private Map m_autoConfigInstance = new HashMap();
    private boolean m_isStarted = false;
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;
    static /* synthetic */ Class class$org$osgi$framework$ServiceRegistration;
    static /* synthetic */ Class class$org$apache$felix$dm$DependencyManager;
    static /* synthetic */ Class class$org$apache$felix$dm$Component;
    static /* synthetic */ Class class$org$apache$felix$dm$impl$ComponentImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentImpl(BundleContext context, DependencyManager manager, Logger logger) {
        Class[] classArray = VOID;
        synchronized (VOID) {
            this.m_id = HIGHEST_ID++;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.m_logger = logger;
            this.m_state = new State((List)this.m_dependencies.clone(), false, false, false);
            this.m_context = context;
            this.m_manager = manager;
            this.m_callbackInit = "init";
            this.m_callbackStart = "start";
            this.m_callbackStop = "stop";
            this.m_callbackDestroy = "destroy";
            this.m_implementation = null;
            this.m_autoConfig.put(class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = ComponentImpl.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext, Boolean.TRUE);
            this.m_autoConfig.put(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration, Boolean.TRUE);
            this.m_autoConfig.put(class$org$apache$felix$dm$DependencyManager == null ? (class$org$apache$felix$dm$DependencyManager = ComponentImpl.class$("org.apache.felix.dm.DependencyManager")) : class$org$apache$felix$dm$DependencyManager, Boolean.TRUE);
            this.m_autoConfig.put(class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ComponentImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, Boolean.TRUE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateStateChanges() {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive(), this.m_isInstantiated, this.m_isBound);
        }
        this.calculateStateChanges(oldState, newState);
    }

    private void calculateStateChanges(final State oldState, final State newState) {
        if (oldState.isInactive() && newState.isTrackingOptional()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.activateService(newState);
                }
            });
        }
        if (oldState.isInactive() && newState.isWaitingForRequired()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.startTrackingRequired(newState);
                }
            });
        }
        if (oldState.isWaitingForRequired() && newState.isTrackingOptional()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.activateService(newState);
                }
            });
        }
        if (oldState.isWaitingForRequired() && newState.isInactive()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.stopTrackingRequired(oldState);
                }
            });
        }
        if (oldState.isTrackingOptional() && newState.isWaitingForRequiredInstantiated()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                }
            });
        }
        if (oldState.isTrackingOptional() && newState.isWaitingForRequired()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.deactivateService(oldState);
                }
            });
        }
        if (oldState.isTrackingOptional() && newState.isBound()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.bindService(newState);
                }
            });
        }
        if (oldState.isTrackingOptional() && newState.isInactive()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.deactivateService(oldState);
                    ComponentImpl.this.stopTrackingRequired(oldState);
                }
            });
        }
        if (oldState.isWaitingForRequiredInstantiated() && newState.isWaitingForRequired()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.deactivateService(oldState);
                }
            });
        }
        if (oldState.isWaitingForRequiredInstantiated() && newState.isInactive()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.deactivateService(oldState);
                    ComponentImpl.this.stopTrackingRequired(oldState);
                }
            });
        }
        if (oldState.isWaitingForRequiredInstantiated() && newState.isBound()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.bindService(newState);
                }
            });
        }
        if (oldState.isBound() && newState.isWaitingForRequiredInstantiated()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.unbindService(oldState);
                }
            });
        }
        if (oldState.isBound() && newState.isWaitingForRequired()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.unbindService(oldState);
                    ComponentImpl.this.deactivateService(oldState);
                }
            });
        }
        if (oldState.isBound() && newState.isInactive()) {
            this.m_executor.enqueue(new Runnable(){

                public void run() {
                    ComponentImpl.this.unbindService(oldState);
                    ComponentImpl.this.deactivateService(oldState);
                    ComponentImpl.this.stopTrackingRequired(oldState);
                }
            });
        }
        this.m_executor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component add(Dependency dependency) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_dependencies.add(dependency);
        }
        if (!oldState.isInactive()) {
            if (dependency.isRequired()) {
                ((DependencyActivation)((Object)dependency)).start(this);
            } else if (oldState.isBound()) {
                ((DependencyActivation)((Object)dependency)).start(this);
            }
        }
        arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive(), this.m_isInstantiated, this.m_isBound);
        }
        this.calculateStateChanges(oldState, newState);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component add(List dependencies) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            for (int i = 0; i < dependencies.size(); ++i) {
                this.m_dependencies.add(dependencies.get(i));
            }
        }
        if (!oldState.isInactive()) {
            for (int i = 0; i < dependencies.size(); ++i) {
                Dependency dependency = (Dependency)dependencies.get(i);
                if (dependency.isRequired()) {
                    ((DependencyActivation)((Object)dependency)).start(this);
                    continue;
                }
                if (!oldState.isBound()) continue;
                ((DependencyActivation)((Object)dependency)).start(this);
            }
        }
        ArrayList arrayList2 = this.m_dependencies;
        synchronized (arrayList2) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive(), this.m_isInstantiated, this.m_isBound);
        }
        this.calculateStateChanges(oldState, newState);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component remove(Dependency dependency) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_dependencies.remove(dependency);
        }
        if (oldState.isAllRequiredAvailable() || (oldState.isWaitingForRequired() || oldState.isWaitingForRequiredInstantiated()) && dependency.isRequired()) {
            ((DependencyActivation)((Object)dependency)).stop(this);
        }
        arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive(), this.m_isInstantiated, this.m_isBound);
        }
        this.calculateStateChanges(oldState, newState);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependencies() {
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            return (List)this.m_dependencies.clone();
        }
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_registration;
    }

    public Object getService() {
        return this.m_serviceInstance;
    }

    public Component getServiceInterface() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dependencyAvailable(Dependency dependency) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive(), this.m_isInstantiated, this.m_isBound);
        }
        if (newState.isAllRequiredAvailable() || newState.isWaitingForRequiredInstantiated()) {
            this.updateInstance(dependency);
        }
        this.calculateStateChanges(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dependencyChanged(Dependency dependency) {
        State state;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        if (state.isAllRequiredAvailable()) {
            this.updateInstance(dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dependencyUnavailable(Dependency dependency) {
        State newState;
        State oldState;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            oldState = this.m_state;
            this.m_state = newState = new State((List)this.m_dependencies.clone(), !oldState.isInactive(), this.m_isInstantiated, this.m_isBound);
        }
        if (newState.isAllRequiredAvailable()) {
            this.updateInstance(dependency);
        }
        this.calculateStateChanges(oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean needsStarting = false;
        ComponentImpl componentImpl = this;
        synchronized (componentImpl) {
            if (!this.m_isStarted) {
                this.m_isStarted = true;
                needsStarting = true;
            }
        }
        if (needsStarting) {
            State newState;
            State oldState;
            ArrayList arrayList = this.m_dependencies;
            synchronized (arrayList) {
                oldState = this.m_state;
                this.m_state = newState = new State((List)this.m_dependencies.clone(), true, this.m_isInstantiated, this.m_isBound);
            }
            this.calculateStateChanges(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean needsStopping = false;
        ComponentImpl componentImpl = this;
        synchronized (componentImpl) {
            if (this.m_isStarted) {
                this.m_isStarted = false;
                needsStopping = true;
            }
        }
        if (needsStopping) {
            State newState;
            State oldState;
            ArrayList arrayList = this.m_dependencies;
            synchronized (arrayList) {
                oldState = this.m_state;
                this.m_state = newState = new State((List)this.m_dependencies.clone(), false, this.m_isInstantiated, this.m_isBound);
            }
            this.calculateStateChanges(oldState, newState);
        }
    }

    public synchronized Component setInterface(String serviceName, Dictionary properties) {
        this.ensureNotActive();
        this.m_serviceName = serviceName;
        this.m_serviceProperties = properties;
        return this;
    }

    public synchronized Component setInterface(String[] serviceName, Dictionary properties) {
        this.ensureNotActive();
        this.m_serviceName = serviceName;
        this.m_serviceProperties = properties;
        return this;
    }

    public synchronized Component setCallbacks(String init, String start, String stop, String destroy) {
        this.ensureNotActive();
        this.m_callbackInit = init;
        this.m_callbackStart = start;
        this.m_callbackStop = stop;
        this.m_callbackDestroy = destroy;
        return this;
    }

    public synchronized Component setCallbacks(Object instance, String init, String start, String stop, String destroy) {
        this.ensureNotActive();
        this.m_callbackInstance = instance;
        this.m_callbackInit = init;
        this.m_callbackStart = start;
        this.m_callbackStop = stop;
        this.m_callbackDestroy = destroy;
        return this;
    }

    public synchronized Component setImplementation(Object implementation) {
        this.ensureNotActive();
        this.m_implementation = implementation;
        return this;
    }

    public synchronized Component setFactory(Object factory, String createMethod) {
        this.ensureNotActive();
        this.m_instanceFactory = factory;
        this.m_instanceFactoryCreateMethod = createMethod;
        return this;
    }

    public synchronized Component setFactory(String createMethod) {
        return this.setFactory(null, createMethod);
    }

    public synchronized Component setComposition(Object instance, String getMethod) {
        this.ensureNotActive();
        this.m_compositionManager = instance;
        this.m_compositionManagerGetMethod = getMethod;
        return this;
    }

    public synchronized Component setComposition(String getMethod) {
        return this.setComposition(null, getMethod);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.m_serviceName + " " + this.m_implementation + "]";
    }

    public synchronized Dictionary getServiceProperties() {
        if (this.m_serviceProperties != null) {
            return (Dictionary)((Hashtable)this.m_serviceProperties).clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component setServiceProperties(Dictionary serviceProperties) {
        boolean needsProperties = false;
        Dictionary properties = null;
        ComponentImpl componentImpl = this;
        synchronized (componentImpl) {
            this.m_serviceProperties = serviceProperties;
            if (this.m_registration != null && this.m_serviceName != null) {
                properties = this.calculateServiceProperties();
                needsProperties = true;
            }
        }
        if (needsProperties) {
            this.m_registration.setProperties(properties);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(ComponentStateListener listener) {
        State state;
        List list = this.m_stateListeners;
        synchronized (list) {
            this.m_stateListeners.add(listener);
        }
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        if (state.isBound()) {
            listener.starting(this);
            listener.started(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(ComponentStateListener listener) {
        List list = this.m_stateListeners;
        synchronized (list) {
            this.m_stateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListeners() {
        List list = this.m_stateListeners;
        synchronized (list) {
            this.m_stateListeners.clear();
        }
    }

    private void stateListenersStarting() {
        ComponentStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].starting(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener starting method.", t);
            }
        }
    }

    private void stateListenersStarted() {
        ComponentStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].started(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener started method.", t);
            }
        }
    }

    private void stateListenersStopping() {
        ComponentStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].stopping(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener stopping method.", t);
            }
        }
    }

    private void stateListenersStopped() {
        ComponentStateListener[] list = this.getListeners();
        for (int i = 0; i < list.length; ++i) {
            try {
                list[i].stopped(this);
                continue;
            }
            catch (Throwable t) {
                this.m_logger.log(1, "Error invoking listener stopped method.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentStateListener[] getListeners() {
        List list = this.m_stateListeners;
        synchronized (list) {
            return this.m_stateListeners.toArray(SERVICE_STATE_LISTENER_TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateService(State state) {
        String init;
        ComponentImpl componentImpl = this;
        synchronized (componentImpl) {
            init = this.m_callbackInit;
        }
        this.initService();
        this.configureService(state);
        this.m_isInstantiated = true;
        this.invoke(init);
        this.calculateStateChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindService(State state) {
        String start;
        ComponentImpl componentImpl = this;
        synchronized (componentImpl) {
            start = this.m_callbackStart;
        }
        this.configureServiceWithExtraDependencies(state);
        this.stateListenersStarting();
        this.invoke(start);
        this.startTrackingOptional(state);
        this.registerService();
        this.stateListenersStarted();
    }

    private void configureServiceWithExtraDependencies(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (!dependency.isAutoConfig() || !dependency.isInstanceBound()) continue;
            this.configureImplementation(dependency.getAutoConfigType(), dependency.getAutoConfigInstance(), dependency.getAutoConfigName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindService(State state) {
        String stop;
        ComponentImpl componentImpl = this;
        synchronized (componentImpl) {
            stop = this.m_callbackStop;
        }
        this.stateListenersStopping();
        this.unregisterService();
        this.stopTrackingOptional(state);
        this.invoke(stop);
        this.stateListenersStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateService(State state) {
        String destroy;
        ComponentImpl componentImpl = this;
        synchronized (componentImpl) {
            destroy = this.m_callbackDestroy;
        }
        this.m_isInstantiated = false;
        this.invoke(destroy);
        this.destroyService(state);
    }

    private void invoke(String name) {
        if (name != null) {
            Object[] objectArray;
            if (this.m_callbackInstance != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.m_callbackInstance;
            } else {
                objectArray = this.getCompositionInstances();
            }
            Object[] instances = objectArray;
            this.invokeCallbackMethod(instances, name, new Class[][]{{class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ComponentImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component}, new Class[0]}, new Object[][]{{this}, new Object[0]});
        }
    }

    public void invokeCallbackMethod(Object[] instances, String methodName, Class[][] signatures, Object[][] parameters) {
        for (int i = 0; i < instances.length; ++i) {
            try {
                InvocationUtil.invokeCallbackMethod(instances[i], methodName, signatures, parameters);
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                this.m_logger.log(2, "Invocation of '" + methodName + "' failed.", e.getCause());
                continue;
            }
            catch (Exception e) {
                this.m_logger.log(2, "Could not invoke '" + methodName + "'.", e);
            }
        }
    }

    private void startTrackingOptional(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (dependency.isRequired()) continue;
            ((DependencyActivation)((Object)dependency)).start(this);
        }
    }

    private void stopTrackingOptional(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (dependency.isRequired()) continue;
            ((DependencyActivation)((Object)dependency)).stop(this);
        }
    }

    private void startTrackingRequired(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (!dependency.isRequired()) continue;
            ((DependencyActivation)((Object)dependency)).start(this);
        }
    }

    private void stopTrackingRequired(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (!dependency.isRequired()) continue;
            ((DependencyActivation)((Object)dependency)).stop(this);
        }
    }

    private Object createInstance(Class clazz) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor constructor = clazz.getConstructor(VOID);
        constructor.setAccessible(true);
        return constructor.newInstance(null);
    }

    public void initService() {
        if (this.m_serviceInstance == null) {
            if (this.m_implementation instanceof Class) {
                try {
                    this.m_serviceInstance = this.createInstance((Class)this.m_implementation);
                }
                catch (Exception e) {
                    this.m_logger.log(1, "Could not create service instance of class " + this.m_implementation + ".", e);
                }
            } else {
                if (this.m_instanceFactoryCreateMethod != null) {
                    Object factory = null;
                    if (this.m_instanceFactory != null) {
                        if (this.m_instanceFactory instanceof Class) {
                            try {
                                factory = this.createInstance((Class)this.m_instanceFactory);
                            }
                            catch (Exception e) {
                                this.m_logger.log(1, "Could not create factory instance of class " + this.m_instanceFactory + ".", e);
                            }
                        } else {
                            factory = this.m_instanceFactory;
                        }
                    }
                    if (factory == null) {
                        this.m_logger.log(1, "Factory cannot be null.");
                    } else {
                        try {
                            this.m_serviceInstance = InvocationUtil.invokeMethod(factory, factory.getClass(), this.m_instanceFactoryCreateMethod, new Class[][]{new Class[0]}, new Object[][]{new Object[0]}, false);
                        }
                        catch (Exception e) {
                            this.m_logger.log(1, "Could not create service instance using factory " + factory + " method " + this.m_instanceFactoryCreateMethod + ".", e);
                        }
                    }
                }
                if (this.m_serviceInstance == null) {
                    if (this.m_implementation == null) {
                        this.m_logger.log(1, "Implementation cannot be null.");
                    }
                    this.m_serviceInstance = this.m_implementation;
                }
            }
            if (((Boolean)this.m_autoConfig.get(class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = ComponentImpl.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext)).booleanValue()) {
                this.configureImplementation(class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = ComponentImpl.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext, this.m_context, (String)this.m_autoConfigInstance.get(class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = ComponentImpl.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext));
            }
            if (((Boolean)this.m_autoConfig.get(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration)).booleanValue()) {
                this.configureImplementation(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration, NULL_REGISTRATION, (String)this.m_autoConfigInstance.get(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration));
            }
            if (((Boolean)this.m_autoConfig.get(class$org$apache$felix$dm$DependencyManager == null ? (class$org$apache$felix$dm$DependencyManager = ComponentImpl.class$("org.apache.felix.dm.DependencyManager")) : class$org$apache$felix$dm$DependencyManager)).booleanValue()) {
                this.configureImplementation(class$org$apache$felix$dm$DependencyManager == null ? (class$org$apache$felix$dm$DependencyManager = ComponentImpl.class$("org.apache.felix.dm.DependencyManager")) : class$org$apache$felix$dm$DependencyManager, this.m_manager, (String)this.m_autoConfigInstance.get(class$org$apache$felix$dm$DependencyManager == null ? (class$org$apache$felix$dm$DependencyManager = ComponentImpl.class$("org.apache.felix.dm.DependencyManager")) : class$org$apache$felix$dm$DependencyManager));
            }
            if (((Boolean)this.m_autoConfig.get(class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ComponentImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component)).booleanValue()) {
                this.configureImplementation(class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ComponentImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, this, (String)this.m_autoConfigInstance.get(class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ComponentImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component));
            }
        }
    }

    public synchronized Component setAutoConfig(Class clazz, boolean autoConfig) {
        this.m_autoConfig.put(clazz, autoConfig);
        return this;
    }

    public synchronized Component setAutoConfig(Class clazz, String instanceName) {
        this.m_autoConfig.put(clazz, instanceName != null);
        this.m_autoConfigInstance.put(clazz, instanceName);
        return this;
    }

    public boolean getAutoConfig(Class clazz) {
        Boolean result = (Boolean)this.m_autoConfig.get(clazz);
        return result != null && result != false;
    }

    public String getAutoConfigInstance(Class clazz) {
        return (String)this.m_autoConfigInstance.get(clazz);
    }

    private void configureService(State state) {
        this.configureServices(state);
    }

    private void destroyService(State state) {
        this.unconfigureServices(state);
        this.m_serviceInstance = null;
    }

    private void registerService() {
        if (this.m_serviceName != null) {
            ServiceRegistrationImpl wrapper = new ServiceRegistrationImpl();
            this.m_registration = wrapper;
            if (((Boolean)this.m_autoConfig.get(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration)).booleanValue()) {
                this.configureImplementation(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration, this.m_registration, (String)this.m_autoConfigInstance.get(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration));
            }
            Dictionary properties = this.calculateServiceProperties();
            try {
                ServiceRegistration registration = this.m_serviceName instanceof String ? this.m_context.registerService((String)this.m_serviceName, this.m_serviceInstance, properties) : this.m_context.registerService((String[])this.m_serviceName, this.m_serviceInstance, properties);
                wrapper.setServiceRegistration(registration);
            }
            catch (IllegalArgumentException iae) {
                this.m_logger.log(1, "Could not register service " + this.m_serviceInstance, iae);
                wrapper.setIllegalState();
            }
        }
        this.m_isBound = true;
    }

    private Dictionary calculateServiceProperties() {
        Properties properties = new Properties();
        this.addTo(properties, this.m_serviceProperties);
        for (int i = 0; i < this.m_dependencies.size(); ++i) {
            Dependency d = (Dependency)this.m_dependencies.get(i);
            if (!d.isPropagated() || !d.isAvailable()) continue;
            Dictionary dict = d.getProperties();
            this.addTo(properties, dict);
        }
        if (((Dictionary)properties).size() == 0) {
            properties = null;
        }
        return properties;
    }

    private void addTo(Dictionary properties, Dictionary additional) {
        if (properties == null) {
            throw new IllegalArgumentException("Dictionary to add to cannot be null.");
        }
        if (additional != null) {
            Enumeration e = additional.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                properties.put(key, additional.get(key));
            }
        }
    }

    private void unregisterService() {
        this.m_isBound = false;
        if (this.m_serviceName != null) {
            this.m_registration.unregister();
            this.configureImplementation(class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration, NULL_REGISTRATION);
            this.m_registration = null;
        }
    }

    private void updateInstance(Dependency dependency) {
        if (dependency.isAutoConfig()) {
            this.configureImplementation(dependency.getAutoConfigType(), dependency.getAutoConfigInstance(), dependency.getAutoConfigName());
        }
        if (dependency.isPropagated() && this.m_registration != null) {
            this.m_registration.setProperties(this.calculateServiceProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureImplementation(Class clazz, Object instance, String instanceName) {
        Object[] instances = this.getCompositionInstances();
        if (instances != null) {
            for (int i = 0; i < instances.length; ++i) {
                Object serviceInstance = instances[i];
                Class<?> serviceClazz = serviceInstance.getClass();
                if (Proxy.isProxyClass(serviceClazz)) {
                    serviceInstance = Proxy.getInvocationHandler(serviceInstance);
                    serviceClazz = serviceInstance.getClass();
                }
                while (serviceClazz != null) {
                    Field[] fields = serviceClazz.getDeclaredFields();
                    for (int j = 0; j < fields.length; ++j) {
                        Field field = fields[j];
                        Class<?> type = field.getType();
                        if ((instanceName != null || !type.equals(clazz)) && (instanceName == null || !field.getName().equals(instanceName) || !type.isAssignableFrom(clazz))) continue;
                        try {
                            field.setAccessible(true);
                            Object object = this.SYNC;
                            synchronized (object) {
                                field.set(serviceInstance, instance);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            this.m_logger.log(1, "Could not set field " + field, e);
                            return;
                        }
                    }
                    serviceClazz = serviceClazz.getSuperclass();
                }
            }
        }
    }

    public Object[] getCompositionInstances() {
        Object[] instances = null;
        if (this.m_compositionManagerGetMethod != null) {
            this.m_compositionManagerInstance = this.m_compositionManager != null ? this.m_compositionManager : this.m_serviceInstance;
            if (this.m_compositionManagerInstance != null) {
                try {
                    instances = (Object[])InvocationUtil.invokeMethod(this.m_compositionManagerInstance, this.m_compositionManagerInstance.getClass(), this.m_compositionManagerGetMethod, new Class[][]{new Class[0]}, new Object[][]{new Object[0]}, false);
                }
                catch (Exception e) {
                    Object[] objectArray;
                    this.m_logger.log(1, "Could not obtain instances from the composition manager.", e);
                    if (this.m_serviceInstance == null) {
                        objectArray = new Object[]{};
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = this.m_serviceInstance;
                    }
                    instances = objectArray;
                }
            }
        } else {
            Object[] objectArray;
            if (this.m_serviceInstance == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.m_serviceInstance;
            }
            instances = objectArray;
        }
        return instances;
    }

    private void configureImplementation(Class clazz, Object instance) {
        this.configureImplementation(clazz, instance, null);
    }

    private void configureServices(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (dependency.isAutoConfig()) {
                this.configureImplementation(dependency.getAutoConfigType(), dependency.getAutoConfigInstance(), dependency.getAutoConfigName());
            }
            if (!dependency.isRequired()) continue;
            dependency.invokeAdded(this);
        }
    }

    private void unconfigureServices(State state) {
        Iterator i = state.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (!dependency.isRequired()) continue;
            dependency.invokeRemoved(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureNotActive() {
        State state;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        if (!state.isInactive()) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered() {
        State state;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        return state.isAllRequiredAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstantiated() {
        State state;
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            state = this.m_state;
        }
        return state.isTrackingOptional() || state.isBound() || state.isWaitingForRequiredInstantiated();
    }

    public ComponentDependencyDeclaration[] getComponentDependencies() {
        List deps = this.getDependencies();
        if (deps != null) {
            ComponentDependencyDeclaration[] result = new ComponentDependencyDeclaration[deps.size()];
            for (int i = 0; i < result.length; ++i) {
                Dependency dep = (Dependency)deps.get(i);
                result[i] = dep instanceof ComponentDependencyDeclaration ? (ComponentDependencyDeclaration)((Object)dep) : new SCDImpl(dep.toString(), (dep.isAvailable() ? 1 : 0) + (dep.isRequired() ? 2 : 0), dep.getClass().getName());
            }
            return result;
        }
        return null;
    }

    public String getName() {
        Object serviceName = this.m_serviceName;
        if (serviceName instanceof String[]) {
            StringBuffer sb = new StringBuffer();
            String[] names = (String[])serviceName;
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(names[i]);
            }
            sb.append('(');
            sb.append(this.propertiesToString());
            sb.append(')');
            return sb.toString();
        }
        if (serviceName instanceof String) {
            return serviceName.toString() + "(" + this.propertiesToString() + ")";
        }
        Object implementation = this.m_implementation;
        if (implementation != null) {
            return implementation.toString();
        }
        return super.toString();
    }

    private String propertiesToString() {
        StringBuffer result = new StringBuffer();
        Dictionary properties = this.calculateServiceProperties();
        if (properties != null) {
            Enumeration enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(key.toString());
                result.append('=');
                Object value = properties.get(key);
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    result.append('{');
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            result.append(',');
                        }
                        result.append(values[i].toString());
                    }
                    result.append('}');
                    continue;
                }
                result.append(value.toString());
            }
        }
        return result.toString();
    }

    public int getState() {
        return this.isRegistered() ? 1 : 0;
    }

    public DependencyManager getDependencyManager() {
        return this.m_manager;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public int compareTo(Object object) {
        if (object instanceof ComponentImpl) {
            long id2;
            ComponentImpl other = (ComponentImpl)object;
            long id1 = this.getBundleContext().getBundle().getBundleId();
            if (id1 == (id2 = other.getBundleContext().getBundle().getBundleId())) {
                return (int)(this.m_id - other.m_id);
            }
            return (int)(id1 - id2);
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SERVICE_STATE_LISTENER_TYPE = new ComponentStateListener[0];
        HIGHEST_ID = 0L;
        NULL_REGISTRATION = (ServiceRegistration)Proxy.newProxyInstance((class$org$apache$felix$dm$impl$ComponentImpl == null ? (class$org$apache$felix$dm$impl$ComponentImpl = ComponentImpl.class$("org.apache.felix.dm.impl.ComponentImpl")) : class$org$apache$felix$dm$impl$ComponentImpl).getClassLoader(), new Class[]{class$org$osgi$framework$ServiceRegistration == null ? (class$org$osgi$framework$ServiceRegistration = ComponentImpl.class$("org.osgi.framework.ServiceRegistration")) : class$org$osgi$framework$ServiceRegistration}, (InvocationHandler)new DefaultNullObject());
    }

    static class SCDImpl
    implements ComponentDependencyDeclaration {
        private final String m_name;
        private final int m_state;
        private final String m_type;

        public SCDImpl(String name, int state, String type) {
            this.m_name = name;
            this.m_state = state;
            this.m_type = type;
        }

        public String getName() {
            return this.m_name;
        }

        public int getState() {
            return this.m_state;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

