/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.connect.PojoSR;
import org.apache.felix.connect.launch.ClasspathScanner;
import org.apache.felix.connect.launch.PojoServiceRegistry;
import org.apache.felix.connect.launch.PojoServiceRegistryFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class PojoServiceRegistryFactoryImpl
implements PojoServiceRegistryFactory,
FrameworkFactory {
    @Override
    public PojoServiceRegistry newPojoServiceRegistry(Map<String, Object> configuration) throws Exception {
        return new PojoSR(configuration);
    }

    @Override
    public Framework newFramework(Map<String, String> configuration) {
        return new FrameworkImpl(configuration.get("pojosr.filter"));
    }

    private static final class FrameworkImpl
    implements Framework {
        private final String m_filter;
        private volatile Bundle m_bundle = null;
        private volatile PojoServiceRegistry m_reg = null;

        public FrameworkImpl(String filter) {
            this.m_filter = filter;
        }

        @Override
        public void init() throws BundleException {
            try {
                this.m_reg = new PojoServiceRegistryFactoryImpl().newPojoServiceRegistry(new HashMap<String, Object>());
                this.m_bundle = this.m_reg.getBundleContext().getBundle();
            }
            catch (Exception ex) {
                throw new BundleException("Unable to scan classpath", ex);
            }
        }

        @Override
        public void init(FrameworkListener ... listeners) throws BundleException {
            this.init();
            for (FrameworkListener listener : listeners) {
                this.m_bundle.getBundleContext().addFrameworkListener(listener);
            }
        }

        @Override
        public int getState() {
            return this.m_bundle == null ? 2 : this.m_bundle.getState();
        }

        @Override
        public void start(int options) throws BundleException {
            this.start();
        }

        @Override
        public void start() throws BundleException {
            try {
                this.m_reg.startBundles(this.m_filter != null ? new ClasspathScanner().scanForBundles(this.m_filter) : new ClasspathScanner().scanForBundles());
            }
            catch (Exception e) {
                throw new BundleException("Error starting framework", e);
            }
        }

        @Override
        public void stop(int options) throws BundleException {
            this.m_bundle.stop(options);
        }

        @Override
        public void stop() throws BundleException {
            this.m_bundle.stop();
        }

        @Override
        public void update(InputStream input) throws BundleException {
            this.m_bundle.update(input);
        }

        @Override
        public void update() throws BundleException {
            this.m_bundle.update();
        }

        @Override
        public void uninstall() throws BundleException {
            this.m_bundle.uninstall();
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return this.m_bundle.getHeaders();
        }

        @Override
        public long getBundleId() {
            return this.m_bundle.getBundleId();
        }

        @Override
        public String getLocation() {
            return this.m_bundle.getLocation();
        }

        public ServiceReference[] getRegisteredServices() {
            return this.m_bundle.getRegisteredServices();
        }

        public ServiceReference[] getServicesInUse() {
            return this.m_bundle.getServicesInUse();
        }

        @Override
        public boolean hasPermission(Object permission) {
            return this.m_bundle.hasPermission(permission);
        }

        @Override
        public URL getResource(String name) {
            return this.m_bundle.getResource(name);
        }

        @Override
        public Dictionary<String, String> getHeaders(String locale) {
            return this.m_bundle.getHeaders(locale);
        }

        @Override
        public String getSymbolicName() {
            return this.m_bundle.getSymbolicName();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.m_bundle.loadClass(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.m_bundle.getResources(name);
        }

        @Override
        public Enumeration<String> getEntryPaths(String path) {
            return this.m_bundle.getEntryPaths(path);
        }

        @Override
        public URL getEntry(String path) {
            return this.m_bundle.getEntry(path);
        }

        @Override
        public long getLastModified() {
            return this.m_bundle.getLastModified();
        }

        @Override
        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            return this.m_bundle.findEntries(path, filePattern, recurse);
        }

        @Override
        public BundleContext getBundleContext() {
            return this.m_bundle.getBundleContext();
        }

        @Override
        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return this.m_bundle.getSignerCertificates(signersType);
        }

        @Override
        public Version getVersion() {
            return this.m_bundle.getVersion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
            final Object lock = new Object();
            this.m_bundle.getBundleContext().addBundleListener(new SynchronousBundleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void bundleChanged(BundleEvent event) {
                    if (event.getBundle() == FrameworkImpl.this.m_bundle && event.getType() == 4) {
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                        }
                    }
                }
            });
            Object object = lock;
            synchronized (object) {
                while (this.m_bundle.getState() != 4) {
                    if (this.m_bundle.getState() == 16) {
                        lock.wait(100L);
                        continue;
                    }
                    lock.wait();
                }
            }
            return new FrameworkEvent(64, this.m_bundle, null);
        }

        @Override
        public File getDataFile(String filename) {
            return this.m_bundle.getDataFile(filename);
        }

        @Override
        public int compareTo(Bundle o) {
            if (o == this) {
                return 0;
            }
            return this.m_bundle.compareTo(o);
        }

        @Override
        public <A> A adapt(Class<A> type) {
            return this.m_bundle.adapt(type);
        }
    }
}

