/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

class CaseInsensitiveDictionary
extends Dictionary {
    private Hashtable internalMap;
    private Hashtable originalKeys;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;

    CaseInsensitiveDictionary() {
        this.internalMap = new Hashtable();
        this.originalKeys = new Hashtable();
    }

    CaseInsensitiveDictionary(Dictionary props) {
        this();
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            CaseInsensitiveDictionary.checkKey(key);
            String lowerCase = ((String)key).toLowerCase();
            if (this.internalMap.containsKey(lowerCase)) {
                throw new IllegalArgumentException("Key [" + key + "] already present in different case");
            }
            Object value = props.get(key);
            value = CaseInsensitiveDictionary.checkValue(value);
            this.internalMap.put(lowerCase, value);
            this.originalKeys.put(lowerCase, key);
        }
    }

    CaseInsensitiveDictionary(CaseInsensitiveDictionary props) {
        this.internalMap = new Hashtable(props.internalMap);
        this.originalKeys = new Hashtable(props.originalKeys);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.internalMap.values());
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String stringKey = String.valueOf(key).toLowerCase();
        return this.internalMap.get(stringKey);
    }

    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    public Enumeration keys() {
        return Collections.enumeration(this.originalKeys.values());
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("key or value");
        }
        CaseInsensitiveDictionary.checkKey(key);
        value = CaseInsensitiveDictionary.checkValue(value);
        String lowerCase = String.valueOf(key).toLowerCase();
        this.originalKeys.put(lowerCase, key);
        return this.internalMap.put(lowerCase, value);
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String lowerCase = String.valueOf(key).toLowerCase();
        this.originalKeys.remove(lowerCase);
        return this.internalMap.remove(lowerCase);
    }

    public int size() {
        return this.internalMap.size();
    }

    static void checkKey(Object keyObject) {
        if (!(keyObject instanceof String)) {
            throw new IllegalArgumentException("Key [" + keyObject + "] must be a String");
        }
        String key = (String)keyObject;
        if (key.startsWith(".") || key.endsWith(".")) {
            throw new IllegalArgumentException("Key [" + key + "] must not start or end with a dot");
        }
        int lastDot = Integer.MIN_VALUE;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '.') {
                if (lastDot == i - 1) {
                    throw new IllegalArgumentException("Key [" + key + "] must not have consecutive dots");
                }
                lastDot = i;
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') continue;
            throw new IllegalArgumentException("Key [" + key + "] contains illegal character");
        }
    }

    static Object checkValue(Object value) {
        Class<?> type;
        if (value instanceof Object[]) {
            type = value.getClass().getComponentType();
            if (type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Boolean.TYPE) {
                return value;
            }
        } else if (value instanceof Collection) {
            Collection collection = value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Collection must not be empty");
            }
            ArrayList internalValue = new ArrayList(collection.size());
            type = null;
            Iterator ci = collection.iterator();
            while (ci.hasNext()) {
                Object el = ci.next();
                if (el == null) {
                    throw new IllegalArgumentException("Collection must not contain null elements");
                }
                if (type == null) {
                    type = el.getClass();
                } else if (type != el.getClass()) {
                    throw new IllegalArgumentException("Collection element types must not be mixed");
                }
                internalValue.add(el);
            }
            value = internalValue;
        } else if (value != null) {
            type = value.getClass();
        } else {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = CaseInsensitiveDictionary.class$("java.lang.String")) : class$java$lang$String) || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = CaseInsensitiveDictionary.class$("java.lang.Integer")) : class$java$lang$Integer) || type == (class$java$lang$Long == null ? (class$java$lang$Long = CaseInsensitiveDictionary.class$("java.lang.Long")) : class$java$lang$Long) || type == (class$java$lang$Float == null ? (class$java$lang$Float = CaseInsensitiveDictionary.class$("java.lang.Float")) : class$java$lang$Float) || type == (class$java$lang$Double == null ? (class$java$lang$Double = CaseInsensitiveDictionary.class$("java.lang.Double")) : class$java$lang$Double) || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = CaseInsensitiveDictionary.class$("java.lang.Byte")) : class$java$lang$Byte) || type == (class$java$lang$Short == null ? (class$java$lang$Short = CaseInsensitiveDictionary.class$("java.lang.Short")) : class$java$lang$Short) || type == (class$java$lang$Character == null ? (class$java$lang$Character = CaseInsensitiveDictionary.class$("java.lang.Character")) : class$java$lang$Character) || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CaseInsensitiveDictionary.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] has unsupported (base-) type " + type);
    }

    public String toString() {
        return this.internalMap.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

