/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.annotation.defaulttag;

import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.annotation.AnnotationConstant;
import com.thoughtworks.qdox.model.annotation.AnnotationFieldRef;
import com.thoughtworks.qdox.model.annotation.AnnotationValue;
import com.thoughtworks.qdox.model.annotation.AnnotationValueList;
import java.util.List;
import org.apache.felix.scrplugin.tags.ClassUtil;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util {
    public static boolean getBooleanValue(Annotation annotation, String name, Class<?> clazz) {
        Object obj = annotation.getNamedParameter(name);
        if (obj != null) {
            return Boolean.valueOf(obj.toString());
        }
        try {
            return (Boolean)clazz.getMethod(name, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException mnfe) {
            return true;
        }
    }

    public static int getIntValue(Annotation annotation, String name, Class<?> clazz) {
        Object obj = annotation.getNamedParameter(name);
        if (obj != null) {
            if (obj instanceof String) {
                return Integer.valueOf((String)obj);
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            return Integer.valueOf(obj.toString());
        }
        try {
            return (Integer)clazz.getMethod(name, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException mnfe) {
            return 0;
        }
    }

    public static String[] getStringValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        return sValues;
    }

    public static long[] getLongValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            long[] values = new long[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Long.valueOf(sValues[i]);
            }
            return values;
        }
        return null;
    }

    public static int[] getIntValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            int[] values = new int[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Integer.valueOf(sValues[i]);
            }
            return values;
        }
        return null;
    }

    public static float[] getFloatValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            float[] values = new float[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Float.valueOf(sValues[i]).floatValue();
            }
            return values;
        }
        return null;
    }

    public static double[] getDoubleValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            double[] values = new double[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Double.valueOf(sValues[i]);
            }
            return values;
        }
        return null;
    }

    public static char[] getCharValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            char[] values = new char[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = sValues[i].charAt(0);
            }
            return values;
        }
        return null;
    }

    public static short[] getShortValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            short[] values = new short[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Short.valueOf(sValues[i]);
            }
            return values;
        }
        return null;
    }

    public static byte[] getByteValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            byte[] values = new byte[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Byte.valueOf(sValues[i]);
            }
            return values;
        }
        return null;
    }

    public static boolean[] getBooleanValues(Annotation annotation, JavaClassDescription desc, String name) {
        String[] sValues = Util.getAnnotationValues(annotation, name, desc);
        if (sValues != null && sValues.length > 0) {
            boolean[] values = new boolean[sValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Boolean.valueOf(sValues[i]);
            }
            return values;
        }
        return null;
    }

    public static String getStringValue(Annotation annotation, JavaClassDescription desc, String name, Class<?> clazz) {
        String[] values = Util.getAnnotationValues(annotation, name, desc);
        if (values != null && values.length > 0) {
            return values[0];
        }
        try {
            return (String)clazz.getMethod(name, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException mnfe) {
            return "";
        }
    }

    public static Class<?> getClassValue(Annotation annotation, String name, Class<?> clazz) {
        Object obj = annotation.getNamedParameter(name);
        if (obj != null) {
            if (obj instanceof Class) {
                return (Class)obj;
            }
            return ClassUtil.getClass(obj.toString());
        }
        try {
            return (Class)clazz.getMethod(name, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException mnfe) {
            return null;
        }
    }

    public static <T extends Enum> T getEnumValue(Annotation annotation, String name, Class<T> enumClass, Class<?> clazz, boolean returnDefault) {
        Object obj = annotation.getNamedParameter(name);
        if (obj == null && returnDefault) {
            try {
                obj = clazz.getMethod(name, new Class[0]).getDefaultValue();
            }
            catch (NoSuchMethodException mnfe) {
                // empty catch block
            }
        }
        if (obj != null) {
            if (enumClass.isAssignableFrom(obj.getClass())) {
                return (T)((Enum)obj);
            }
            if (obj instanceof String) {
                String enumName = (String)obj;
                int dotPos = enumName.lastIndexOf(46);
                if (dotPos >= 0) {
                    enumName = enumName.substring(dotPos + 1);
                }
                T o = Enum.valueOf(enumClass, enumName);
                return (T)((Enum)o);
            }
        }
        return null;
    }

    public static <T extends Enum> T getEnumValue(Annotation annotation, String name, Class<T> enumClass, Class<?> clazz) {
        return Util.getEnumValue(annotation, name, enumClass, clazz, true);
    }

    private static String getAnnotationValue(AnnotationValue av, JavaClassDescription desc) throws IllegalArgumentException {
        if (av instanceof AnnotationFieldRef) {
            String s = av.getParameterValue().toString().trim();
            try {
                int classSep = s.lastIndexOf(46);
                JavaField field = null;
                if (classSep == -1) {
                    field = desc.getFieldByName(s);
                }
                if (field == null) {
                    field = desc.getExternalFieldByName(s);
                }
                if (field == null) {
                    throw new IllegalArgumentException("Property references unknown field " + s + " in class " + desc.getName());
                }
                String[] values = field.getInitializationExpression();
                if (values != null && values.length == 1) {
                    return values[0];
                }
                throw new IllegalArgumentException("Something is wrong.");
            }
            catch (MojoExecutionException mee) {
                throw new IllegalArgumentException(mee);
            }
        }
        return ((AnnotationConstant)av).getValue().toString();
    }

    public static String[] getAnnotationValues(Annotation annotation, String name, JavaClassDescription desc) throws IllegalArgumentException {
        AnnotationValue av = annotation.getProperty(name);
        if (av != null) {
            if (av instanceof AnnotationValueList) {
                AnnotationValueList avl = (AnnotationValueList)av;
                List list = avl.getValueList();
                String[] values = new String[list.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = Util.getAnnotationValue((AnnotationValue)list.get(i), desc);
                }
                return values;
            }
            return new String[]{Util.getAnnotationValue(av, desc)};
        }
        return null;
    }
}

