/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.cl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaMethod;
import org.apache.felix.scrplugin.tags.cl.ClassLoaderJavaTag;
import org.apache.maven.plugin.MojoExecutionException;

public class ClassLoaderJavaClassDescription
implements JavaClassDescription {
    protected static final JavaTag[] EMPTY_TAGS = new JavaTag[0];
    protected final Class clazz;
    protected final JavaClassDescriptorManager manager;
    protected final Component component;

    public ClassLoaderJavaClassDescription(Class c, Component comp, JavaClassDescriptorManager m) {
        this.clazz = c;
        this.manager = m;
        this.component = comp;
    }

    public JavaField[] getFields() {
        return new JavaField[0];
    }

    public JavaClassDescription[] getImplementedInterfaces() throws MojoExecutionException {
        Class<?>[] implemented = this.clazz.getInterfaces();
        if (implemented == null || implemented.length == 0) {
            return null;
        }
        JavaClassDescription[] jcd = new JavaClassDescription[implemented.length];
        for (int i = 0; i < jcd.length; ++i) {
            jcd[i] = this.manager.getJavaClassDescription(implemented[i].getName());
        }
        return jcd;
    }

    public JavaMethod getMethodBySignature(String name, String[] parameters) {
        Class[] classParameters = null;
        if (parameters != null) {
            classParameters = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                try {
                    classParameters[i] = this.manager.getClassLoader().loadClass(parameters[i]);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    return null;
                }
            }
        }
        Method m = null;
        try {
            m = this.clazz.getDeclaredMethod(name, classParameters);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (m != null) {
            return new ClassLoaderJavaMethod(m);
        }
        return null;
    }

    public JavaMethod[] getMethods() {
        return null;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public JavaClassDescription getSuperClass() throws MojoExecutionException {
        if (this.clazz.getSuperclass() != null) {
            return this.manager.getJavaClassDescription(this.clazz.getSuperclass().getName());
        }
        return null;
    }

    public JavaTag getTagByName(String name) {
        return null;
    }

    public JavaTag[] getTagsByName(String name, boolean inherited) throws MojoExecutionException {
        JavaTag[] superTags;
        JavaTag[] javaTags = EMPTY_TAGS;
        if (this.component != null && !"scr.service".equals(name) && !"scr.property".equals(name) && "scr.reference".equals(name) && this.component.getReferences().size() > 0) {
            javaTags = new JavaTag[this.component.getReferences().size()];
            for (int i = 0; i < this.component.getReferences().size(); ++i) {
                javaTags[i] = new ClassLoaderJavaTag(this, (Reference)this.component.getReferences().get(i));
            }
        }
        if (inherited && this.getSuperClass() != null && (superTags = this.getSuperClass().getTagsByName(name, inherited)).length > 0) {
            ArrayList<JavaTag> list = new ArrayList<JavaTag>(Arrays.asList(javaTags));
            list.addAll(Arrays.asList(superTags));
            javaTags = list.toArray(new JavaTag[list.size()]);
        }
        return javaTags;
    }

    public boolean isA(String type) {
        if (this.clazz.getName().equals(type)) {
            return true;
        }
        return this.testClass(this.clazz, type);
    }

    protected boolean testClass(Class c, String type) {
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getName().equals(type)) {
                return true;
            }
            if (!this.testClass(interfaces[i], type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.clazz.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.clazz.getModifiers());
    }
}

