/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlHelper {
    public static String getTextContent(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                return XmlHelper.mergeTextContent(node.getChildNodes());
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return null;
    }

    private static String mergeTextContent(NodeList nodes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String text;
            Node n = nodes.item(i);
            switch (n.getNodeType()) {
                case 7: 
                case 8: {
                    text = null;
                    break;
                }
                default: {
                    text = XmlHelper.getTextContent(n);
                }
            }
            if (text == null) continue;
            buf.append(text);
        }
        return buf.toString();
    }

    public static void setTextContent(Node node, String text) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
        if (text != null && text.length() > 0) {
            Text textNode = node.getOwnerDocument().createTextNode(text);
            node.appendChild(textNode);
        }
    }
}

