/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.obr.plugin.Capability;
import org.apache.felix.obr.plugin.Category;
import org.apache.felix.obr.plugin.ExtractBindexInfo;
import org.apache.felix.obr.plugin.PElement;
import org.apache.felix.obr.plugin.Require;
import org.apache.felix.obr.plugin.XmlHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourcesBundle {
    private String m_symbolicName;
    private String m_presentationName;
    private String m_version;
    private String m_uri;
    private String m_description;
    private String m_size;
    private String m_documentation;
    private String m_source;
    private String m_license;
    private String m_id;
    private List m_category = new ArrayList();
    private List m_capability = new ArrayList();
    private List m_require = new ArrayList();
    private Log m_logger;

    public ResourcesBundle(Log log) {
        this.m_logger = log;
    }

    public List getCapability() {
        return this.m_capability;
    }

    public void setCapability(List capability) {
        this.m_capability = capability;
    }

    public List getCategory() {
        return this.m_category;
    }

    public void setCategory(List category) {
        this.m_category = category;
    }

    public String getLicense() {
        return this.m_license;
    }

    public void setLicense(String license) {
        this.m_license = license;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDocumentation() {
        return this.m_documentation;
    }

    public void setDocumentation(String documentation) {
        this.m_documentation = documentation;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public void setPresentationName(String name) {
        this.m_presentationName = name;
    }

    public String getSize() {
        return this.m_size;
    }

    public void setSize(String size) {
        this.m_size = size;
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public void setSymbolicName(String name) {
        this.m_symbolicName = name;
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setUri(String url) {
        this.m_uri = url;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public List getRequire() {
        return this.m_require;
    }

    public void setRequire(List require) {
        this.m_require = require;
    }

    public String getSource() {
        return this.m_source;
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void addCapability(Capability capability) {
        this.m_capability.add(capability);
    }

    public void addRequire(Require require) {
        this.m_require.add(require);
    }

    public void addCategory(Category category) {
        this.m_category.add(category);
    }

    public Node getNode(Document father) {
        int i;
        if (!this.isValid() || this.getId() == null) {
            this.m_logger.error((CharSequence)("those properties was not defined:" + this.getInvalidProperties()));
            return null;
        }
        Element resource = father.createElement("resource");
        Element description = father.createElement("description");
        Element size = father.createElement("size");
        Element documentation = father.createElement("documentation");
        Element source = father.createElement("source");
        Element license = father.createElement("license");
        resource.setAttribute("id", this.getId());
        resource.setAttribute("symbolicname", this.getSymbolicName());
        resource.setAttribute("presentationname", this.getPresentationName());
        resource.setAttribute("uri", this.getUri());
        resource.setAttribute("version", this.getVersion());
        XmlHelper.setTextContent(description, this.getDescription());
        resource.appendChild(description);
        XmlHelper.setTextContent(size, this.getSize());
        resource.appendChild(size);
        if (this.getDocumentation() != null) {
            XmlHelper.setTextContent(documentation, this.getDocumentation());
            resource.appendChild(documentation);
        }
        if (this.getSource() != null) {
            XmlHelper.setTextContent(source, this.getSource());
            resource.appendChild(source);
        }
        if (this.getLicense() != null) {
            XmlHelper.setTextContent(license, this.getLicense());
            resource.appendChild(license);
        }
        List list = this.getNodeCategories(father);
        for (i = 0; i < list.size(); ++i) {
            resource.appendChild((Node)list.get(i));
        }
        list = this.getNodeCapabilities(father);
        for (i = 0; i < list.size(); ++i) {
            resource.appendChild((Node)list.get(i));
        }
        list = this.getNodeRequirement(father);
        for (i = 0; i < list.size(); ++i) {
            resource.appendChild((Node)list.get(i));
        }
        return resource;
    }

    public boolean construct(MavenProject project, ExtractBindexInfo ebi) {
        Iterator it;
        List l;
        String lic;
        if (ebi.getPresentationName() != null) {
            this.setPresentationName(ebi.getPresentationName());
            if (project.getName() != null) {
                this.m_logger.debug((CharSequence)("pom property override:<presentationname> " + project.getName()));
            }
        } else {
            this.setPresentationName(project.getName());
        }
        if (ebi.getSymbolicName() != null) {
            this.setSymbolicName(ebi.getSymbolicName());
            if (project.getArtifactId() != null) {
                this.m_logger.debug((CharSequence)("pom property override:<symbolicname> " + project.getArtifactId()));
            }
        } else {
            this.setSymbolicName(project.getArtifactId());
        }
        if (ebi.getVersion() != null) {
            this.setVersion(ebi.getVersion());
            if (project.getVersion() != null) {
                this.m_logger.debug((CharSequence)("pom property override:<version> " + project.getVersion()));
            }
        } else {
            this.setVersion(project.getVersion());
        }
        if (ebi.getId() != null) {
            this.setId(ebi.getId());
        }
        if (ebi.getDescription() != null) {
            this.setDescription(ebi.getDescription());
            if (project.getDescription() != null) {
                this.m_logger.debug((CharSequence)("pom property override:<description> " + project.getDescription()));
            }
        } else {
            this.setDescription(project.getDescription());
        }
        if (ebi.getDocumentation() != null) {
            this.setDocumentation(ebi.getDocumentation());
            if (project.getUrl() != null) {
                this.m_logger.debug((CharSequence)("pom property override:<documentation> " + project.getUrl()));
            }
        } else {
            this.setDocumentation(project.getUrl());
        }
        if (ebi.getSource() != null) {
            this.setSource(ebi.getSource());
            if (project.getScm() != null) {
                this.m_logger.debug((CharSequence)("pom property override:<source> " + project.getScm()));
            }
        } else {
            String src = null;
            if (project.getScm() != null) {
                src = project.getScm().getUrl();
            }
            this.setSource(src);
        }
        if (ebi.getLicense() != null) {
            this.setLicense(ebi.getLicense());
            lic = null;
            l = project.getLicenses();
            it = l.iterator();
            while (it.hasNext()) {
                if (it.next() == null) continue;
                this.m_logger.debug((CharSequence)("pom property override:<license> " + lic));
                break;
            }
        } else {
            lic = null;
            l = project.getLicenses();
            it = l.iterator();
            while (it.hasNext()) {
                lic = it.next() + ";";
            }
            this.setLicense(lic);
        }
        Capability capability = new Capability();
        capability.setName("bundle");
        PElement p = new PElement();
        p.setN("manifestversion");
        p.setV("2");
        capability.addP(p);
        p = new PElement();
        p.setN("presentationname");
        p.setV(this.getPresentationName());
        capability.addP(p);
        p = new PElement();
        p.setN("symbolicname");
        p.setV(this.getSymbolicName());
        capability.addP(p);
        p = new PElement();
        p.setN("version");
        p.setT("version");
        p.setV(this.getVersion());
        capability.addP(p);
        this.addCapability(capability);
        List capabilities = ebi.getCapabilities();
        for (int i = 0; i < capabilities.size(); ++i) {
            this.addCapability((Capability)capabilities.get(i));
        }
        List requirement = ebi.getRequirement();
        for (int i = 0; i < requirement.size(); ++i) {
            this.addRequire((Require)requirement.get(i));
        }
        Category category = new Category();
        category.setId(project.getGroupId());
        this.addCategory(category);
        return true;
    }

    public boolean isValid() {
        return this.getPresentationName() != null && this.getSymbolicName() != null && this.getVersion() != null && this.getUri() != null && this.getSize() != null;
    }

    public boolean isSameBundleResource(String symbolicName, String version) {
        if (this.isValid()) {
            return symbolicName.compareTo(this.getSymbolicName()) == 0 && version.compareTo(this.getVersion()) == 0;
        }
        return false;
    }

    private List getNodeCategories(Document father) {
        ArrayList<Node> listNode = new ArrayList<Node>();
        List listCategory = this.getCategory();
        for (int i = 0; i < listCategory.size(); ++i) {
            listNode.add(((Category)listCategory.get(i)).getNode(father));
        }
        return listNode;
    }

    private List getNodeCapabilities(Document father) {
        ArrayList<Node> listNode = new ArrayList<Node>();
        List listCapability = this.getCapability();
        for (int i = 0; i < listCapability.size(); ++i) {
            listNode.add(((Capability)listCapability.get(i)).getNode(father));
        }
        return listNode;
    }

    private List getNodeRequirement(Document father) {
        ArrayList<Node> listNode = new ArrayList<Node>();
        List listRequirement = this.getRequire();
        for (int i = 0; i < listRequirement.size(); ++i) {
            listNode.add(((Require)listRequirement.get(i)).getNode(father));
        }
        return listNode;
    }

    private String getInvalidProperties() {
        if (this.isValid()) {
            if (this.getId() == null) {
                return "id";
            }
            return "";
        }
        String result = "";
        if (this.getPresentationName() == null) {
            result = result + "presentationName;";
        }
        if (this.getSymbolicName() == null) {
            result = result + "symbolicName;";
        }
        if (this.getVersion() == null) {
            result = result + "version;";
        }
        if (this.getUri() == null) {
            result = result + "Uri;";
        }
        if (this.getSize() == null) {
            result = result + "Size";
        }
        return result;
    }
}

