/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.ObrUtils;
import org.apache.felix.obr.plugin.RemoteFileManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public final class ObrDeploy
extends AbstractMojo {
    private boolean ignoreLock;
    private String obrRepository;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private ArtifactRepository deploymentRepository;
    private String altDeploymentRepository;
    private ArtifactRepository localRepository;
    private MavenProject project;
    private Settings settings;
    private WagonManager m_wagonManager;
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        if (!this.supportedProjectTypes.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Ignoring packaging type " + this.project.getPackaging()));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.obrRepository)) {
            this.getLog().info((CharSequence)"OBR update disabled (enable with -DobrRepository)");
            return;
        }
        URI tempURI = ObrUtils.findRepositoryXml("", this.obrRepository);
        String repositoryName = new File(tempURI.getPath()).getName();
        Log log = this.getLog();
        RemoteFileManager remoteFile = new RemoteFileManager(this.m_wagonManager, this.settings, log);
        this.openRepositoryConnection(remoteFile);
        log.info((CharSequence)("LOCK " + remoteFile + '/' + repositoryName));
        remoteFile.lockFile(repositoryName, this.ignoreLock);
        File downloadedRepositoryXml = null;
        try {
            block6: {
                try {
                    log.info((CharSequence)("Downloading " + repositoryName));
                    downloadedRepositoryXml = remoteFile.get(repositoryName, ".xml");
                    String mavenRepository = this.localRepository.getBasedir();
                    URI repositoryXml = downloadedRepositoryXml.toURI();
                    URI obrXmlFile = ObrUtils.findObrXml(this.project.getResources());
                    URI bundleJar = ObrUtils.findBundleJar(this.localRepository, this.project.getArtifact());
                    Config userConfig = new Config();
                    userConfig.setPathRelative(true);
                    userConfig.setRemoteFile(true);
                    ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, this.project, bundleJar, mavenRepository, userConfig, log);
                    update.updateRepository();
                    if (!downloadedRepositoryXml.exists()) break block6;
                    log.info((CharSequence)("Uploading " + repositoryName));
                    remoteFile.put(downloadedRepositoryXml, repositoryName);
                }
                catch (Exception e) {
                    log.warn((CharSequence)("Exception while updating remote OBR: " + e.getLocalizedMessage()), (Throwable)e);
                    Object var13_14 = null;
                    log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
                    remoteFile.unlockFile(repositoryName);
                    remoteFile.disconnect();
                    if (null == downloadedRepositoryXml) return;
                    downloadedRepositoryXml.delete();
                    return;
                }
            }
            Object var13_13 = null;
            log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
            remoteFile.unlockFile(repositoryName);
            remoteFile.disconnect();
            if (null == downloadedRepositoryXml) return;
            downloadedRepositoryXml.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
            remoteFile.unlockFile(repositoryName);
            remoteFile.disconnect();
            if (null == downloadedRepositoryXml) throw throwable;
            downloadedRepositoryXml.delete();
            throw throwable;
        }
    }

    private void openRepositoryConnection(RemoteFileManager remoteFile) throws MojoExecutionException {
        if (this.deploymentRepository == null && this.altDeploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        if (this.altDeploymentRepository != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + this.altDeploymentRepository));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoExecutionException("Invalid syntax for alternative repository \"" + this.altDeploymentRepository + "\". Use \"id::layout::url\".");
            }
            remoteFile.connect(matcher.group(1).trim(), matcher.group(3).trim());
        } else {
            remoteFile.connect(this.deploymentRepository.getId(), this.deploymentRepository.getUrl());
        }
    }
}

