/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.PathFile;
import org.apache.felix.obr.plugin.RemoteFileManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;

public class ObrDeployFile
extends AbstractMojo {
    private Settings m_settings;
    private String m_repositoryName;
    private ArtifactRepository m_localRepo;
    private MavenProject m_project;
    private WagonManager m_wagonManager;
    private String m_obrFile;
    private boolean m_ignoreLock;
    private String m_fileInLocalRepo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Obr-deploy-file start:");
        ArtifactRepository ar = this.m_project.getDistributionManagementArtifactRepository();
        PathFile fileObrXml = new PathFile(this.m_obrFile);
        if (!fileObrXml.isExists()) {
            this.getLog().warn((CharSequence)"obr.xml file not found, use default");
        }
        File repoDescriptorFile = null;
        RemoteFileManager remoteFile = new RemoteFileManager(ar, this.m_wagonManager, this.m_settings, this.getLog());
        remoteFile.connect();
        File lockFile = null;
        BufferedWriter output = null;
        try {
            lockFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), null);
            output = new BufferedWriter(new FileWriter(lockFile));
            output.write("locked");
            ((Writer)output).close();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to create temporary file");
            throw new MojoFailureException("IOException");
        }
        if (this.m_ignoreLock) {
            try {
                remoteFile.put(lockFile, this.m_repositoryName + ".lock");
            }
            catch (TransferFailedException e) {
                this.getLog().error((CharSequence)"Transfer failed");
                e.printStackTrace();
                throw new MojoFailureException("TransferFailedException");
            }
            catch (ResourceDoesNotExistException e) {
                throw new MojoFailureException("ResourceDoesNotExistException");
            }
            catch (AuthorizationException e) {
                this.getLog().error((CharSequence)"Authorization failed");
                e.printStackTrace();
                throw new MojoFailureException("AuthorizationException");
            }
        } else {
            int countError = 0;
            while (remoteFile.isLockedFile(remoteFile, this.m_repositoryName) && countError < 2) {
                ++countError;
                this.getLog().warn((CharSequence)"File is locked, retry in 10s");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    this.getLog().warn((CharSequence)"Sleep Interupted");
                }
            }
            if (countError == 2) {
                this.getLog().error((CharSequence)("File: " + this.m_repositoryName + " is locked. Try -Dignore-lock=true if you want to force uploading"));
                throw new MojoFailureException("fileLocked");
            }
        }
        try {
            remoteFile.put(lockFile, this.m_repositoryName + ".lock");
        }
        catch (TransferFailedException e) {
            this.getLog().error((CharSequence)"Transfer failed");
            e.printStackTrace();
            throw new MojoFailureException("TransferFailedException");
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoFailureException("ResourceDoesNotExistException");
        }
        catch (AuthorizationException e) {
            this.getLog().error((CharSequence)"Authorization failed");
            e.printStackTrace();
            throw new MojoFailureException("AuthorizationException");
        }
        try {
            repoDescriptorFile = remoteFile.get(this.m_repositoryName);
        }
        catch (TransferFailedException e) {
            this.getLog().error((CharSequence)"Transfer failed");
            e.printStackTrace();
            throw new MojoFailureException("TransferFailedException");
        }
        catch (ResourceDoesNotExistException e) {
            this.getLog().warn((CharSequence)("file specified does not exist: " + this.m_repositoryName));
            this.getLog().warn((CharSequence)("Create a new repository descriptor file " + this.m_repositoryName));
            try {
                File f = File.createTempFile(String.valueOf(System.currentTimeMillis()), null);
                repoDescriptorFile = new File(f.getParent() + File.separator + String.valueOf(System.currentTimeMillis()) + ".xml");
            }
            catch (IOException e1) {
                this.getLog().error((CharSequence)"canno't create temporary file");
                e1.printStackTrace();
                return;
            }
        }
        catch (AuthorizationException e) {
            this.getLog().error((CharSequence)"Authorization failed");
            e.printStackTrace();
            throw new MojoFailureException("AuthorizationException");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException("IOException");
        }
        Config userConfig = new Config();
        userConfig.setPathRelative(true);
        userConfig.setRemotely(true);
        PathFile file = null;
        file = new PathFile(PathFile.uniformSeparator(this.m_settings.getLocalRepository()) + File.separator + PathFile.uniformSeparator(this.m_localRepo.pathOf(this.m_project.getArtifact())));
        if (!file.isExists()) {
            this.getLog().error((CharSequence)("file not found in local repository: " + this.m_settings.getLocalRepository() + File.separator + this.m_localRepo.pathOf(this.m_project.getArtifact())));
            return;
        }
        this.m_fileInLocalRepo = file.getOnlyAbsoluteFilename();
        file = new PathFile("file:/" + repoDescriptorFile.getAbsolutePath());
        ObrUpdate obrUpdate = new ObrUpdate(file, fileObrXml.getOnlyAbsoluteFilename(), this.m_project, this.m_fileInLocalRepo, PathFile.uniformSeparator(this.m_settings.getLocalRepository()), userConfig, this.getLog());
        obrUpdate.updateRepository();
        try {
            remoteFile.put(repoDescriptorFile, this.m_repositoryName);
        }
        catch (TransferFailedException e) {
            this.getLog().error((CharSequence)"Transfer failed");
            e.printStackTrace();
            throw new MojoFailureException("TransferFailedException");
        }
        catch (ResourceDoesNotExistException e) {
            this.getLog().error((CharSequence)("Resource does not exist:" + repoDescriptorFile.getName()));
            e.printStackTrace();
            throw new MojoFailureException("ResourceDoesNotExistException");
        }
        catch (AuthorizationException e) {
            this.getLog().error((CharSequence)"Authorization failed");
            e.printStackTrace();
            throw new MojoFailureException("AuthorizationException");
        }
        repoDescriptorFile.delete();
        lockFile = null;
        try {
            lockFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException("IOException");
        }
        try {
            remoteFile.put(lockFile, this.m_repositoryName + ".lock");
        }
        catch (TransferFailedException e) {
            this.getLog().error((CharSequence)"Transfer failed");
            e.printStackTrace();
            throw new MojoFailureException("TransferFailedException");
        }
        catch (ResourceDoesNotExistException e) {
            e.printStackTrace();
            throw new MojoFailureException("ResourceDoesNotExistException");
        }
        catch (AuthorizationException e) {
            this.getLog().error((CharSequence)"Authorization failed");
            e.printStackTrace();
            throw new MojoFailureException("AuthorizationException");
        }
        remoteFile.disconnect();
    }
}

