/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.libg.generics.Create;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;

public class BlueprintPlugin
implements AnalyzerPlugin {
    static Pattern QN = Pattern.compile("[_A-Za-z$][_A-Za-z0-9$]*(\\.[_A-Za-z$][_A-Za-z0-9$]*)*");
    static Pattern PATHS = Pattern.compile(".*\\.xml");
    Transformer transformer = this.getTransformer(this.getClass().getResource("blueprint.xsl"));

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        String header2;
        StringBuilder sb;
        String mode = analyzer.getProperty("service_mode");
        if (mode == null) {
            mode = "service";
        }
        this.transformer.setParameter("nsh_interface", analyzer.getProperty("nsh_interface") != null ? analyzer.getProperty("nsh_interface") : "");
        this.transformer.setParameter("nsh_namespace", analyzer.getProperty("nsh_namespace") != null ? analyzer.getProperty("nsh_namespace") : "");
        Set headers = Create.set();
        String bpHeader = analyzer.getProperty("Bundle-Blueprint", "OSGI-INF/blueprint");
        Parameters map = Processor.parseHeader((String)bpHeader, null);
        bpHeader = "";
        for (String root : map.keySet()) {
            Jar jar = analyzer.getJar();
            Map dir = (Map)jar.getDirectories().get(root);
            if (dir == null || dir.isEmpty()) {
                Resource resource = jar.getResource(root);
                if (resource == null) continue;
                this.process(analyzer, root, resource, headers);
                if (bpHeader.length() > 0) {
                    bpHeader = bpHeader + ",";
                }
                bpHeader = bpHeader + root;
                continue;
            }
            for (Map.Entry entry : dir.entrySet()) {
                String path = (String)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                if (!PATHS.matcher(path).matches()) continue;
                this.process(analyzer, path, resource, headers);
                if (bpHeader.length() > 0) {
                    bpHeader = bpHeader + ",";
                }
                bpHeader = bpHeader + path;
            }
        }
        if (!map.isEmpty()) {
            analyzer.setProperty("Bundle-Blueprint", bpHeader);
        }
        Set caps = Create.set();
        Set reqs = Create.set();
        Map hdrs = Create.map();
        for (String str : headers) {
            Set<Clause> clauses;
            int idx = str.indexOf(58);
            if (idx < 0) {
                analyzer.warning("Error analyzing services in blueprint resource: " + str, new Object[0]);
                continue;
            }
            String h = str.substring(0, idx).trim();
            String v = str.substring(idx + 1).trim();
            Clause[] hc = Parser.parseHeader((String)v);
            if ("Import-Service".equals(h)) {
                if (!"service".equals(mode)) {
                    Clause clause = hc[0];
                    String multiple = clause.getDirective("multiple");
                    String avail = clause.getDirective("availability");
                    String filter = clause.getAttribute("filter");
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("osgi.service;effective:=active;");
                    if ("optional".equals(avail)) {
                        sb2.append("resolution:=optional;");
                    }
                    if ("true".equals(multiple)) {
                        sb2.append("cardinality:=multiple;");
                    }
                    filter = filter == null ? "(objectClass=" + clause.getName() + ")" : (!filter.startsWith("(") && !filter.endsWith(")") ? "(&(objectClass=" + clause.getName() + ")(" + filter + "))" : "(&(objectClass=" + clause.getName() + ")" + filter + ")");
                    sb2.append("filter:=\"").append(filter).append("\"");
                    reqs.add(sb2.toString());
                    continue;
                }
                if ("generic".equals(mode)) continue;
                clauses = (Set)hdrs.get(h);
                if (clauses == null) {
                    clauses = new HashSet();
                    hdrs.put(h, clauses);
                }
                clauses.addAll(Arrays.asList(hc));
                continue;
            }
            if ("Export-Service".equals(h)) {
                if (!"service".equals(mode)) {
                    int i;
                    StringBuilder sb3 = new StringBuilder();
                    sb3.append("osgi.service;effective:=active;objectClass");
                    if (hc.length > 1) {
                        sb3.append(":List<String>=\"");
                    } else {
                        sb3.append("=\"");
                    }
                    for (i = 0; i < hc.length; ++i) {
                        if (i > 0) {
                            sb3.append(",");
                        }
                        sb3.append(hc[i].getName());
                    }
                    sb3.append("\"");
                    for (i = 0; i < hc[0].getAttributes().length; ++i) {
                        sb3.append(";");
                        sb3.append(hc[0].getAttributes()[i].getName());
                        sb3.append("=\"");
                        sb3.append(hc[0].getAttributes()[i].getValue());
                        sb3.append("\"");
                    }
                    caps.add(sb3.toString());
                    continue;
                }
                if ("generic".equals(mode)) continue;
                clauses = (Set)hdrs.get(h);
                if (clauses == null) {
                    clauses = new HashSet();
                    hdrs.put(h, clauses);
                }
                clauses.addAll(Arrays.asList(hc));
                continue;
            }
            clauses = (HashSet<Clause>)hdrs.get(h);
            if (clauses == null) {
                clauses = new HashSet<Clause>();
                hdrs.put(h, clauses);
            }
            clauses.addAll(Arrays.asList(hc));
        }
        if (!caps.isEmpty()) {
            sb = new StringBuilder();
            header2 = analyzer.getProperty("Provide-Capability");
            if (header2 != null) {
                sb.append(header2);
            }
            for (String cap : caps) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(cap);
            }
            analyzer.setProperty("Provide-Capability", sb.toString());
        }
        if (!reqs.isEmpty()) {
            sb = new StringBuilder();
            header2 = analyzer.getProperty("Require-Capability");
            if (header2 != null) {
                sb.append(header2);
            }
            for (String req : reqs) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(req);
            }
            analyzer.setProperty("Require-Capability", sb.toString());
        }
        for (String header2 : hdrs.keySet()) {
            if ("Import-Class".equals(header2) || "Import-Package".equals(header2)) {
                Set newAttr = (Set)hdrs.get(header2);
                for (Clause a : newAttr) {
                    String pkg = a.getName();
                    if ("Import-Class".equals(header2)) {
                        int n = a.getName().lastIndexOf(46);
                        if (n <= 0) continue;
                        pkg = pkg.subSequence(0, n).toString();
                    }
                    Descriptors.PackageRef pkgRef = analyzer.getPackageRef(pkg);
                    if (analyzer.getReferred().containsKey(pkgRef)) continue;
                    Attrs attrs = analyzer.getReferred().put(pkgRef);
                    for (Attribute attribute : a.getAttributes()) {
                        attrs.put(attribute.getName(), attribute.getValue());
                    }
                }
                continue;
            }
            Set merge = Create.set();
            String org = analyzer.getProperty(header2);
            if (org != null && !org.isEmpty()) {
                for (Clause clause : Parser.parseHeader((String)org)) {
                    merge.add(clause.toString());
                }
            }
            for (Clause clause : (Set)hdrs.get(header2)) {
                merge.add(clause.toString());
            }
            StringBuilder sb4 = new StringBuilder();
            for (String clause : merge) {
                if (sb4.length() > 0) {
                    sb4.append(",");
                }
                sb4.append(clause);
            }
            analyzer.setProperty(header2, sb4.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Analyzer analyzer, String path, Resource resource, Set<String> headers) {
        InputStream in = null;
        try {
            in = resource.openInputStream();
            Set<String> set = this.analyze(in);
            headers.addAll(set);
        }
        catch (Exception e) {
            analyzer.error("Unexpected exception in processing spring resources(" + path + "): " + e, new Object[0]);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Set<String> analyze(InputStream in) throws Exception {
        HashSet<String> refers = new HashSet<String>();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(bout);
        StreamSource s = new StreamSource(in);
        this.transformer.transform(s, r);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        bout.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String line = br.readLine();
        while (line != null) {
            line = line.trim();
            if ((line = line.replace(";availability:=mandatory", "")).length() > 0) {
                refers.add(line);
            }
            line = br.readLine();
        }
        br.close();
        return refers;
    }

    protected Transformer getTransformer(URL url) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(url.openStream());
        return tf.newTransformer(source);
    }
}

