/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.apache.felix.bundleplugin.DependencyEmbedder;
import org.apache.felix.bundleplugin.JarPluginConfiguration;
import org.apache.felix.bundleplugin.ManifestPlugin;
import org.apache.maven.archiver.ManifestSection;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;

public class BundlePlugin
extends AbstractMojo {
    protected File manifestLocation;
    protected boolean unpackBundle;
    protected String excludeDependencies;
    protected String classifier;
    private MavenProjectHelper m_projectHelper;
    private ArchiverManager m_archiverManager;
    private ArtifactHandlerManager m_artifactHandlerManager;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private File outputDirectory;
    private File baseDir;
    private String buildDirectory;
    private MavenProject project;
    private Map instructions = new HashMap();
    private Maven2OsgiConverter m_maven2OsgiConverter;
    private static final String MAVEN_RESOURCES = "{maven-resources}";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    static /* synthetic */ Class class$org$apache$maven$model$Model;

    protected Maven2OsgiConverter getMaven2OsgiConverter() {
        return this.m_maven2OsgiConverter;
    }

    protected void setMaven2OsgiConverter(Maven2OsgiConverter maven2OsgiConverter) {
        this.m_maven2OsgiConverter = maven2OsgiConverter;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoExecutionException {
        Properties properties = new Properties();
        String projectType = this.getProject().getArtifact().getType();
        if (!this.supportedProjectTypes.contains(projectType)) {
            this.getLog().warn((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            return;
        }
        this.execute(this.getProject(), this.instructions, properties);
    }

    protected void execute(MavenProject currentProject, Map originalInstructions, Properties properties) throws MojoExecutionException {
        try {
            this.execute(currentProject, originalInstructions, properties, this.getClasspath(currentProject));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error calculating classpath for project " + currentProject, (Exception)e);
        }
    }

    protected static Map transformDirectives(Map originalInstructions) {
        HashMap<String, String> transformedInstructions = new HashMap<String, String>();
        Iterator i = originalInstructions.entrySet().iterator();
        while (i.hasNext()) {
            String value;
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            if (key.startsWith("_")) {
                key = "-" + key.substring(1);
            }
            value = null == (value = (String)e.getValue()) ? "" : value.replaceAll("[\r\n]", "");
            transformedInstructions.put(key, value);
        }
        return transformedInstructions;
    }

    protected void execute(MavenProject currentProject, Map originalInstructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        try {
            String failok;
            String msg;
            File jarFile = new File(this.getBuildDirectory(), this.getBundleName(currentProject));
            Builder builder = this.buildOSGiBundle(currentProject, originalInstructions, properties, classpath);
            List errors = builder.getErrors();
            List warnings = builder.getWarnings();
            Iterator w = warnings.iterator();
            while (w.hasNext()) {
                msg = (String)w.next();
                this.getLog().warn((CharSequence)("Warning building bundle " + currentProject.getArtifact() + " : " + msg));
            }
            Iterator e = errors.iterator();
            while (e.hasNext()) {
                msg = (String)e.next();
                this.getLog().error((CharSequence)("Error building bundle " + currentProject.getArtifact() + " : " + msg));
            }
            if (errors.size() > 0 && (null == (failok = properties.getProperty("-failok")) || "false".equalsIgnoreCase(failok))) {
                jarFile.delete();
                throw new MojoFailureException("Error(s) found in bundle configuration");
            }
            jarFile.getParentFile().mkdirs();
            builder.getJar().write(jarFile);
            Artifact mainArtifact = currentProject.getArtifact();
            mainArtifact.setArtifactHandler(this.m_artifactHandlerManager.getArtifactHandler("jar"));
            if (null == this.classifier || this.classifier.trim().length() == 0) {
                mainArtifact.setFile(jarFile);
            } else {
                this.m_projectHelper.attachArtifact(currentProject, jarFile, this.classifier);
            }
            if (this.unpackBundle) {
                this.unpackBundle(jarFile);
            }
            if (this.manifestLocation != null) {
                File outputFile = new File(this.manifestLocation, "MANIFEST.MF");
                try {
                    Manifest manifest = builder.getJar().getManifest();
                    ManifestPlugin.writeManifest(manifest, outputFile);
                }
                catch (IOException e2) {
                    this.getLog().error((CharSequence)("Error trying to write Manifest to file " + outputFile), (Throwable)e2);
                }
            }
        }
        catch (MojoFailureException e) {
            this.getLog().error((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException("Error(s) found in bundle configuration", (Exception)((Object)e));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An internal error occurred", (Throwable)e);
            throw new MojoExecutionException("Internal error in maven-bundle-plugin", e);
        }
    }

    protected Builder buildOSGiBundle(MavenProject currentProject, Map originalInstructions, Properties properties, Jar[] classpath) throws Exception {
        properties.putAll((Map<?, ?>)this.getDefaultProperties(currentProject));
        properties.putAll((Map<?, ?>)BundlePlugin.transformDirectives(originalInstructions));
        Builder builder = new Builder();
        builder.setBase(currentProject.getBasedir());
        builder.setProperties(properties);
        builder.setClasspath(classpath);
        BundlePlugin.includeMavenResources(currentProject, properties, this.getLog());
        if (!properties.containsKey("Export-Package") && !properties.containsKey("Private-Package")) {
            if (properties.containsKey("-exportcontents")) {
                properties.put("Private-Package", "!*");
            } else {
                String bsn = properties.getProperty("Bundle-SymbolicName");
                String namespace = bsn.replaceAll("\\W", ".");
                properties.put("Export-Package", namespace + ".*");
            }
        }
        Collection embeddableArtifacts = BundlePlugin.getEmbeddableArtifacts(currentProject, properties);
        new DependencyEmbedder(embeddableArtifacts).processHeaders(properties);
        builder.build();
        Jar jar = builder.getJar();
        this.doMavenMetadata(currentProject, jar);
        builder.setJar(jar);
        String[] removeHeaders = properties.getProperty("-removeheaders", "").split(",");
        BundlePlugin.mergeMavenManifest(currentProject, jar, removeHeaders, this.getLog());
        return builder;
    }

    protected static void includeMavenResources(MavenProject currentProject, Properties properties, Log log) {
        String mavenResourcePaths = BundlePlugin.getMavenResourcePaths(currentProject);
        String includeResource = (String)properties.get("Include-Resource");
        if (includeResource != null) {
            if (includeResource.indexOf(MAVEN_RESOURCES) >= 0) {
                if (mavenResourcePaths.length() == 0) {
                    String cleanedResource = BundlePlugin.removeTagFromInstruction(includeResource, MAVEN_RESOURCES);
                    if (cleanedResource.length() > 0) {
                        properties.put("Include-Resource", cleanedResource);
                    } else {
                        properties.remove("Include-Resource");
                    }
                } else {
                    String combinedResource = StringUtils.replace((String)includeResource, (String)MAVEN_RESOURCES, (String)mavenResourcePaths);
                    properties.put("Include-Resource", combinedResource);
                }
            } else if (mavenResourcePaths.length() > 0) {
                log.warn((CharSequence)("Include-Resource: overriding " + mavenResourcePaths + " with " + includeResource + " (add " + MAVEN_RESOURCES + " if you want to include the maven resources)"));
            }
        } else if (mavenResourcePaths.length() > 0) {
            properties.put("Include-Resource", mavenResourcePaths);
        }
    }

    protected static void mergeMavenManifest(MavenProject currentProject, Jar jar, String[] removeHeaders, Log log) {
        try {
            MavenArchiveConfiguration archiveConfig = JarPluginConfiguration.getArchiveConfiguration(currentProject);
            String mavenManifestText = new MavenArchiver().getManifest(currentProject, archiveConfig).toString();
            Manifest mavenManifest = new Manifest();
            File externalManifestFile = archiveConfig.getManifestFile();
            if (null != externalManifestFile && externalManifestFile.exists()) {
                FileInputStream mis = new FileInputStream(externalManifestFile);
                mavenManifest.read(mis);
                ((InputStream)mis).close();
            }
            mavenManifest.read((InputStream)new StringInputStream(mavenManifestText));
            if (!archiveConfig.isManifestSectionsEmpty()) {
                List sections = archiveConfig.getManifestSections();
                Iterator i = sections.iterator();
                while (i.hasNext()) {
                    ManifestSection section = (ManifestSection)i.next();
                    Attributes attributes = new Attributes();
                    if (!section.isManifestEntriesEmpty()) {
                        Map entries = section.getManifestEntries();
                        Iterator j = entries.entrySet().iterator();
                        while (j.hasNext()) {
                            Map.Entry entry = j.next();
                            attributes.putValue((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    mavenManifest.getEntries().put(section.getName(), attributes);
                }
            }
            Attributes mainMavenAttributes = mavenManifest.getMainAttributes();
            mainMavenAttributes.putValue("Created-By", "Apache Maven Bundle Plugin");
            for (int i = 0; i < removeHeaders.length; ++i) {
                Iterator<Object> j = mainMavenAttributes.keySet().iterator();
                while (j.hasNext()) {
                    if (!j.next().toString().matches(removeHeaders[i].trim())) continue;
                    j.remove();
                }
            }
            Manifest bundleManifest = jar.getManifest();
            bundleManifest.getMainAttributes().putAll((Map<?, ?>)mainMavenAttributes);
            bundleManifest.getEntries().putAll(mavenManifest.getEntries());
            jar.setManifest(bundleManifest);
        }
        catch (Exception e) {
            log.warn((CharSequence)("Unable to merge Maven manifest: " + e.getLocalizedMessage()));
        }
    }

    private void unpackBundle(File jarFile) {
        File outputDir = this.getOutputDirectory();
        if (null == outputDir) {
            outputDir = new File(this.getBuildDirectory(), "classes");
        }
        try {
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            UnArchiver unArchiver = this.m_archiverManager.getUnArchiver("jar");
            unArchiver.setDestDirectory(outputDir);
            unArchiver.setSourceFile(jarFile);
            unArchiver.extract();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Problem unpacking " + jarFile + " to " + outputDir), (Throwable)e);
        }
    }

    protected static String removeTagFromInstruction(String instruction, String tag) {
        StringBuffer buf = new StringBuffer();
        String[] clauses = instruction.split(",");
        for (int i = 0; i < clauses.length; ++i) {
            String clause = clauses[i].trim();
            if (tag.equals(clause)) continue;
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(clause);
        }
        return buf.toString();
    }

    private static Map getProperties(Model projectModel, String prefix) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Method[] methods = (class$org$apache$maven$model$Model == null ? (class$org$apache$maven$model$Model = BundlePlugin.class$("org.apache.maven.model.Model")) : class$org$apache$maven$model$Model).getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            try {
                Object v = methods[i].invoke((Object)projectModel, null);
                if (v == null) continue;
                name = prefix + Character.toLowerCase(name.charAt(3)) + name.substring(4);
                if (v.getClass().isArray()) {
                    properties.put(name, Arrays.asList((Object[])v).toString());
                    continue;
                }
                properties.put(name, v);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return properties;
    }

    private static StringBuffer printLicenses(List licenses) {
        if (licenses == null || licenses.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        Iterator i = licenses.iterator();
        while (i.hasNext()) {
            License l = (License)i.next();
            String url = l.getUrl();
            if (url == null) continue;
            sb.append(del);
            sb.append(url);
            del = ", ";
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb;
    }

    private void doMavenMetadata(MavenProject currentProject, Jar jar) throws IOException {
        String path = "META-INF/maven/" + currentProject.getGroupId() + "/" + currentProject.getArtifactId();
        File pomFile = new File(this.baseDir, "pom.xml");
        jar.putResource(path + "/pom.xml", (Resource)new FileResource(pomFile));
        Properties p = new Properties();
        p.put("version", currentProject.getVersion());
        p.put("groupId", currentProject.getGroupId());
        p.put("artifactId", currentProject.getArtifactId());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        p.store(out, "Generated by org.apache.felix.bundleplugin");
        jar.putResource(path + "/pom.properties", (Resource)new EmbeddedResource(out.toByteArray(), System.currentTimeMillis()));
    }

    protected Jar[] getClasspath(MavenProject currentProject) throws ZipException, IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        if (this.getOutputDirectory() != null && this.getOutputDirectory().exists()) {
            list.add(new Jar(".", this.getOutputDirectory()));
        }
        Collection artifacts = this.getSelectedDependencies(currentProject.getArtifacts());
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!artifact.getArtifactHandler().isAddedToClasspath() || !"compile".equals(artifact.getScope()) && !"system".equals(artifact.getScope()) && !"provided".equals(artifact.getScope())) continue;
            File file = this.getFile(artifact);
            if (file == null) {
                this.getLog().warn((CharSequence)("File is not available for artifact " + artifact + " in project " + currentProject.getArtifact()));
                continue;
            }
            Jar jar = new Jar(artifact.getArtifactId(), file);
            list.add(jar);
        }
        Jar[] cp = new Jar[list.size()];
        list.toArray(cp);
        return cp;
    }

    private Collection getSelectedDependencies(Set artifacts) {
        if (null == this.excludeDependencies || this.excludeDependencies.length() == 0) {
            return artifacts;
        }
        if ("true".equalsIgnoreCase(this.excludeDependencies)) {
            return Collections.EMPTY_LIST;
        }
        List<String> excludes = Arrays.asList(this.excludeDependencies.trim().split("\\s*,\\s*"));
        ArrayList<Artifact> classpath = new ArrayList<Artifact>();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (excludes.contains(artifact.getArtifactId())) continue;
            classpath.add(artifact);
        }
        return classpath;
    }

    protected File getFile(Artifact artifact) {
        return artifact.getFile();
    }

    private static void header(Properties properties, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        properties.put(key, value.toString().replaceAll("[\r\n]", ""));
    }

    protected String convertVersionToOsgi(String version) {
        return this.getMaven2OsgiConverter().getVersion(version);
    }

    protected String getBundleName(MavenProject currentProject) {
        String finalName = currentProject.getBuild().getFinalName();
        if (null != this.classifier && this.classifier.trim().length() > 0) {
            return finalName + '-' + this.classifier + ".jar";
        }
        return finalName + ".jar";
    }

    protected String getBuildDirectory() {
        return this.buildDirectory;
    }

    protected void setBuildDirectory(String _buildirectory) {
        this.buildDirectory = _buildirectory;
    }

    protected Properties getDefaultProperties(MavenProject currentProject) {
        String bsn;
        Properties properties = new Properties();
        try {
            bsn = this.getMaven2OsgiConverter().getBundleSymbolicName(currentProject.getArtifact());
        }
        catch (Exception e) {
            bsn = currentProject.getGroupId() + "." + currentProject.getArtifactId();
        }
        properties.put("Bundle-SymbolicName", bsn);
        properties.put("Import-Package", "*");
        properties.put("Bundle-Version", currentProject.getVersion());
        properties.put("-removeheaders", "Include-Resource");
        BundlePlugin.header(properties, "Bundle-Description", currentProject.getDescription());
        StringBuffer licenseText = BundlePlugin.printLicenses(currentProject.getLicenses());
        if (licenseText != null) {
            BundlePlugin.header(properties, "Bundle-License", licenseText);
        }
        BundlePlugin.header(properties, "Bundle-Name", currentProject.getName());
        if (currentProject.getOrganization() != null) {
            BundlePlugin.header(properties, "Bundle-Vendor", currentProject.getOrganization().getName());
            if (currentProject.getOrganization().getUrl() != null) {
                BundlePlugin.header(properties, "Bundle-DocURL", currentProject.getOrganization().getUrl());
            }
        }
        properties.putAll((Map<?, ?>)currentProject.getProperties());
        properties.putAll((Map<?, ?>)currentProject.getModel().getProperties());
        properties.putAll((Map<?, ?>)BundlePlugin.getProperties(currentProject.getModel(), "project.build."));
        properties.putAll((Map<?, ?>)BundlePlugin.getProperties(currentProject.getModel(), "pom."));
        properties.putAll((Map<?, ?>)BundlePlugin.getProperties(currentProject.getModel(), "project."));
        properties.put("project.baseDir", this.baseDir);
        properties.put("project.build.directory", this.getBuildDirectory());
        properties.put("project.build.outputdirectory", this.getOutputDirectory());
        properties.put("classifier", this.classifier == null ? "" : this.classifier);
        return properties;
    }

    protected void setBasedir(File _basedir) {
        this.baseDir = _basedir;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void setOutputDirectory(File _outputDirectory) {
        this.outputDirectory = _outputDirectory;
    }

    private static String getMavenResourcePaths(MavenProject project) {
        String basePath = project.getBasedir().getAbsolutePath();
        StringBuffer resourcePaths = new StringBuffer();
        Iterator i = project.getResources().iterator();
        while (i.hasNext()) {
            org.apache.maven.model.Resource resource = (org.apache.maven.model.Resource)i.next();
            String sourcePath = resource.getDirectory();
            String targetPath = resource.getTargetPath();
            if (!new File(sourcePath).exists() || targetPath != null && targetPath.indexOf("..") >= 0) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resource.getDirectory());
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name = j.next();
                String path = sourcePath + '/' + name;
                if (path.startsWith(basePath)) {
                    path = path.length() == basePath.length() ? "." : path.substring(basePath.length() + 1);
                }
                if (File.separatorChar != '/') {
                    name = name.replace(File.separatorChar, '/');
                    path = path.replace(File.separatorChar, '/');
                }
                path = name + '=' + path;
                if (targetPath != null) {
                    path = targetPath + '/' + path;
                }
                if (resourcePaths.length() > 0) {
                    resourcePaths.append(',');
                }
                if (resource.isFiltering()) {
                    resourcePaths.append('{');
                    resourcePaths.append(path);
                    resourcePaths.append('}');
                    continue;
                }
                resourcePaths.append(path);
            }
        }
        return resourcePaths.toString();
    }

    protected static Collection getEmbeddableArtifacts(MavenProject project, Properties properties) {
        String embedTransitive = properties.getProperty("Embed-Transitive");
        if (Boolean.valueOf(embedTransitive).booleanValue()) {
            return project.getArtifacts();
        }
        return project.getDependencyArtifacts();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

