/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.jsoncontrol;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.edgent.execution.services.ControlService;
import org.apache.edgent.execution.services.Controls;
import org.apache.edgent.runtime.jsoncontrol.ControlMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonControlService
implements ControlService {
    private static final Logger logger = LoggerFactory.getLogger(ControlService.class);
    public static final String TYPE_KEY = "type";
    public static final String ALIAS_KEY = "alias";
    public static final String OP_KEY = "op";
    public static final String ARGS_KEY = "args";
    private final Gson gson = new Gson();
    private final Map<String, ControlMBean<?>> mbeans = new HashMap();

    private static String getControlId(String type, String id, String alias) {
        return type + ":" + (alias == null ? id : alias);
    }

    public JsonElement controlRequest(JsonObject request) throws Exception {
        if (request.has(OP_KEY)) {
            return this.controlOperation(request);
        }
        return JsonNull.INSTANCE;
    }

    public synchronized <T> String registerControl(String type, String id, String alias, Class<T> controlInterface, T control) {
        if (!Controls.isControlServiceMBean(controlInterface)) {
            throw new IllegalArgumentException();
        }
        String controlId = JsonControlService.getControlId(type, id, alias);
        if (this.mbeans.containsKey(controlId)) {
            logger.error("Control id: {} already exists", (Object)controlId);
            throw new IllegalStateException();
        }
        logger.trace("Register control id: {}", (Object)controlId);
        this.mbeans.put(controlId, new ControlMBean<T>(controlInterface, control));
        return controlId;
    }

    public synchronized void unregister(String controlId) {
        logger.trace("Unegister control id: {}", (Object)controlId);
        this.mbeans.remove(controlId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonElement controlOperation(JsonObject request) throws Exception {
        Method method;
        ControlMBean<?> mbean;
        String type = request.get(TYPE_KEY).getAsString();
        String alias = request.get(ALIAS_KEY).getAsString();
        String controlId = JsonControlService.getControlId(type, null, alias);
        logger.trace("Operation - control id: {}", (Object)controlId);
        JsonControlService jsonControlService = this;
        synchronized (jsonControlService) {
            mbean = this.mbeans.get(controlId);
        }
        if (mbean == null) {
            logger.warn("Unable to find mbean for control id: {}", (Object)controlId);
            return new JsonPrimitive(Boolean.FALSE);
        }
        String methodName = request.get(OP_KEY).getAsString();
        logger.trace("Operation method - control id: {} method: {}", (Object)controlId, (Object)methodName);
        int argumentCount = 0;
        JsonArray args = null;
        if (request.has(ARGS_KEY)) {
            args = request.getAsJsonArray(ARGS_KEY);
            argumentCount = args.size();
        }
        if ((method = this.findMethod(mbean.getControlInterface(), methodName, argumentCount)) == null) {
            logger.warn("Unable to find method \"{}\" with {} args in {}", new Object[]{methodName, argumentCount, mbean.getControlInterface().getName()});
            return new JsonPrimitive(Boolean.FALSE);
        }
        logger.trace("Execute operation - control id: {} method: {}", (Object)controlId, (Object)methodName);
        this.executeMethod(method, mbean.getControl(), this.getArguments(method, args));
        logger.trace("Execute completed - control id: {} method: {}", (Object)controlId, (Object)methodName);
        return new JsonPrimitive(Boolean.TRUE);
    }

    private Method findMethod(Class<?> controlInterface, String name, int argumentCount) {
        Method[] methods;
        for (Method method : methods = controlInterface.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !name.equals(method.getName()) || method.getParameterTypes().length != argumentCount) continue;
            return method;
        }
        return null;
    }

    private Object[] getArguments(Method method, JsonArray args) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 0 || args == null || args.size() == 0) {
            return null;
        }
        assert (paramTypes.length == args.size());
        Object[] oargs = new Object[paramTypes.length];
        for (int i = 0; i < oargs.length; ++i) {
            Object jarg;
            Class<?> pt = paramTypes[i];
            JsonElement arg = args.get(i);
            if (String.class == pt) {
                jarg = arg instanceof JsonObject ? this.gson.toJson(arg) : arg.getAsString();
            } else if (Integer.TYPE == pt) {
                jarg = arg.getAsInt();
            } else if (Long.TYPE == pt) {
                jarg = arg.getAsLong();
            } else if (Double.TYPE == pt) {
                jarg = arg.getAsDouble();
            } else if (Boolean.TYPE == pt) {
                jarg = arg.getAsBoolean();
            } else if (pt.isEnum()) {
                jarg = Enum.valueOf(pt, arg.getAsString());
            } else {
                throw new UnsupportedOperationException(pt.getName());
            }
            oargs[i] = jarg;
        }
        return oargs;
    }

    private void executeMethod(Method method, Object control, Object[] arguments) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        method.invoke(control, arguments);
    }

    public <T> T getControl(String type, String alias, Class<T> controlInterface) {
        String controlId = JsonControlService.getControlId(type, null, alias);
        ControlMBean<?> bean = this.getControlMBean(controlId, controlInterface);
        return bean != null ? (T)controlInterface.cast(bean.getControl()) : null;
    }

    public <T> String getControlId(String type, String alias, Class<T> controlInterface) {
        String controlId = JsonControlService.getControlId(type, null, alias);
        return this.getControlMBean(controlId, controlInterface) != null ? controlId : null;
    }

    private synchronized <T> ControlMBean<?> getControlMBean(String controlId, Class<T> controlInterface) {
        ControlMBean<?> bean = this.mbeans.get(controlId);
        if (bean == null) {
            return null;
        }
        if (bean.getControlInterface() != controlInterface) {
            return null;
        }
        return bean;
    }
}

